/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports;

import bucket.core.actions.PaginationSupport;
import com.atlassian.confluence.core.persistence.AnyTypeDao;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.search.v2.BooleanOperator;
import com.atlassian.confluence.search.v2.ISearch;
import com.atlassian.confluence.search.v2.SearchManager;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.query.BooleanQuery;
import com.atlassian.confluence.search.v2.query.ContentTypeQuery;
import com.atlassian.confluence.search.v2.query.InSpaceQuery;
import com.atlassian.confluence.search.v2.query.LabelQuery;
import com.atlassian.confluence.search.v2.query.TextFieldQuery;
import com.comalatech.confluence.util.MiscUtils;
import com.comalatech.confluence.workflow.model.WorkflowsSearchConfluence8CompatibilityBuilder;
import com.comalatech.confluence.workflowreports.model.WorkflowReportOptions;
import com.comalatech.confluence.workflowreports.search.PageStateQuery;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractWorkflowReportCreator {
    private static final Logger log = LoggerFactory.getLogger(AbstractWorkflowReportCreator.class);
    protected static List<ContentTypeEnum> ABSTRACT_PAGES = Arrays.asList(ContentTypeEnum.PAGE, ContentTypeEnum.BLOG);
    protected final SearchManager searchManager;
    protected final AnyTypeDao anyTypeDao;

    public AbstractWorkflowReportCreator(SearchManager searchManager, AnyTypeDao anyTypeDao) {
        this.searchManager = searchManager;
        this.anyTypeDao = anyTypeDao;
    }

    protected void appendStateQuery(WorkflowReportOptions options, Collection<SearchQuery> queries) {
        List<String> stateNames = options.getStateNames();
        if (stateNames.size() == 1 && !this.isAnyState(stateNames)) {
            queries.add(new PageStateQuery(stateNames.get(0).toLowerCase().replace("_", " ")));
        } else if (stateNames.size() > 1) {
            HashSet<PageStateQuery> stateQueries = new HashSet<PageStateQuery>();
            for (String name : stateNames) {
                stateQueries.add(new PageStateQuery(name.toLowerCase()));
            }
            queries.add((SearchQuery)new BooleanQuery(null, stateQueries, null));
        } else if (stateNames.isEmpty() || this.isAnyState(stateNames)) {
            queries.add((SearchQuery)new TextFieldQuery("awphasworkflow", "t*", BooleanOperator.AND));
        }
    }

    private boolean isAnyState(List<String> stateNames) {
        return stateNames.get(0).equals("*");
    }

    protected ISearch createSearchObject(WorkflowReportOptions options, PaginationSupport paginationSupport, SearchQuery query) {
        return WorkflowsSearchConfluence8CompatibilityBuilder.getContentSearch(query, options.getSearchSort(), paginationSupport.getStartIndex(), paginationSupport.getPageSize());
    }

    protected void appendSpaceKeyQueries(String spaceKeys, Collection<SearchQuery> queries) {
        if (spaceKeys != null) {
            String[] keys = MiscUtils.splitAndTrim(spaceKeys);
            if (keys.length == 1) {
                queries.add((SearchQuery)new InSpaceQuery(spaceKeys));
            } else if (keys.length > 1) {
                HashSet<String> spaceKeysSet = new HashSet<String>(Arrays.asList(keys));
                queries.add((SearchQuery)new InSpaceQuery(spaceKeysSet));
            }
        }
    }

    protected void appendSpaceKeyQueries(Set<String> spaceKeys, Collection<SearchQuery> queries) {
        if (spaceKeys != null && !spaceKeys.isEmpty()) {
            queries.add((SearchQuery)new InSpaceQuery(spaceKeys));
        }
    }

    protected void addLabelQuery(WorkflowReportOptions options, Collection<SearchQuery> queries) {
        if (options.getLabels().isEmpty()) {
            return;
        }
        HashSet<LabelQuery> labelsQuery = new HashSet<LabelQuery>();
        for (Label label : options.getLabels()) {
            labelsQuery.add(new LabelQuery(label));
        }
        if (options.isMustHaveAllLabels() || labelsQuery.size() == 1) {
            queries.addAll(labelsQuery);
        } else {
            queries.add((SearchQuery)new BooleanQuery(null, labelsQuery, null));
        }
    }

    protected TextFieldQuery makeFieldQuery(String key, String value) {
        return new TextFieldQuery(key, value, BooleanOperator.AND);
    }

    protected Collection<SearchQuery> makeDefaultQueries(WorkflowReportOptions options) {
        HashSet<SearchQuery> queries = new HashSet<SearchQuery>();
        if (StringUtils.isNotBlank((CharSequence)options.getParentId())) {
            queries.add((SearchQuery)this.makeFieldQuery("ancestorIds", options.getParentId()));
        }
        this.addLabelQuery(options, queries);
        this.appendSpaceKeyQueries(options.getSpaceKey(), queries);
        queries.add((SearchQuery)new ContentTypeQuery(ABSTRACT_PAGES));
        for (Map.Entry<String, String> filterTerm : options.getFilterTerms().entrySet()) {
            queries.add((SearchQuery)new TextFieldQuery(filterTerm.getKey(), filterTerm.getValue(), BooleanOperator.AND));
        }
        return queries;
    }
}

