/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.transformer;

import com.atlassian.confluence.compat.struts2.actioncontext.ActionContextCompatManager;
import com.atlassian.confluence.compat.struts2.servletactioncontext.ServletActionContextCompatManager;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.core.BodyType;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.core.filters.ServletContextThreadLocal;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.workflow.ApprovalAccessor;
import com.comalatech.confluence.workflow.PageWorkflows;
import com.comalatech.confluence.workflow.WorkflowAccessor;
import com.comalatech.confluence.workflow.actions.ViewPageAction;
import com.comalatech.confluence.workflow.permissions.WorkflowPermissionManager;
import com.comalatech.confluence.workflow.transformer.AbstractTransformer;
import com.comalatech.workflow.StateService;
import com.comalatech.workflow.model.State;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

public class PublishedContentStorageTransformer
extends AbstractTransformer {
    private static final Logger log = LoggerFactory.getLogger(PublishedContentStorageTransformer.class);
    public static final String RENDER_WORKFLOW_PAGE = "workflowPage";
    protected static final String SKIP_TRANSFORM_PARAM = "com.comala.workflows:skip-transform-to-published";
    protected static final String PUBLISHED_VIEW_GET_PARAM = "publishedView";
    public static final String LOZENGE_DRAFT_TEMPLATE = "<div><ac:structured-macro ac:name=\"pagestatus\" ac:schema-version=\"1\"/></div>\n";
    protected final StateService stateService;
    protected final PageManager pageManager;
    protected final WorkflowAccessor workflowAccessor;
    protected final ApprovalAccessor approvalAccessor;
    protected final WorkflowPermissionManager workflowPermissionManager;
    protected final XhtmlContent xhtmlContent;
    protected final WorkflowsFeatureManager workflowsFeatureManager;
    private final ActionContextCompatManager actionContextCompatManager;
    private final ServletActionContextCompatManager servletActionContextCompatManager;
    private final ComalaI18nBean comalaI18nBean;
    protected AbstractPage page = null;
    protected PageWorkflows pageWorkflows = null;

    public PublishedContentStorageTransformer(StateService stateService, PageManager pageManager, WorkflowAccessor workflowAccessor, ApprovalAccessor approvalAccessor, WorkflowPermissionManager workflowPermissionManager, XhtmlContent xhtmlContent, WorkflowsFeatureManager workflowsFeatureManager, @Qualifier(value="actionContextCompatManager") ActionContextCompatManager actionContextCompatManager, @Qualifier(value="servletActionContextCompat") ServletActionContextCompatManager servletActionContextCompatManager, ComalaI18nBean comalaI18nBean) {
        this.stateService = stateService;
        this.pageManager = pageManager;
        this.workflowAccessor = workflowAccessor;
        this.approvalAccessor = approvalAccessor;
        this.workflowPermissionManager = workflowPermissionManager;
        this.xhtmlContent = xhtmlContent;
        this.workflowsFeatureManager = workflowsFeatureManager;
        this.actionContextCompatManager = actionContextCompatManager;
        this.servletActionContextCompatManager = servletActionContextCompatManager;
        this.comalaI18nBean = comalaI18nBean;
    }

    @Override
    public boolean shouldApply(String content, ConversionContext context) {
        if (this.workflowsFeatureManager.isWorkflowsApp() && this.isSkipTransform(context)) {
            return false;
        }
        String outputType = context.getOutputType();
        if (!outputType.equalsIgnoreCase("pdf") && !outputType.equalsIgnoreCase("word")) {
            return false;
        }
        ContentEntityObject ceo = context.getEntity();
        if (!(ceo instanceof AbstractPage && ceo.isCurrent() && ceo.getBodyContent().getBody().equals(content))) {
            return false;
        }
        this.page = (AbstractPage)context.getEntity();
        return true;
    }

    @Override
    public String transform(String content, ConversionContext conversionContext) {
        this.pageWorkflows = this.workflowAccessor.getPageWorkflows(this.page);
        if (this.pageWorkflows != null && this.pageWorkflows.isRequiresFinalApproval()) {
            State publishedState = this.stateService.getPublishedState((ContentEntityObject)this.page);
            State currentState = this.stateService.getCurrentState((ContentEntityObject)this.page);
            if (publishedState != null || !this.isSkipTransform(conversionContext)) {
                if ((publishedState == null || this.isDraftViewParam() && !currentState.isPublished()) && this.canCurrentUserViewDrafts(this.page)) {
                    content = LOZENGE_DRAFT_TEMPLATE + content;
                } else if (publishedState != null) {
                    if (log.isDebugEnabled()) {
                        log.debug("found published page version for page: " + this.page);
                    }
                    conversionContext.setProperty("releaseview", (Object)true);
                    if (publishedState.getContentVersion() != this.page.getVersion()) {
                        AbstractPage oldVersion;
                        if (log.isDebugEnabled()) {
                            log.debug("Page current version: " + this.page.getVersion() + "  published Version: " + publishedState.getContentVersion() + " will transform content");
                        }
                        if ((oldVersion = this.pageManager.getPageByVersion(this.page, publishedState.getContentVersion())) == null) {
                            log.error("Cannot access published version (deleted?) for " + this.page);
                            String msg = this.comalaI18nBean.getText("approvalsworkflow.approval.version.not.available", new String[]{oldVersion + ""});
                            content = ViewPageAction.renderErrorBody(msg);
                        } else if (oldVersion.getBodyContent().getBodyType().equals((Object)BodyType.WIKI)) {
                            if (log.isDebugEnabled()) {
                                log.debug("transforming previous published version that is unmigrated wiki markup");
                            }
                            AbstractPage convertedPage = (AbstractPage)this.xhtmlContent.convertWikiBodyToStorage((ContentEntityObject)oldVersion);
                            content = convertedPage.getBodyContent().getBody();
                            if (log.isDebugEnabled()) {
                                log.debug("wiki transformation complete");
                            }
                        } else {
                            content = oldVersion.getBodyContent().getBody();
                        }
                    }
                    this.setRenderingPublishedWorkflowPageIndicators(conversionContext, publishedState);
                } else if (!this.canCurrentUserViewDrafts(this.page)) {
                    String msg = this.comalaI18nBean.getText("approvalsworkflow.approval.page.not.permitted");
                    return ViewPageAction.renderErrorBody(msg);
                }
            }
        }
        this.setRenderingWorkflowPageIndicators(conversionContext);
        return content;
    }

    protected boolean isSkipTransform(ConversionContext context) {
        Object property = this.getIsSkipTransformAttribute(context);
        if (property != null) {
            return BooleanUtils.toBoolean((String)String.valueOf(property));
        }
        return false;
    }

    private Object getIsSkipTransformAttribute(ConversionContext context) {
        if (context != null && context.hasProperty(SKIP_TRANSFORM_PARAM)) {
            return context.getProperty(SKIP_TRANSFORM_PARAM);
        }
        new ServletContextThreadLocal();
        HttpServletRequest req = ServletContextThreadLocal.getRequest();
        if (req != null) {
            return req.getAttribute(SKIP_TRANSFORM_PARAM);
        }
        return null;
    }

    protected boolean isDraftViewParam() {
        String publishedView;
        HttpServletRequest request = this.getHttpContextRequest();
        return request != null && (publishedView = request.getParameter(PUBLISHED_VIEW_GET_PARAM)) != null && publishedView.equalsIgnoreCase("false");
    }

    private boolean canCurrentUserViewDrafts(AbstractPage page) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        return this.workflowPermissionManager.canViewDrafts(page, user);
    }

    protected void setRenderingWorkflowPageIndicators(ConversionContext context) {
        this.setRenderingIndicators(context, RENDER_WORKFLOW_PAGE, Boolean.TRUE);
    }

    protected void setRenderingPublishedWorkflowPageIndicators(ConversionContext context, State publishedState) {
        this.setRenderingIndicators(context, "releaseview", publishedState);
    }

    protected void setRenderingIndicators(ConversionContext context, String property, Object propertyValue) {
        context.setProperty(property, propertyValue);
        Map contextMap = this.getActionContextMap();
        if (contextMap != null) {
            this.setActionContextParam(property, propertyValue);
        }
    }

    private Map getActionContextMap() {
        try {
            return this.actionContextCompatManager.getContextMap();
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("There was an error trying to retrieve the contextMap", (Throwable)e);
            }
            return null;
        }
    }

    private void setActionContextParam(String key, Object value) {
        block2: {
            try {
                this.actionContextCompatManager.put(key, value);
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block2;
                log.debug("There was an error setting " + key + " : " + value + " into actionContext", (Throwable)e);
            }
        }
    }

    private HttpServletRequest getHttpContextRequest() {
        try {
            return this.servletActionContextCompatManager.getRequest();
        }
        catch (Exception exception) {
            if (log.isDebugEnabled()) {
                log.debug("Exception trying to retrieve request", (Throwable)exception);
            }
            return null;
        }
    }
}

