/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.restv2.model;

import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonValue;

@XmlRootElement(name="restWorkflowSection")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RestWorkflowSection {
    public String body;
    public Visibility visibility;

    public RestWorkflowSection() {
    }

    public RestWorkflowSection(String body, Visibility visibility) {
        this.body = body;
        this.visibility = visibility;
    }

    public static enum Visibility {
        CONTRIBUTORS("contributors"),
        READONLY("readonly"),
        ALL("all");

        public static Visibility DEFAULT;
        private static Map<String, Visibility> FORMAT_MAP;
        private final String formatted;

        private Visibility(String formatted) {
            this.formatted = formatted;
        }

        @JsonCreator
        public static Visibility fromString(String string) {
            return Optional.ofNullable(FORMAT_MAP.get(string)).orElseThrow(() -> new IllegalArgumentException(string));
        }

        @JsonValue
        public String toString() {
            return this.formatted;
        }

        static {
            DEFAULT = ALL;
            FORMAT_MAP = Stream.of(Visibility.values()).collect(Collectors.toMap(s -> s.formatted, Function.identity()));
        }
    }
}

