/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.parameter.job;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.core.bean.EntityObject;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.comalatech.confluence.dataextractor.DataExtractorManager;
import com.comalatech.confluence.util.OverridePermissionsUtil;
import com.comalatech.confluence.util.PluginContainerManager;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCPUpdaterJob
implements JobRunner {
    private static final Logger log = LoggerFactory.getLogger(JCPUpdaterJob.class);
    private static final int CQL_BATCH_SIZE = 100;
    private static final int TARGET_GLOBAL_CONTENT_PROPERTY_MODEL_VERSION = 4;
    private static final String CQL_PENDING_PAGES_QUERY = "awphasworkflow=true AND content.property[comalaworkflowsglobalmodelversion].version<4";
    private final TransactionTemplate transactionTemplate;
    private final PageManager pageManager;
    private final CQLSearchService cqlSearchService;
    private final DataExtractorManager dataExtractorManager;
    private final OverridePermissionsUtil overridePermissionsUtil;

    public JCPUpdaterJob(TransactionTemplate transactionTemplate, PageManager pageManager, CQLSearchService cqlSearchService, DataExtractorManager dataExtractorManager, OverridePermissionsUtil overridePermissionsUtil) {
        this.transactionTemplate = transactionTemplate;
        this.pageManager = pageManager;
        this.cqlSearchService = cqlSearchService;
        this.dataExtractorManager = dataExtractorManager;
        this.overridePermissionsUtil = overridePermissionsUtil;
    }

    @Nullable
    public JobRunnerResponse runJob(JobRunnerRequest jobRunnerRequest) {
        if (log.isDebugEnabled()) {
            log.debug("JCPUpdaterJob starting");
        }
        try {
            PluginContainerManager.autowireComponent(this);
            Set updatePages = this.overridePermissionsUtil.executeWithExemption(this::getPagesWithoutWorkflowParamsJCP);
            if (updatePages == null) {
                return JobRunnerResponse.failed((String)"JCPUpdaterJob failed during permissions check.");
            }
            if (log.isInfoEnabled()) {
                log.info("updating all JCP: (" + updatePages.size() + " pages found)");
            }
            if (updatePages.isEmpty()) {
                return JobRunnerResponse.success((String)"JCPUpdaterJob did not find any pages to update.");
            }
            return (JobRunnerResponse)this.transactionTemplate.execute(() -> {
                for (Long pageId : updatePages) {
                    if (jobRunnerRequest.isCancellationRequested()) {
                        return JobRunnerResponse.aborted((String)"Job cancelled.");
                    }
                    if (log.isInfoEnabled()) {
                        log.info("updating all JCP for page:" + pageId);
                    }
                    this.dataExtractorManager.updateAllContentProperties((EntityObject)this.pageManager.getById(pageId.longValue()));
                }
                return JobRunnerResponse.success((String)"JCPUpdaterJob finished successfully.");
            });
        }
        catch (Error | Exception e) {
            log.error("Error in workflow parameters update job", e);
            return JobRunnerResponse.failed((String)"Job failed.");
        }
    }

    private Set<Long> getPagesWithoutWorkflowParamsJCP() {
        PageResponse results = this.cqlSearchService.searchContent(CQL_PENDING_PAGES_QUERY, (PageRequest)new SimplePageRequest(0, 100), new Expansion[0]);
        if (null == results) {
            return new HashSet<Long>();
        }
        return results.getResults().stream().map(content -> content.getId().asLong()).collect(Collectors.toSet());
    }
}

