/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.audit.mapper;

import com.atlassian.audit.entity.AuditAttribute;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditResource;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.ChangedValue;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.setup.settings.GlobalSettingsManager;
import com.atlassian.confluence.spaces.Space;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import com.comalatech.confluence.workflow.audit.model.AuditRecord;
import com.comalatech.confluence.workflow.audit.model.PageAuditRecord;
import com.comalatech.confluence.workflow.audit.model.SpaceAuditRecord;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowAuditMapper {
    private static final Logger log = LoggerFactory.getLogger(WorkflowAuditMapper.class);
    private final GlobalSettingsManager globalSettingsManager;
    private final ComalaI18nBean comalaI18nBean;

    public WorkflowAuditMapper(GlobalSettingsManager globalSettingsManager, ComalaI18nBean comalaI18nBean) {
        this.globalSettingsManager = globalSettingsManager;
        this.comalaI18nBean = comalaI18nBean;
    }

    public AuditEvent toAuditEvent(AuditRecord auditRecord) {
        AuditAttribute extraAttribute;
        String objectType;
        String summary = this.comalaI18nBean.getText("awp.auditlog.event." + auditRecord.getEventName());
        DateTime date = new DateTime((Object)auditRecord.getCreated(), DateTimeZone.getDefault());
        if (log.isDebugEnabled()) {
            log.debug("summary: " + summary + "  date: " + date + "  eventType: " + auditRecord.getEventName() + "  value: " + auditRecord.getDescription());
        }
        ArrayList<AuditResource> affectedObjects = new ArrayList<AuditResource>();
        ArrayList<AuditAttribute> extraAttributes = new ArrayList<AuditAttribute>();
        if (auditRecord instanceof PageAuditRecord && ((PageAuditRecord)auditRecord).getSpace() != null) {
            PageAuditRecord pageAuditRecord = (PageAuditRecord)auditRecord;
            if (pageAuditRecord.getContent() != null) {
                affectedObjects.add(this.buildSpaceResource(pageAuditRecord.getSpace()));
                affectedObjects.add(this.buildPageResource(pageAuditRecord.getContent()));
            }
        } else if (auditRecord instanceof SpaceAuditRecord && ((SpaceAuditRecord)auditRecord).getSpace() != null) {
            SpaceAuditRecord spaceAuditRecord = (SpaceAuditRecord)auditRecord;
            affectedObjects.add(this.buildSpaceResource(spaceAuditRecord.getSpace()));
        }
        if (StringUtils.isNotBlank((CharSequence)auditRecord.getDescription()) && (objectType = this.getAssociatedObjectType(auditRecord)) != null) {
            extraAttribute = AuditAttribute.fromI18nKeys((String)objectType, (String)WorkflowAuditMapper.ensureValueSize(auditRecord.getDescription())).build();
            extraAttributes.add(extraAttribute);
        }
        if (auditRecord.getEventName().contains("SpaceWorkflowParameter") && auditRecord.getNewValues() != null) {
            extraAttribute = AuditAttribute.fromI18nKeys((String)this.comalaI18nBean.getText("audit.logging.affected.object.workflow.parameter"), (String)auditRecord.getNewValues().get("name")).build();
            extraAttributes.add(extraAttribute);
        }
        AuditEvent.Builder auditEventBuilder = AuditEvent.builder((AuditType)AuditType.fromI18nKeys((CoverageArea)CoverageArea.AUDIT_LOG, (CoverageLevel)CoverageLevel.BASE, (String)"audit.logging.category.comala.workflows", (String)("awp.auditlog.event." + auditRecord.getEventName())).build());
        auditEventBuilder.changedValues(WorkflowAuditMapper.getChangedValues(auditRecord));
        if (!affectedObjects.isEmpty()) {
            auditEventBuilder.affectedObjects(affectedObjects);
        }
        if (!extraAttributes.isEmpty()) {
            auditEventBuilder.extraAttributes(extraAttributes);
        }
        return auditEventBuilder.build();
    }

    private static List<ChangedValue> getChangedValues(AuditRecord auditRecord) {
        ArrayList<ChangedValue> changedValues = new ArrayList<ChangedValue>();
        if (auditRecord != null && auditRecord.getNewValues() != null) {
            Map<Object, Object> oldValues = auditRecord.getOldValues() == null ? new HashMap() : auditRecord.getOldValues();
            MapDifference difference = Maps.difference(oldValues, auditRecord.getNewValues());
            Map entriesDiffering = difference.entriesDiffering();
            for (Map.Entry entry : entriesDiffering.entrySet()) {
                String key = (String)entry.getKey();
                MapDifference.ValueDifference value = (MapDifference.ValueDifference)entry.getValue();
                if (value.leftValue() == null && value.rightValue() == null) continue;
                ChangedValue changedValue = ChangedValue.fromI18nKeys((String)key).from(WorkflowAuditMapper.ensureValueSize((String)value.leftValue())).to(WorkflowAuditMapper.ensureValueSize((String)value.rightValue())).build();
                changedValues.add(changedValue);
            }
            Map entriesOnlyOnRight = difference.entriesOnlyOnRight();
            for (Map.Entry entry : entriesOnlyOnRight.entrySet()) {
                if (entry.getValue() == null) continue;
                ChangedValue changedValue = ChangedValue.fromI18nKeys((String)((String)entry.getKey())).to(WorkflowAuditMapper.ensureValueSize((String)entry.getValue())).build();
                changedValues.add(changedValue);
            }
        }
        return changedValues;
    }

    private static String ensureValueSize(String value) {
        return value.length() < 256 ? value : value.substring(0, 252) + "...";
    }

    private String getAssociatedObjectType(AuditRecord auditRecord) {
        String objectType;
        if (auditRecord.getEventName().contains("SpaceWorkflowParameter")) {
            objectType = this.comalaI18nBean.getText("audit.logging.affected.object.workflow.parameter");
        } else {
            if (auditRecord.getEventName().contains("SpaceWorkflowStatesInitialization") || auditRecord.getEventName().contains("WorkflowConfigurationUpdated") || auditRecord.getEventName().contains("WorkflowNotificationConfigurationUpdated")) {
                return null;
            }
            objectType = this.comalaI18nBean.getText("audit.logging.affected.object.workflow.template");
        }
        return objectType;
    }

    private AuditResource buildSpaceResource(Space space) {
        return AuditResource.builder((String)space.getKey(), (String)this.comalaI18nBean.getText("audit.logging.affected.object.space")).uri(this.globalSettingsManager.getGlobalSettings().getBaseUrl() + space.getUrlPath()).id(String.valueOf(space.getId())).build();
    }

    private AuditResource buildPageResource(ContentEntityObject content) {
        return AuditResource.builder((String)content.getTitle(), (String)this.comalaI18nBean.getText("audit.logging.affected.object.page")).uri(this.globalSettingsManager.getGlobalSettings().getBaseUrl() + content.getUrlPath()).id(String.valueOf(content.getId())).build();
    }
}

