/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.actions;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.user.GroupManager;
import com.atlassian.xwork.ParameterSafe;
import com.comalatech.confluence.license.AdhocWorkflowsLicenseManager;
import com.comalatech.confluence.workflow.WorkflowAdvancedConfigurationManager;
import com.comalatech.confluence.workflow.events.admin.WorkflowAdvancedConfigurationUpdatedEventImpl;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

public class WorkflowAdvancedConfigAction
extends ConfluenceActionSupport {
    private static final Logger log = LoggerFactory.getLogger(WorkflowAdvancedConfigAction.class);
    private WorkflowAdvancedConfigurationManager workflowAdvancedConfigurationManager;
    private AdhocWorkflowsLicenseManager licenseManager;
    private EventPublisher eventPublisher;
    private GroupManager groupManager;
    private String confirm;
    private boolean editMode = true;
    private String errorMessage;
    private int cacheProductionWorkflows;
    private int cacheGlobalWorkflows;
    private int cacheGlobalWorkflowNames;
    private int userSearchMinCharacters;
    private int dataExtractorBatch;
    private int expirationJobBatch;
    private int maxHandledUsers;
    private int maxAllowedApproversToShow;
    private int searchLimit;
    private static final String DOC_URL = "https://apps.appf.re/cdmdc/doc/advancedconfiguration/NkRu3W";

    public String view() {
        this.editMode = false;
        this.cacheGlobalWorkflowNames = this.workflowAdvancedConfigurationManager.getCacheGlobalWorkflowNames();
        this.cacheGlobalWorkflows = this.workflowAdvancedConfigurationManager.getCacheGlobalWorkflows();
        this.cacheProductionWorkflows = this.workflowAdvancedConfigurationManager.getCacheProductionWorkflows();
        this.userSearchMinCharacters = this.workflowAdvancedConfigurationManager.getUserSearchMinCharacters();
        this.dataExtractorBatch = this.workflowAdvancedConfigurationManager.getDataExtractorBatchSize();
        this.expirationJobBatch = this.workflowAdvancedConfigurationManager.getExpirationJobBatchSize();
        this.maxHandledUsers = this.workflowAdvancedConfigurationManager.getMaxHandledUsers();
        this.maxAllowedApproversToShow = this.workflowAdvancedConfigurationManager.getMaxAllowedApproversToShow();
        this.searchLimit = this.workflowAdvancedConfigurationManager.getSearchLimit();
        return "success";
    }

    public String edit() {
        this.view();
        this.editMode = true;
        return "success";
    }

    public String save() {
        this.editMode = true;
        if (this.confirm == null) {
            return "success";
        }
        Map<String, String> existingConfig = this.createConfigMap();
        try {
            this.workflowAdvancedConfigurationManager.setCacheProductionWorkflows(this.cacheProductionWorkflows);
            this.workflowAdvancedConfigurationManager.setCacheGlobalWorkflows(this.cacheGlobalWorkflows);
            this.workflowAdvancedConfigurationManager.setCacheGlobalWorkflowNames(this.cacheGlobalWorkflowNames);
            this.workflowAdvancedConfigurationManager.setUserSearchMinCharacters(this.userSearchMinCharacters);
            this.workflowAdvancedConfigurationManager.setDataExtractorBatchSize(this.dataExtractorBatch);
            this.workflowAdvancedConfigurationManager.setExpirationJobBatchSize(this.expirationJobBatch);
            this.workflowAdvancedConfigurationManager.setMaxHandledUsers(this.maxHandledUsers);
            this.workflowAdvancedConfigurationManager.setMaxAllowedApproversToShow(this.maxAllowedApproversToShow);
            this.workflowAdvancedConfigurationManager.setSearchLimit(this.searchLimit);
            this.errorMessage = null;
            Map<String, String> newConfig = this.createConfigMap();
            if (!existingConfig.equals(newConfig)) {
                this.eventPublisher.publish((Object)new WorkflowAdvancedConfigurationUpdatedEventImpl(existingConfig, newConfig));
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            this.editMode = true;
            this.errorMessage = "Internal error, check server logs";
        }
        return this.view();
    }

    private Map<String, String> createConfigMap() {
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("cacheProductionWorkflows", String.valueOf(this.workflowAdvancedConfigurationManager.getCacheProductionWorkflows()));
        configMap.put("cacheGlobalWorkflows", String.valueOf(this.workflowAdvancedConfigurationManager.getCacheGlobalWorkflows()));
        configMap.put("cacheWorkflowNames", String.valueOf(this.workflowAdvancedConfigurationManager.getCacheGlobalWorkflowNames()));
        configMap.put("userSearchMinCharacters", String.valueOf(this.workflowAdvancedConfigurationManager.getUserSearchMinCharacters()));
        configMap.put("dataExtractorBatch", String.valueOf(this.workflowAdvancedConfigurationManager.getDataExtractorBatchSize()));
        configMap.put("expirationJobBatch", String.valueOf(this.workflowAdvancedConfigurationManager.getExpirationJobBatchSize()));
        configMap.put("maxHandledUsers", String.valueOf(this.workflowAdvancedConfigurationManager.getMaxHandledUsers()));
        configMap.put("maxAllowedApproversToShow", String.valueOf(this.workflowAdvancedConfigurationManager.getMaxAllowedApproversToShow()));
        configMap.put("searchLimit", String.valueOf(this.workflowAdvancedConfigurationManager.getSearchLimit()));
        return configMap;
    }

    public void setLicenseManager(@Qualifier(value="adhocWorkflowsLicenseManager") AdhocWorkflowsLicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    public String getWorkflowLicenseMessageHtml() {
        return this.licenseManager.getLicenseStatus().getMessageHtml();
    }

    public String getDocoUrl() {
        return DOC_URL;
    }

    @ParameterSafe
    public void setCacheProductionWorkflows(int cacheProductionWorkflows) {
        this.cacheProductionWorkflows = cacheProductionWorkflows;
    }

    @ParameterSafe
    public void setCacheGlobalWorkflows(int cacheGlobalWorkflows) {
        this.cacheGlobalWorkflows = cacheGlobalWorkflows;
    }

    @ParameterSafe
    public void setCacheGlobalWorkflowNames(int cacheGlobalWorkflowNames) {
        this.cacheGlobalWorkflowNames = cacheGlobalWorkflowNames;
    }

    @ParameterSafe
    public void setUserSearchMinCharacters(int userSearchMinCharacters) {
        this.userSearchMinCharacters = userSearchMinCharacters;
    }

    @ParameterSafe
    public void setDataExtractorBatch(int dataExtractorBatch) {
        this.dataExtractorBatch = dataExtractorBatch;
    }

    @ParameterSafe
    public void setExpirationJobBatch(int expirationJobBatch) {
        this.expirationJobBatch = expirationJobBatch;
    }

    @ParameterSafe
    public void setMaxHandledUsers(int maxHandledUsers) {
        this.maxHandledUsers = maxHandledUsers;
    }

    @ParameterSafe
    public void setMaxAllowedApproversToShow(int maxAllowedApproversToShow) {
        this.maxAllowedApproversToShow = maxAllowedApproversToShow;
    }

    @ParameterSafe
    public void setSearchLimit(int searchLimit) {
        this.searchLimit = searchLimit;
    }

    @ParameterSafe
    public void setConfirm(String confirm) {
        this.confirm = confirm;
    }

    public WorkflowAdvancedConfigurationManager getWorkflowAdvancedConfigurationManager() {
        return this.workflowAdvancedConfigurationManager;
    }

    public AdhocWorkflowsLicenseManager getLicenseManager() {
        return this.licenseManager;
    }

    public EventPublisher getEventPublisher() {
        return this.eventPublisher;
    }

    public GroupManager getGroupManager() {
        return this.groupManager;
    }

    public String getConfirm() {
        return this.confirm;
    }

    public boolean isEditMode() {
        return this.editMode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public int getCacheProductionWorkflows() {
        return this.cacheProductionWorkflows;
    }

    public int getCacheGlobalWorkflows() {
        return this.cacheGlobalWorkflows;
    }

    public int getCacheGlobalWorkflowNames() {
        return this.cacheGlobalWorkflowNames;
    }

    public int getUserSearchMinCharacters() {
        return this.userSearchMinCharacters;
    }

    public int getMaxHandledUsers() {
        return this.maxHandledUsers;
    }

    public int getMaxAllowedApproversToShow() {
        return this.maxAllowedApproversToShow;
    }

    public int getSearchLimit() {
        return this.searchLimit;
    }

    public void setWorkflowAdvancedConfigurationManager(WorkflowAdvancedConfigurationManager workflowAdvancedConfigurationManager) {
        this.workflowAdvancedConfigurationManager = workflowAdvancedConfigurationManager;
    }

    public void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public void setGroupManager(GroupManager groupManager) {
        this.groupManager = groupManager;
    }

    public void setEditMode(boolean editMode) {
        this.editMode = editMode;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public int getDataExtractorBatch() {
        return this.dataExtractorBatch;
    }

    public int getExpirationJobBatch() {
        return this.expirationJobBatch;
    }
}

