/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.mail.notification.Notification;
import com.atlassian.confluence.mail.notification.NotificationManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.user.Entity;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.search.page.Pager;
import com.comalatech.confluence.util.MiscUtils;
import com.comalatech.confluence.workflow.UsersListResolver;
import com.comalatech.confluence.workflow.ValueReferenceResolver;
import com.comalatech.confluence.workflow.WorkflowAdvancedConfigurationManager;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.WorkflowUserException;
import com.comalatech.confluence.workflow.model.ValueReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultUsersListResolver
implements UsersListResolver {
    private static final Logger log = LoggerFactory.getLogger(DefaultUsersListResolver.class);
    public static final String USER_LINK_SEGMENT = "/display/";
    private static final String WATCHERS = "watchers";
    private static final int MAX_RESOLVE_VALUES_ITERATIONS = 10;
    private final NotificationManager notificationManager;
    private final UserAccessor userAccessor;
    private final GroupManager groupManager;
    private final WorkflowAdvancedConfigurationManager workflowAdvancedConfigurationManager;

    public DefaultUsersListResolver(NotificationManager notificationManager, UserAccessor userAccessor, GroupManager groupManager, WorkflowAdvancedConfigurationManager workflowAdvancedConfigurationManager) {
        this.notificationManager = notificationManager;
        this.userAccessor = userAccessor;
        this.groupManager = groupManager;
        this.workflowAdvancedConfigurationManager = workflowAdvancedConfigurationManager;
    }

    @Override
    public ConfluenceUser[] getValueAsUsers(ValueReferenceResolver resolver, AbstractPage page, String valueReferences) throws WorkflowException {
        return this.getValueAsUsers(resolver, page, valueReferences, false);
    }

    @Override
    public ConfluenceUser[] getValueAsUsers(ValueReferenceResolver resolver, AbstractPage page, String valueReferences, boolean ignoreExceptions) throws WorkflowException {
        return this.getValueAsUsers(resolver, page, valueReferences, ignoreExceptions, false);
    }

    @Override
    public ConfluenceUser[] getValueAsUsers(ValueReferenceResolver resolver, AbstractPage page, String valueReferences, boolean ignoreExceptions, boolean isRestrictionsMacro) throws WorkflowException {
        UsersListResolver.ResolverErrorHandling errorHandling = UsersListResolver.ResolverErrorHandling.EXCEPTION_RESOLVER;
        if (ignoreExceptions) {
            errorHandling = UsersListResolver.ResolverErrorHandling.ERROR_LOG;
        }
        DefaultConfig config = new DefaultConfig(true, errorHandling, isRestrictionsMacro);
        List<ConfluenceUser> usersIncludingGroupMembers = this.getValueAsUsersSet(resolver, page, valueReferences, config).getUsersIncludingGroupMembers();
        return usersIncludingGroupMembers.toArray(new ConfluenceUser[usersIncludingGroupMembers.size()]);
    }

    @Override
    public String[] getValueAsUserNames(ValueReferenceResolver resolver, AbstractPage page, String valueReferences, boolean expandGroupMembers) throws WorkflowException {
        DefaultConfig config = new DefaultConfig(expandGroupMembers, UsersListResolver.ResolverErrorHandling.EXCEPTION_RESOLVER);
        Set<String> names = this.getValueAsUsersSet(resolver, page, valueReferences, config).getUsersMapIncludingGroupMembers().keySet();
        Object[] userNames = names.toArray(new String[names.size()]);
        Arrays.sort(userNames);
        return userNames;
    }

    @Override
    public String[] getValueAsUserKeys(ValueReferenceResolver resolver, AbstractPage page, String valueReferences) throws WorkflowException {
        ConfluenceUser[] users = this.getValueAsUsers(resolver, page, valueReferences, true, true);
        return (String[])Arrays.stream(users).map(user -> user.getKey().getStringValue()).toArray(String[]::new);
    }

    @Override
    public UsersListResolver.UserGroupResolved getUsersGroupsResolved(ValueReferenceResolver resolver, AbstractPage page, String valueReferences, boolean ignoreExceptions) throws WorkflowException {
        return this.getValueAsUsersSet(resolver, page, valueReferences, ignoreExceptions ? new DefaultConfig() : new DefaultConfig(UsersListResolver.ResolverErrorHandling.EXCEPTION_ALL));
    }

    @Override
    public UsersListResolver.UserGroupResolved getUsersGroupsResolvedPreserveType(String usergroups, String preserveType) throws WorkflowException {
        return this.getValueAsUsersSet(null, null, usergroups, new DefaultConfig(preserveType));
    }

    @Override
    public Collection<Entity> getValueAsUsersOrGroups(ValueReferenceResolver resolver, String valueReferences) throws WorkflowException {
        return this.getValueAsUsersSet(resolver, null, valueReferences, new DefaultConfig(UsersListResolver.ResolverErrorHandling.EXCEPTION_RESOLVER)).getLinkedUsersAndGroups();
    }

    @Override
    public List<Group> getValueAsGroups(ValueReferenceResolver resolver, String valueReference) throws WorkflowException {
        List<Object> groupNames;
        ArrayList<Group> groups = new ArrayList<Group>();
        if (resolver != null) {
            groupNames = new ArrayList();
            this.resolveValues(groupNames, resolver, valueReference, false);
        } else {
            groupNames = Arrays.asList(MiscUtils.splitAndTrim(valueReference));
        }
        for (String string : groupNames) {
            Group group = this.getGroup(string, false);
            groups.add(group);
        }
        return groups;
    }

    @Override
    public List<ConfluenceUser> getAsUsers(String userNames) {
        ArrayList<ConfluenceUser> users = new ArrayList<ConfluenceUser>();
        for (String name : MiscUtils.splitAndTrim(userNames)) {
            ConfluenceUser user = this.userAccessor.getUserByName(name);
            if (user == null) continue;
            users.add(user);
        }
        return users;
    }

    @Override
    public void checkUsers(String userNames) throws WorkflowException {
        for (String name : MiscUtils.splitAndTrim(userNames)) {
            ConfluenceUser user;
            if (ValueReference.isValueReference(name) || (user = this.userAccessor.getUserByName(name)) != null) continue;
            throw new WorkflowUserException("user " + name + " does not exist");
        }
    }

    @Override
    public String valueReferenceToWiki(String reference) throws WorkflowException {
        if (!StringUtils.isNotBlank((CharSequence)reference)) {
            return "";
        }
        if (reference.equals(WATCHERS)) {
            return "_page watchers_";
        }
        if (this.userAccessor.getUserByName(reference) == null) {
            this.getGroup(reference, false);
            return "group {{" + reference + "}}";
        }
        return "[~" + reference + "]";
    }

    @Override
    public String usersReferenceToWiki(ValueReferenceResolver resolver, String reference, String separator) throws WorkflowException {
        if (!StringUtils.isNotBlank((CharSequence)reference)) {
            return "";
        }
        String[] references = reference.split(",");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < references.length; ++i) {
            String ref = references[i].trim();
            if (i > 0) {
                if (i == references.length - 1) {
                    sb.append(separator);
                } else {
                    sb.append(", ");
                }
            }
            if (ValueReference.isValueReference(ref)) {
                sb.append(ValueReference.referenceToString(ref, resolver));
                continue;
            }
            sb.append(this.valueReferenceToWiki(ref));
        }
        return sb.toString();
    }

    @Override
    public void validateReference(ValueReferenceResolver resolver, String value, boolean isUser, boolean isGroup) throws WorkflowException {
        ArrayList<String> resolvedValues = new ArrayList<String>();
        this.resolveValues(resolvedValues, resolver, value, true);
        for (String resolvedValue : resolvedValues) {
            if (isUser && this.userAccessor.getUserByName(resolvedValue) != null) {
                return;
            }
            if (isGroup) {
                this.getGroup(resolvedValue, false);
                continue;
            }
            throw new WorkflowUserException("comalatech.awp.container.workflowparameters.error.invaliduser", resolvedValue);
        }
    }

    @Override
    public List<String> getUsersFromGroup(String name, Integer overrideMaximumNumOfUsers) throws WorkflowException {
        Group group = this.getGroup(name, false);
        Pager pager = null;
        int limit = overrideMaximumNumOfUsers != null ? overrideMaximumNumOfUsers.intValue() : this.getMaxHandledUsers();
        try {
            pager = this.groupManager.getMemberNames(group);
        }
        catch (EntityException e) {
            throw new WorkflowUserException("Error retrieving group name " + name);
        }
        ArrayList<String> allUsers = new ArrayList<String>();
        while (true) {
            allUsers.addAll(pager.getCurrentPage());
            if (allUsers.size() > limit) {
                return allUsers.subList(0, limit);
            }
            if (pager.onLastPage()) break;
            pager.nextPage();
        }
        return allUsers;
    }

    @Override
    public int getMaxHandledUsers() {
        return this.workflowAdvancedConfigurationManager.getMaxHandledUsers();
    }

    @Override
    public void throwMaxHandledUsersLimitReachedError() throws WorkflowUserException {
        throw new WorkflowUserException("The workflow engine cannot handle more than " + this.getMaxHandledUsers() + " users");
    }

    private UsersListResolver.UserGroupResolved getValueAsUsersSet(ValueReferenceResolver resolver, AbstractPage page, String names, UsersListResolver.Config config) throws WorkflowException {
        UsersListResolver.UserGroupResolved userGroupResolved;
        block4: {
            userGroupResolved = this.getUsersGroupsResolvedInternal(resolver, page, names, config);
            try {
                if (config.isExpandGroupMembers() || !config.isIgnoreUserLimit()) {
                    ((DefaultUserGroupResolved)userGroupResolved).expandUsers(config.isExpandGroupMembers(), config.isIgnoreUserLimit());
                }
            }
            catch (WorkflowException we) {
                if (!config.isIgnoreResolverExceptions()) {
                    throw we;
                }
                if (!config.getErrorHandling().equals((Object)UsersListResolver.ResolverErrorHandling.ERROR_LOG)) break block4;
                log.error(we.getMessage(), (Throwable)we);
            }
        }
        return userGroupResolved;
    }

    private UsersListResolver.UserGroupResolved getUsersGroupsResolvedInternal(ValueReferenceResolver resolver, AbstractPage page, String names, UsersListResolver.Config config) throws WorkflowException {
        List<Object> resolvedNames;
        LinkedHashMap<String, ConfluenceUser> usersMap = new LinkedHashMap<String, ConfluenceUser>();
        LinkedHashMap<String, Group> groupsMap = new LinkedHashMap<String, Group>();
        if (resolver != null) {
            resolvedNames = new ArrayList();
            try {
                this.resolveValues(resolvedNames, resolver, names, config.isIgnoreAllExceptions());
            }
            catch (WorkflowException e) {
                log.error("Error resolving value/s: " + names + " in page: " + page.getId(), (Throwable)e);
                throw e;
            }
        } else {
            resolvedNames = Arrays.asList(MiscUtils.splitAndTrim(names));
        }
        for (String string : resolvedNames) {
            if (string.trim().equalsIgnoreCase(WATCHERS)) {
                this.appendPageWatchers(page, usersMap);
                continue;
            }
            if (usersMap.get(string) != null) continue;
            ConfluenceUser user = null;
            Group group = null;
            boolean isValueReference = ValueReference.isValueReference(string);
            try {
                user = this.getAsUser(string);
            }
            catch (WorkflowException e) {
                group = this.getGroup(string, config.isIgnoreAllExceptions() && (isValueReference || config.isRestrictionsMacro()));
            }
            if (user != null || isValueReference && config.getErrorHandling() == UsersListResolver.ResolverErrorHandling.PRESERVE_UNRESOLVED_AS_USERS) {
                usersMap.put(string, user);
                continue;
            }
            if (group != null || isValueReference && config.getErrorHandling() == UsersListResolver.ResolverErrorHandling.PRESERVE_UNRESOLVED_AS_GROUPS) {
                groupsMap.put(string, group);
                continue;
            }
            if (user != null || group != null || config.getErrorHandling() != UsersListResolver.ResolverErrorHandling.ERROR_LOG) continue;
            if (config.isRestrictionsMacro()) {
                log.warn("Attempting to set/add/remove restriction failed for user/group was not found:" + string);
                continue;
            }
            log.error("User/group was not found:" + string);
        }
        return new DefaultUserGroupResolved(usersMap, groupsMap);
    }

    private Group getGroup(String name, boolean ignoreExceptions) throws WorkflowUserException {
        Group group = null;
        try {
            group = this.groupManager.getGroup(name);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (group == null && !ignoreExceptions) {
            throw new WorkflowUserException("comalatech.awp.container.workflowparameters.error.invaliduserorgroup", name);
        }
        return group;
    }

    private void resolveValues(List<String> values, ValueReferenceResolver resolver, String valueReferences, boolean ignoreFailingValueRefs) throws WorkflowException {
        this.resolveValues(values, resolver, valueReferences, ignoreFailingValueRefs, 0);
    }

    private void resolveValues(List<String> values, ValueReferenceResolver resolver, String valueReferences, boolean ignoreFailingValueRefs, int loopIterations) throws WorkflowException {
        String[] vals;
        HashSet<String> specialValueRefs = new HashSet<String>(Arrays.asList(MiscUtils.splitAndTrim("@author@, @poster@, @creator@, @modifier@")));
        for (String val : vals = MiscUtils.splitAndTrim(valueReferences)) {
            if (ValueReference.isValueReference(val) && resolver != null) {
                String newResolvedValue = resolver.getValue(val);
                if (val.equals(newResolvedValue)) {
                    values.add(val);
                    continue;
                }
                if (specialValueRefs.contains(val)) {
                    try {
                        this.getAsUser(newResolvedValue);
                        values.add(newResolvedValue);
                    }
                    catch (WorkflowException ex) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug("Resolving the special value reference '" + val + "' with a value of '" + newResolvedValue + "' failed (not possible to find that user).");
                    }
                    continue;
                }
                if (!StringUtils.isNotBlank((CharSequence)newResolvedValue) && !ignoreFailingValueRefs) {
                    values.add(val);
                    continue;
                }
                if (loopIterations < 10) {
                    this.resolveValues(values, resolver, newResolvedValue, ignoreFailingValueRefs, loopIterations + 1);
                    continue;
                }
                log.error("Maximum number of iterations reached attempting to resolve value/s: " + newResolvedValue);
                throw new WorkflowException("Maximum number of iterations reached attempting to resolve value/s: " + newResolvedValue);
            }
            if (!StringUtils.isNotBlank((CharSequence)val)) continue;
            values.add(val);
        }
    }

    private ConfluenceUser getAsUser(String resolvedName) throws WorkflowException {
        ConfluenceUser user;
        int ix;
        if (!StringUtils.isNotBlank((CharSequence)resolvedName)) {
            throw new WorkflowUserException("User name not set (" + this.trimReferenceMarkers(resolvedName) + ")");
        }
        if (resolvedName.contains("@") && (ix = resolvedName.indexOf(USER_LINK_SEGMENT)) >= 0) {
            int lix = resolvedName.indexOf(34, ix += USER_LINK_SEGMENT.length());
            resolvedName = resolvedName.substring(ix, lix).trim();
        }
        if ((user = this.userAccessor.getUserByName(resolvedName = resolvedName.replaceAll("\\~|\\[|\\]", ""))) == null) {
            throw new WorkflowUserException("invalid user name " + resolvedName);
        }
        return user;
    }

    private List<String> getWatchersUsersNames(AbstractPage page) {
        HashSet<String> watchers = new HashSet<String>();
        List notifications = this.notificationManager.getNotificationsByContent((ContentEntityObject)page);
        for (Object notification1 : notifications) {
            Notification notification = (Notification)notification1;
            if (notification.getReceiver() == null) continue;
            watchers.add(notification.getReceiver().getName());
        }
        return new ArrayList<String>(watchers);
    }

    @Override
    public UsersListResolver.UsersReference makeUsersReference(String value) {
        String[] values = MiscUtils.splitAndTrim(value);
        ArrayList<String> users = new ArrayList<String>();
        ArrayList<String> groups = new ArrayList<String>();
        for (String name : values) {
            boolean isGroup = false;
            try {
                boolean isValueReference;
                boolean bl = isValueReference = name.startsWith("@") && name.endsWith("@");
                if (!isValueReference && this.groupManager.getGroup(name) != null) {
                    isGroup = true;
                }
                if (isGroup) {
                    groups.add(name);
                    continue;
                }
                users.add(name);
            }
            catch (EntityException entityException) {
                // empty catch block
            }
        }
        return new UsersListResolver.UsersReference(users, groups);
    }

    @Override
    public UsersListResolver.UsersReference makeGroupsReference(String value) {
        String[] groupsValues = MiscUtils.splitAndTrim(value);
        ArrayList<String> users = new ArrayList<String>();
        ArrayList<String> groups = new ArrayList<String>();
        for (String name : groupsValues) {
            boolean isGroup = false;
            try {
                boolean isValueReference;
                boolean bl = isValueReference = name.startsWith("@") && name.endsWith("@");
                if (isValueReference || this.groupManager.getGroup(name) != null) {
                    isGroup = true;
                }
                if (isGroup) {
                    groups.add(name);
                    continue;
                }
                users.add(name);
            }
            catch (EntityException entityException) {
                // empty catch block
            }
        }
        return new UsersListResolver.UsersReference(users, groups);
    }

    private void appendPageWatchers(AbstractPage page, LinkedHashMap<String, ConfluenceUser> users) {
        if (page == null) {
            return;
        }
        List<String> watcherNames = this.getWatchersUsersNames(page);
        for (String watcherName : watcherNames) {
            ConfluenceUser user;
            if (users.get(watcherName) != null || (user = this.userAccessor.getUserByName(watcherName)) == null) continue;
            users.put(watcherName, user);
        }
    }

    private String trimReferenceMarkers(String reference) {
        if (ValueReference.isValueReference(reference)) {
            if (reference.endsWith("@")) {
                return reference.substring(1, reference.length() - 1);
            }
            return reference.substring(1);
        }
        return reference;
    }

    public static class DefaultConfig
    implements UsersListResolver.Config {
        boolean expandGroupMembers;
        boolean ignoreUserLimit;
        UsersListResolver.ResolverErrorHandling errorHandling;
        boolean isRestrictionsMacro;

        public DefaultConfig() {
            this(false, UsersListResolver.ResolverErrorHandling.EXCEPTION_RESOLVER, false);
        }

        public DefaultConfig(boolean expandGroupMembers, UsersListResolver.ResolverErrorHandling errorHandling) {
            this(expandGroupMembers, errorHandling, false);
        }

        public DefaultConfig(UsersListResolver.ResolverErrorHandling errorHandling) {
            this(false, errorHandling, false);
        }

        public DefaultConfig(String preserveType) {
            this(false, UsersListResolver.ResolverErrorHandling.fromString(preserveType), false);
        }

        public DefaultConfig(boolean expandGroupMembers, UsersListResolver.ResolverErrorHandling errorHandling, boolean isRestrictions) {
            this.expandGroupMembers = expandGroupMembers;
            this.ignoreUserLimit = !expandGroupMembers;
            this.errorHandling = errorHandling;
            this.isRestrictionsMacro = isRestrictions;
        }

        @Override
        public boolean isExpandGroupMembers() {
            return this.expandGroupMembers;
        }

        @Override
        public boolean isIgnoreUserLimit() {
            return this.ignoreUserLimit;
        }

        @Override
        public UsersListResolver.ResolverErrorHandling getErrorHandling() {
            return this.errorHandling;
        }

        @Override
        public boolean isIgnoreResolverExceptions() {
            return !this.errorHandling.equals((Object)UsersListResolver.ResolverErrorHandling.EXCEPTION_ALL) && !this.errorHandling.equals((Object)UsersListResolver.ResolverErrorHandling.EXCEPTION_RESOLVER);
        }

        @Override
        public boolean isIgnoreAllExceptions() {
            return !this.errorHandling.equals((Object)UsersListResolver.ResolverErrorHandling.EXCEPTION_ALL);
        }

        @Override
        public boolean isRestrictionsMacro() {
            return this.isRestrictionsMacro;
        }
    }

    public class DefaultUserGroupResolved
    implements UsersListResolver.UserGroupResolved {
        private final LinkedHashMap<String, ConfluenceUser> userMap;
        private LinkedHashMap<String, ConfluenceUser> usersMapAppendingGroupsMembers;
        private final LinkedHashMap<String, Group> groupMap;

        public DefaultUserGroupResolved(LinkedHashMap<String, ConfluenceUser> userMap, LinkedHashMap<String, Group> groupMap) {
            this.userMap = userMap;
            this.groupMap = groupMap;
        }

        public void expandUsers(boolean expandGroupMembers, boolean ignoreUserLimit) throws WorkflowUserException {
            LinkedHashMap<String, ConfluenceUser> totalUsers = new LinkedHashMap<String, ConfluenceUser>();
            if (!ignoreUserLimit && this.userMap.size() > DefaultUsersListResolver.this.getMaxHandledUsers()) {
                DefaultUsersListResolver.this.throwMaxHandledUsersLimitReachedError();
            }
            totalUsers.putAll(this.userMap);
            if (expandGroupMembers) {
                for (Map.Entry<String, Group> groupEntry : this.groupMap.entrySet()) {
                    Pager pager;
                    try {
                        pager = DefaultUsersListResolver.this.groupManager.getMemberNames(groupEntry.getValue());
                    }
                    catch (EntityException e) {
                        continue;
                    }
                    for (String userName : pager) {
                        ConfluenceUser user;
                        if (this.userMap.get(userName) != null || (user = DefaultUsersListResolver.this.userAccessor.getUserByName(userName)) == null) continue;
                        totalUsers.put(userName, user);
                        if (ignoreUserLimit || totalUsers.size() <= DefaultUsersListResolver.this.getMaxHandledUsers()) continue;
                        DefaultUsersListResolver.this.throwMaxHandledUsersLimitReachedError();
                    }
                }
            }
            this.usersMapAppendingGroupsMembers = totalUsers;
        }

        @Override
        public List<ConfluenceUser> getUsersOnly() {
            return this.userMap != null ? new ArrayList<ConfluenceUser>(this.userMap.values()) : new ArrayList();
        }

        @Override
        public List<Group> getGroupsOnly() {
            return this.groupMap != null ? new ArrayList<Group>(this.groupMap.values()) : new ArrayList();
        }

        @Override
        public Map<String, Group> getGroupsOnlyMap() {
            return this.groupMap;
        }

        @Override
        public Map<String, ConfluenceUser> getUsersOnlyMap() {
            return this.userMap;
        }

        @Override
        public List<ConfluenceUser> getUsersIncludingGroupMembers() {
            if (this.usersMapAppendingGroupsMembers == null) {
                try {
                    this.expandUsers(false, true);
                }
                catch (WorkflowUserException e) {
                    e.printStackTrace();
                }
            }
            return this.usersMapAppendingGroupsMembers != null ? new ArrayList<ConfluenceUser>(this.usersMapAppendingGroupsMembers.values()) : new ArrayList();
        }

        @Override
        public Map<String, ConfluenceUser> getUsersMapIncludingGroupMembers() {
            if (this.usersMapAppendingGroupsMembers == null) {
                try {
                    this.expandUsers(false, true);
                }
                catch (WorkflowUserException e) {
                    e.printStackTrace();
                }
            }
            return this.usersMapAppendingGroupsMembers != null ? this.usersMapAppendingGroupsMembers : new LinkedHashMap<String, ConfluenceUser>();
        }

        @Override
        public Collection<Entity> getLinkedUsersAndGroups() {
            ArrayList<Entity> list = new ArrayList<Entity>();
            list.addAll(this.userMap.values());
            list.addAll(this.groupMap.values());
            return list;
        }
    }
}

