/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.users;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.search.query.entity.UserQuery;
import com.atlassian.crowd.search.query.entity.restriction.BooleanRestriction;
import com.atlassian.crowd.search.query.entity.restriction.BooleanRestrictionImpl;
import com.atlassian.crowd.search.query.entity.restriction.MatchMode;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.TermRestriction;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.comalatech.confluence.adhocworkflows.rest.model.UsersQuerySearchResults;
import com.comalatech.confluence.users.UserSearchManager;
import com.comalatech.confluence.workflow.WorkflowAdvancedConfigurationManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrowdSearchManager {
    private static final Logger log = LoggerFactory.getLogger(CrowdSearchManager.class);
    private final WorkflowAdvancedConfigurationManager workflowAdvancedConfigurationManager;
    private final CrowdService crowdService;
    private final UserAccessor userAccessor;
    private final UserSearchManager userSearchManager;

    public CrowdSearchManager(WorkflowAdvancedConfigurationManager workflowAdvancedConfigurationManager, CrowdService crowdService, UserAccessor userAccessor, UserSearchManager userSearchManager) {
        this.workflowAdvancedConfigurationManager = workflowAdvancedConfigurationManager;
        this.crowdService = crowdService;
        this.userAccessor = userAccessor;
        this.userSearchManager = userSearchManager;
    }

    public UsersQuerySearchResults userSearch(String query, String users, String groups, String excludedUsers) {
        if (log.isDebugEnabled()) {
            log.debug("query: " + query + " usersFilter: " + users + " groupsFilter: " + groups + " excludedUsersFilter: " + excludedUsers);
        }
        UsersQuerySearchResults results = StringUtils.isNotBlank((CharSequence)query) ? (query.length() < this.workflowAdvancedConfigurationManager.getUserSearchMinCharacters() ? this.userSearchManager.buildStaticResults(null, null, null) : this.buildSearchResultsCrowdService(query, users, groups, excludedUsers)) : this.userSearchManager.buildStaticResults(users, groups, excludedUsers);
        if (log.isDebugEnabled()) {
            log.debug("search complete: " + results.results);
        }
        return results;
    }

    protected UsersQuerySearchResults buildSearchResultsCrowdService(String query, String users, String groups, String excludedUsers) {
        Set<String> filterUsers = this.userSearchManager.parseList(users);
        Set<String> filterGroups = this.userSearchManager.parseList(groups);
        Set<String> filterExcludedUsers = this.userSearchManager.parseList(excludedUsers);
        ArrayList<Object> finalRestrictionsList = new ArrayList<Object>();
        int max_results = -1;
        boolean skipFiltering = false;
        Property userNameProp = UserTermKeys.USERNAME;
        Property fullNameProp = UserTermKeys.DISPLAY_NAME;
        Property firstNameProp = UserTermKeys.FIRST_NAME;
        Property lastNameProp = UserTermKeys.LAST_NAME;
        Property emailProp = UserTermKeys.EMAIL;
        Property activeUserProp = UserTermKeys.ACTIVE;
        MatchMode contains = MatchMode.CONTAINS;
        MatchMode exactlyMatches = MatchMode.EXACTLY_MATCHES;
        TermRestriction activeUserRestriction = new TermRestriction(activeUserProp, exactlyMatches, (Object)true);
        finalRestrictionsList.add(activeUserRestriction);
        if (StringUtils.isNotEmpty((CharSequence)query)) {
            TermRestriction userNameRestriction = new TermRestriction(userNameProp, contains, (Object)query);
            TermRestriction fullNameRestriction = new TermRestriction(fullNameProp, contains, (Object)query);
            TermRestriction emailRestriction = new TermRestriction(emailProp, contains, (Object)query);
            TermRestriction firstNameRestriction = new TermRestriction(firstNameProp, contains, (Object)query);
            TermRestriction lastNameRestriction = new TermRestriction(lastNameProp, contains, (Object)query);
            BooleanRestrictionImpl group1QueryNamesRestriction = new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.OR, new SearchRestriction[]{userNameRestriction, fullNameRestriction, emailRestriction, firstNameRestriction, lastNameRestriction});
            finalRestrictionsList.add(group1QueryNamesRestriction);
        }
        if (filterUsers.size() > 0 && filterGroups.isEmpty()) {
            ArrayList<TermRestriction> filterUserRestrictionList = new ArrayList<TermRestriction>();
            for (String userName : filterUsers) {
                TermRestriction assignedUserRestriction = new TermRestriction(userNameProp, exactlyMatches, (Object)userName);
                filterUserRestrictionList.add(assignedUserRestriction);
            }
            BooleanRestrictionImpl group2FilterUsers = new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.OR, filterUserRestrictionList);
            finalRestrictionsList.add(group2FilterUsers);
            max_results = 15;
            skipFiltering = true;
        }
        if (filterGroups.isEmpty() && filterUsers.isEmpty()) {
            max_results = 15;
            skipFiltering = true;
        }
        BooleanRestrictionImpl finalRestriction = new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.AND, finalRestrictionsList);
        UserQuery userQuery = new UserQuery(User.class, (SearchRestriction)finalRestriction, 0, max_results);
        if (log.isDebugEnabled()) {
            log.debug("searching using query: " + finalRestriction);
        }
        Iterable userIterable = this.crowdService.search((Query)userQuery);
        ArrayList<ConfluenceUser> userList = new ArrayList<ConfluenceUser>();
        for (User iterUser : userIterable) {
            if (!filterExcludedUsers.isEmpty() && filterExcludedUsers.contains(iterUser.getName())) continue;
            userList.add(this.userAccessor.getUserByName(iterUser.getName()));
        }
        if (log.isDebugEnabled()) {
            log.debug("search complete, resultCount: " + userList.size());
        }
        if (!userList.isEmpty()) {
            if (skipFiltering) {
                return this.userSearchManager.buildSearchResults(userList);
            }
            return this.userSearchManager.buildSearchResults(this.filterUsers(userList, filterUsers, filterGroups));
        }
        return this.userSearchManager.buildSearchResults(new ArrayList<ConfluenceUser>());
    }

    public List<ConfluenceUser> filterUsers(List<ConfluenceUser> users, Set<String> filterUserNames, Set<String> filterGroupNames) {
        if (log.isDebugEnabled()) {
            log.debug("usersSize: " + users.size() + "   filterUserNames: " + filterUserNames + " filterGroupNames" + filterGroupNames);
        }
        ArrayList<ConfluenceUser> returnUsers = new ArrayList<ConfluenceUser>(15);
        for (ConfluenceUser user : users) {
            if (!this.userFilterMatch(user, filterUserNames, filterGroupNames)) continue;
            returnUsers.add(user);
            if (returnUsers.size() < 15) continue;
            break;
        }
        return returnUsers;
    }

    private boolean userFilterMatch(ConfluenceUser user, Set<String> filterUserNames, Set<String> filterGroupNames) {
        if (filterUserNames.isEmpty() && filterGroupNames.isEmpty()) {
            return true;
        }
        if (filterUserNames.contains(user.getName())) {
            return true;
        }
        if (!filterGroupNames.isEmpty()) {
            List groupNames = this.userAccessor.getGroupNames((com.atlassian.user.User)user);
            for (String groupName : groupNames) {
                if (!filterGroupNames.contains(groupName)) continue;
                return true;
            }
        }
        return false;
    }
}

