/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.upgrade.resources.model;

import com.comalatech.confluence.documentActivity.upgrade.entity.domain.UpgradeTask;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@ApiModel(description="It is the current state of the upgrade in a space in which the upgrade task has been executed.")
public class RestSpaceUpgradeTask {
    @JsonProperty(value="key")
    @ApiModelProperty(value="space key", example="DEMO")
    private String spaceKey;
    @ApiModelProperty(value="Status of the actual state, possible outcomes: CHECK_NOT_RUN, CHECK_IN_PROGRESS, CHECK_SUCCESS, CHECK_FAIL, CHECK_CANCEL, UPGRADE_IN_PROGRESS, UPGRADE_SUCCESS, UPGRADE_FAIL, UPGRADE_CANCEL", example="UPGRADE_IN_PROGRESS")
    private String status;
    @ApiModelProperty(value="started date of the update task, the format is the current instant with the system UTC clock.", example="1672752415")
    private Long startedAt;
    @ApiModelProperty(value="The time in seconds, minutes, hours that the task has taken to be executed", example="2m ")
    private String duration;
    @ApiModelProperty(value="The percentage of the upgrade process that has been completed", example="75")
    private Integer progress;
    @ApiModelProperty(value="The number of errors found in the pages ", example="0")
    private Integer numErrors;
    @ApiModelProperty(value="The support file link, to complete the partial link concat the root url", example="/rest/cw/2/documentactivity/upgrade/support/DEMO")
    private String support;
    @ApiModelProperty(value="Phase the upgrade process is currently in", example="Phase 2/4 DB storage (AO Tables): page 1/5")
    private String phase;

    public RestSpaceUpgradeTask() {
    }

    public RestSpaceUpgradeTask(UpgradeTask upgradeTask) {
        this.setStartedAt(upgradeTask.getStartedAt());
        this.setDuration(upgradeTask.getDuration());
        this.setStatus(upgradeTask.getStatus() != null ? upgradeTask.getStatus().getValue() : null);
        this.setProgress(upgradeTask.getProgress());
        this.setNumErrors(upgradeTask.getNumErrors());
        this.setSupport(upgradeTask.getSupport());
        this.setPhase(upgradeTask.getPhase());
    }

    public String getSpaceKey() {
        return this.spaceKey;
    }

    public String getStatus() {
        return this.status;
    }

    public Long getStartedAt() {
        return this.startedAt;
    }

    public String getDuration() {
        return this.duration;
    }

    public Integer getProgress() {
        return this.progress;
    }

    public Integer getNumErrors() {
        return this.numErrors;
    }

    public String getSupport() {
        return this.support;
    }

    public String getPhase() {
        return this.phase;
    }

    public void setSpaceKey(String spaceKey) {
        this.spaceKey = spaceKey;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setStartedAt(Long startedAt) {
        this.startedAt = startedAt;
    }

    public void setDuration(String duration) {
        this.duration = duration;
    }

    public void setProgress(Integer progress) {
        this.progress = progress;
    }

    public void setNumErrors(Integer numErrors) {
        this.numErrors = numErrors;
    }

    public void setSupport(String support) {
        this.support = support;
    }

    public void setPhase(String phase) {
        this.phase = phase;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RestSpaceUpgradeTask)) {
            return false;
        }
        RestSpaceUpgradeTask other = (RestSpaceUpgradeTask)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$spaceKey = this.getSpaceKey();
        String other$spaceKey = other.getSpaceKey();
        if (this$spaceKey == null ? other$spaceKey != null : !this$spaceKey.equals(other$spaceKey)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        Long this$startedAt = this.getStartedAt();
        Long other$startedAt = other.getStartedAt();
        if (this$startedAt == null ? other$startedAt != null : !((Object)this$startedAt).equals(other$startedAt)) {
            return false;
        }
        String this$duration = this.getDuration();
        String other$duration = other.getDuration();
        if (this$duration == null ? other$duration != null : !this$duration.equals(other$duration)) {
            return false;
        }
        Integer this$progress = this.getProgress();
        Integer other$progress = other.getProgress();
        if (this$progress == null ? other$progress != null : !((Object)this$progress).equals(other$progress)) {
            return false;
        }
        Integer this$numErrors = this.getNumErrors();
        Integer other$numErrors = other.getNumErrors();
        if (this$numErrors == null ? other$numErrors != null : !((Object)this$numErrors).equals(other$numErrors)) {
            return false;
        }
        String this$support = this.getSupport();
        String other$support = other.getSupport();
        if (this$support == null ? other$support != null : !this$support.equals(other$support)) {
            return false;
        }
        String this$phase = this.getPhase();
        String other$phase = other.getPhase();
        return !(this$phase == null ? other$phase != null : !this$phase.equals(other$phase));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RestSpaceUpgradeTask;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $spaceKey = this.getSpaceKey();
        result = result * 59 + ($spaceKey == null ? 43 : $spaceKey.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        Long $startedAt = this.getStartedAt();
        result = result * 59 + ($startedAt == null ? 43 : ((Object)$startedAt).hashCode());
        String $duration = this.getDuration();
        result = result * 59 + ($duration == null ? 43 : $duration.hashCode());
        Integer $progress = this.getProgress();
        result = result * 59 + ($progress == null ? 43 : ((Object)$progress).hashCode());
        Integer $numErrors = this.getNumErrors();
        result = result * 59 + ($numErrors == null ? 43 : ((Object)$numErrors).hashCode());
        String $support = this.getSupport();
        result = result * 59 + ($support == null ? 43 : $support.hashCode());
        String $phase = this.getPhase();
        result = result * 59 + ($phase == null ? 43 : $phase.hashCode());
        return result;
    }

    public String toString() {
        return "RestSpaceUpgradeTask(spaceKey=" + this.getSpaceKey() + ", status=" + this.getStatus() + ", startedAt=" + this.getStartedAt() + ", duration=" + this.getDuration() + ", progress=" + this.getProgress() + ", numErrors=" + this.getNumErrors() + ", support=" + this.getSupport() + ", phase=" + this.getPhase() + ")";
    }
}

