/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.dataextractor;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.JsonString;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.JsonContentProperty;
import com.atlassian.confluence.api.model.validation.ValidationError;
import com.atlassian.confluence.api.model.validation.ValidationResult;
import com.atlassian.confluence.api.service.content.ContentPropertyService;
import com.atlassian.confluence.spring.transaction.interceptor.TransactionalHostContextAccessor;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonContentPropertyService {
    private static final Logger log = LoggerFactory.getLogger(JsonContentPropertyService.class);
    private final TransactionalHostContextAccessor transactionalHostContextAccessor;
    private final ContentPropertyService contentPropertyService;

    public JsonContentPropertyService(TransactionalHostContextAccessor transactionalHostContextAccessor, ContentPropertyService contentPropertyService) {
        this.transactionalHostContextAccessor = transactionalHostContextAccessor;
        this.contentPropertyService = contentPropertyService;
    }

    public boolean updateOrCreate(Content content, String key, String jsonString) {
        return (Boolean)this.transactionalHostContextAccessor.doInTransaction(TransactionalHostContextAccessor.Propagation.REQUIRES_NEW, TransactionalHostContextAccessor.Permission.READ_WRITE, () -> {
            boolean successfulCreation;
            JsonString json = new JsonString(jsonString);
            JsonContentProperty jsonContentProperty = (JsonContentProperty)this.contentPropertyService.find(new Expansion[0]).withContentId(content.getId()).withPropertyKey(key).fetchOrNull();
            if (jsonContentProperty == null) {
                if (log.isDebugEnabled()) {
                    log.debug("New property is going to be created with key '" + key + "' in page with id '" + content.getId() + "' because current property is null");
                }
                successfulCreation = this.create(content, key, json);
            } else {
                boolean hasMultipleVersions;
                if (log.isDebugEnabled()) {
                    log.debug("Current property with key '" + key + "' in page with id '" + content.getId() + "' is " + jsonContentProperty);
                }
                boolean oldAndNewAreEqual = Objects.equals(json, jsonContentProperty.getValue());
                boolean bl = hasMultipleVersions = jsonContentProperty.getVersion() != null && jsonContentProperty.getVersion().getNumber() > 1;
                if (hasMultipleVersions || !oldAndNewAreEqual) {
                    if (log.isDebugEnabled()) {
                        log.debug("Resetting property with key '" + key + "' in page with id '" + content.getId() + "' because has equals current and generated props: '" + oldAndNewAreEqual + "' or/and has multiple versions: '" + hasMultipleVersions + "'");
                    }
                    successfulCreation = this.reset(content, key, json);
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug("Not resetting property with key '" + key + "' in page with id '" + content.getId() + "' because has equals current and generated props and has not multiple versions.");
                    }
                    successfulCreation = true;
                }
            }
            return successfulCreation;
        });
    }

    protected boolean create(Content content, String propertyKey, JsonString propertyJson) {
        boolean successfulValidation = false;
        JsonContentProperty.ContentPropertyBuilder builder = JsonContentProperty.builder();
        builder.content(content).key(propertyKey).value(propertyJson);
        JsonContentProperty jcp = builder.build();
        if (this.isCreateValid(jcp, propertyKey, content.getId().asLong())) {
            this.contentPropertyService.create(jcp);
            successfulValidation = true;
        } else if (log.isDebugEnabled()) {
            log.debug("Performing creation for property with key '" + propertyKey + "' in page with id '" + content.getId().toString() + "' failed because action is not valid");
        }
        return successfulValidation;
    }

    private boolean isCreateValid(JsonContentProperty jsonContentProperty, String key, long pageId) {
        ValidationResult validationResult = this.contentPropertyService.validator().validateCreate(jsonContentProperty);
        if (validationResult.isNotSuccessful()) {
            log.error("Property with key '" + key + "' in page with id '" + pageId + "' creation validation failed");
            if (validationResult.getErrors() != null) {
                for (ValidationError error : validationResult.getErrors()) {
                    if (error == null) continue;
                    log.error("Property with key '" + key + "' in page with id '" + pageId + "' creation validation error: " + error.getMessage());
                }
            }
            if (!validationResult.isAuthorized()) {
                log.error("Property with key '" + key + "' in page with id '" + pageId + "' creation validation authorisation failed");
            }
            if (!validationResult.isAllowedInReadOnlyMode()) {
                log.error("Property with key '" + key + "' in page with id '" + pageId + "' creation validation failed with read only mode check");
            }
        }
        return validationResult.isSuccessful();
    }

    protected boolean reset(Content content, String propertyKey, JsonString propertyJson) {
        boolean deleteResult = this.delete(content, propertyKey);
        boolean createResult = false;
        if (deleteResult) {
            createResult = this.create(content, propertyKey, propertyJson);
        }
        return deleteResult && createResult;
    }

    public boolean delete(Content content, String key) {
        boolean successfulValidation = false;
        try {
            if (content != null) {
                JsonContentProperty comalaworkflowsCP = (JsonContentProperty)this.contentPropertyService.find(new Expansion[0]).withContentId(content.getId()).withPropertyKey(key).fetchOrNull();
                if (comalaworkflowsCP != null) {
                    if (this.isDeleteValid(comalaworkflowsCP, key, content.getId().asLong())) {
                        this.contentPropertyService.delete(comalaworkflowsCP);
                        successfulValidation = true;
                    } else if (log.isDebugEnabled()) {
                        log.debug("Performing delete for property with key '" + key + "' in page with id '" + content.getId() + "' failed because action is not valid");
                    }
                } else {
                    successfulValidation = true;
                }
            }
        }
        catch (Exception e) {
            log.error("Problems removing " + key + " associated to " + content.getId(), (Throwable)e);
        }
        return successfulValidation;
    }

    private boolean isDeleteValid(JsonContentProperty jsonContentProperty, String key, long pageId) {
        ValidationResult validationResult = this.contentPropertyService.validator().validateDelete(jsonContentProperty);
        if (validationResult.isNotSuccessful()) {
            log.error("Property with key '" + key + "' in page with id '" + pageId + "' deletion validation failed");
            if (validationResult.getErrors() != null) {
                for (ValidationError error : validationResult.getErrors()) {
                    if (error == null) continue;
                    log.error("Property with key '" + key + "' in page with id '" + pageId + "' deletion validation error: " + error.getMessage());
                }
            }
            if (!validationResult.isAuthorized()) {
                log.error("Property with key '" + key + "' in page with id '" + pageId + "' deletion validation authorisation failed");
            }
            if (!validationResult.isAllowedInReadOnlyMode()) {
                log.error("Property with key '" + key + "' in page with id '" + pageId + "' deletion validation failed with read only mode check");
            }
        }
        return validationResult.isSuccessful();
    }
}

