/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhocworkflows.rest;

import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelParser;
import com.atlassian.confluence.labels.ParsedLabelName;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.plugins.createcontent.extensions.BlueprintModuleDescriptor;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.WikiStyleRenderer;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.user.User;
import com.comalatech.confluence.adhoc.AdhocWorkflowManager;
import com.comalatech.confluence.adhocworkflows.rest.AbstractContentWorkflowResources;
import com.comalatech.confluence.adhocworkflows.rest.AbstractRestResources;
import com.comalatech.confluence.adhocworkflows.rest.model.JsonStates;
import com.comalatech.confluence.adhocworkflows.rest.model.RenderedInstructions;
import com.comalatech.confluence.adhocworkflows.rest.model.WorkflowAction;
import com.comalatech.confluence.adhocworkflows.rest.model.WorkflowRequest;
import com.comalatech.confluence.adhocworkflows.rest.permissions.EditPagePermissionRequired;
import com.comalatech.confluence.adhocworkflows.rest.permissions.ViewWorkflowPermissionRequired;
import com.comalatech.confluence.adhocworkflows.rest.permissions.WorkflowsAppRequired;
import com.comalatech.confluence.adhocworkflows.rest.permissions.WorkflowsLiteAppRequired;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import com.comalatech.confluence.license.AdhocWorkflowsLicenseManager;
import com.comalatech.confluence.license.PluginLicenseStatus;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.states.StateAccessor;
import com.comalatech.confluence.states.dao.sax.PageStateConverter;
import com.comalatech.confluence.users.UserSearchManager;
import com.comalatech.confluence.util.MiscUtils;
import com.comalatech.confluence.workflow.ApprovalAccessor;
import com.comalatech.confluence.workflow.DefaultApprovalRolesManager;
import com.comalatech.confluence.workflow.InternalWorkflowParameterManager;
import com.comalatech.confluence.workflow.PageWorkflows;
import com.comalatech.confluence.workflow.Workflow;
import com.comalatech.confluence.workflow.WorkflowAccessor;
import com.comalatech.confluence.workflow.WorkflowConfigurationManager;
import com.comalatech.confluence.workflow.dao.sax.ApprovalChecksConverter;
import com.comalatech.confluence.workflow.esignatures.configuration.ESignaturesConfigurationManager;
import com.comalatech.confluence.workflow.esignatures.service.ESignaturesService;
import com.comalatech.confluence.workflow.model.Instructions;
import com.comalatech.confluence.workflow.permissions.WorkflowPermissionManager;
import com.comalatech.confluence.workflowcontainer.WorkflowContainerManager;
import com.comalatech.workflow.StateService;
import com.comalatech.workflow.WorkflowException;
import com.comalatech.workflow.WorkflowHandler;
import com.comalatech.workflow.WorkflowService;
import com.comalatech.workflow.model.State;
import com.comalatech.workflow.template.WorkflowTemplateManager;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.springframework.beans.factory.annotation.Qualifier;

@Path(value="/workflow")
public class WorkflowsResources
extends AbstractContentWorkflowResources {
    protected final PluginAccessor pluginAccessor;
    protected final StateService stateService;
    protected final WorkflowService workflowService;
    protected final AdhocWorkflowsLicenseManager licenseManager;
    private final StateAccessor stateAccessor;
    private final ApprovalAccessor approvalAccessor;
    public static final String CUSTOM_STATES_WORKFLOWS_NAME = "Custom States Workflow";

    public WorkflowsResources(PageManager pageManager, PermissionManager permissionManager, WorkflowPermissionManager workflowPermissionManager, SpaceManager spaceManager, SpacePermissionManager spacePermissionManager, AccessModeService accessModeService, WorkflowsFeatureManager workflowsFeatureManager, WorkflowConfigurationManager workflowConfigurationManager, WorkflowHandler workflowHandler, UserSearchManager userSearchManager, BootstrapManager bootstrapManager, WikiStyleRenderer wikiStyleRenderer, InternalWorkflowParameterManager workflowParameterManager, AdhocWorkflowManager adhocWorkflowManager, WorkflowTemplateManager workflowTemplateManager, WorkflowAccessor workflowAccessor, WorkflowContainerManager workflowContainerManager, PluginAccessor pluginAccessor, StateService stateService, WorkflowService workflowService, @Qualifier(value="adhocWorkflowsLicenseManager") AdhocWorkflowsLicenseManager licenseManager, ESignaturesConfigurationManager eSignaturesConfigurationManager, ESignaturesService eSignaturesService, StateAccessor stateAccessor, ApprovalAccessor approvalAccessor, DefaultApprovalRolesManager defaultApprovalRolesManager, ComalaI18nBean comalaI18nBean) {
        super(pageManager, permissionManager, workflowPermissionManager, spaceManager, spacePermissionManager, accessModeService, workflowsFeatureManager, workflowConfigurationManager, workflowHandler, userSearchManager, bootstrapManager, wikiStyleRenderer, workflowParameterManager, adhocWorkflowManager, workflowTemplateManager, workflowAccessor, workflowContainerManager, eSignaturesConfigurationManager, eSignaturesService, defaultApprovalRolesManager, comalaI18nBean);
        this.pluginAccessor = pluginAccessor;
        this.stateService = stateService;
        this.workflowService = workflowService;
        this.licenseManager = licenseManager;
        this.stateAccessor = stateAccessor;
        this.approvalAccessor = approvalAccessor;
    }

    @WorkflowsAppRequired
    @GET
    @Produces(value={"application/json"})
    @Path(value="/{spaceKey}/instructions/create")
    public Response instructions(@PathParam(value="spaceKey") String spaceKey, @QueryParam(value="blueprintKey") String blueprintKey, @QueryParam(value="label") String label) {
        Space space = this.spaceManager.getSpace(spaceKey);
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (space == null || !this.spacePermissionManager.hasPermission("VIEWSPACE", space, (User)AuthenticatedUserThreadLocal.get())) {
            return Response.status((int)404).build();
        }
        boolean canViewWorkflows = this.workflowPermissionManager.canViewWorkflows(space, user);
        if (!canViewWorkflows) {
            return Response.status((int)403).build();
        }
        Instructions instructions = null;
        List<Label> labels = null;
        if (StringUtils.isNotBlank((CharSequence)label)) {
            labels = this.parseLabels(label);
        } else if (StringUtils.isNotBlank((CharSequence)blueprintKey)) {
            labels = this.parseLabels(this.getBlueprintLabel(blueprintKey));
        }
        List<Workflow> spaceWorkflows = this.workflowAccessor.getActiveSpaceWorkflows(spaceKey, labels);
        for (Workflow workflow : spaceWorkflows) {
            if (workflow.getCreateInstructions() == null) continue;
            instructions = workflow.getCreateInstructions();
            break;
        }
        if (instructions == null) {
            return Response.status((int)204).build();
        }
        return Response.ok((Object)this.renderInstructions(instructions)).build();
    }

    private List<Label> parseLabels(String labels) {
        ArrayList<Label> labelsList = new ArrayList<Label>();
        if (StringUtils.isNotBlank((CharSequence)labels)) {
            for (String label : labels.split("\\s+")) {
                ParsedLabelName parsedLabel = LabelParser.parse((String)label);
                if (parsedLabel == null) continue;
                labelsList.add(parsedLabel.toLabel());
            }
        }
        return labelsList;
    }

    private String getBlueprintLabel(String key) {
        List blueprints = this.pluginAccessor.getEnabledModuleDescriptorsByClass(BlueprintModuleDescriptor.class);
        for (BlueprintModuleDescriptor blueprint : blueprints) {
            if (!blueprint.getCompleteKey().equals(key)) continue;
            return blueprint.getIndexKey();
        }
        return null;
    }

    private RenderedInstructions renderInstructions(Instructions instructions) {
        PageContext pageContext = new Page().toPageContext();
        pageContext.pushRenderMode(RenderMode.suppress((long)256L));
        String body = this.wikiStyleRenderer.convertWikiToXHtml((RenderContext)pageContext, instructions.getBody());
        return new RenderedInstructions(StringEscapeUtils.escapeHtml4((String)instructions.getTitle()), body, instructions.getStyle().toString());
    }

    @ViewWorkflowPermissionRequired
    @WorkflowsAppRequired
    @WorkflowsLiteAppRequired
    @GET
    @Produces(value={"application/json"})
    @Path(value="/{pageId}/templates")
    @Deprecated
    public Response getTemplates(@PathParam(value="pageId") long pageId) {
        class GetTemplatesCommand
        extends AbstractRestResources.WorkflowCommand {
            GetTemplatesCommand() {
            }

            @Override
            public Response doInCommand(AbstractPage page) {
                return Response.ok(WorkflowsResources.this.getTemplates(page)).build();
            }
        }
        return new GetTemplatesCommand().execute(pageId);
    }

    @ViewWorkflowPermissionRequired
    @GET
    @Produces(value={"application/json"})
    @Path(value="/{pageId}/states")
    public Response getStates(@PathParam(value="pageId") long pageId) {
        class GetStatesComment
        extends AbstractRestResources.WorkflowCommand {
            GetStatesComment() {
            }

            @Override
            public Response doInCommand(AbstractPage page) {
                List<? extends State> states = WorkflowsResources.this.stateService.getStates((ContentEntityObject)page);
                JsonStates statesRest = new JsonStates(states);
                return Response.ok((Object)statesRest).build();
            }
        }
        return new GetStatesComment().execute(pageId);
    }

    @EditPagePermissionRequired
    @WorkflowsAppRequired
    @WorkflowsLiteAppRequired
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/{pageId}/add")
    public Response addWorkflow(@PathParam(value="pageId") long pageId, final @QueryParam(value="default") boolean defaultWorkflow, final WorkflowRequest worklowRequest) {
        class AddWorkflowCommand
        extends AbstractRestResources.WorkflowCommand {
            AddWorkflowCommand() {
            }

            @Override
            public Response doInCommand(AbstractPage page) throws WorkflowException {
                if (defaultWorkflow) {
                    WorkflowsResources.this.workflowService.loadWorkflow((ContentEntityObject)page, WorkflowsResources.this.workflowHandler.getDefaultApprovalWorkflowMarkup(page.getSpaceKey()));
                    return WorkflowsResources.this.getStatus(page, false);
                }
                if (worklowRequest.getWorkflowId() == 0L) {
                    WorkflowsResources.this.workflowService.loadWorkflow((ContentEntityObject)page, WorkflowsResources.this.makeAdhocWorkflowMarkup(worklowRequest.getStateNames()));
                    return WorkflowsResources.this.getStatus(page, false);
                }
                List<com.comalatech.workflow.model.Workflow> templates = WorkflowsResources.this.getWorkflowTemplates(page);
                for (com.comalatech.workflow.model.Workflow template : templates) {
                    if (worklowRequest.getWorkflowId() != (long)template.getName().hashCode()) continue;
                    WorkflowsResources.this.workflowService.loadWorkflow((ContentEntityObject)page, template.getWorkflowMarkup());
                    return WorkflowsResources.this.getStatus(page, false);
                }
                return Response.notModified().build();
            }
        }
        return new AddWorkflowCommand().execute(pageId);
    }

    @EditPagePermissionRequired
    @GET
    @Produces(value={"text/plain"})
    @Path(value="/{pageId}/debug")
    public Response getPageDebugInfo(@PathParam(value="pageId") long pageId) {
        class GetDebuggingInfo
        extends AbstractRestResources.WorkflowCommand {
            GetDebuggingInfo() {
            }

            @Override
            public Response doInCommand(AbstractPage page) {
                String appName;
                StringBuilder debugsString = new StringBuilder("Latest State XML\n");
                debugsString.append(PageStateConverter.convertToXml(WorkflowsResources.this.stateAccessor.getLatestState(page)));
                debugsString.append("\n\nStates XML\n");
                debugsString.append(PageStateConverter.convertToXml(WorkflowsResources.this.stateAccessor.getPageStates(page)));
                debugsString.append("\n\nApproval Checks XML\n");
                debugsString.append(ApprovalChecksConverter.convertToXml(WorkflowsResources.this.approvalAccessor.getApprovalChecks(page)));
                debugsString.append("\n\nLatest Approval Check XML\n");
                debugsString.append(ApprovalChecksConverter.convertToXml(WorkflowsResources.this.approvalAccessor.getLatestApprovalCheck(page)));
                debugsString.append("\n\nFinal Approval Check XML\n");
                debugsString.append(ApprovalChecksConverter.convertToXml(WorkflowsResources.this.approvalAccessor.getFinalApprovalCheck(page)));
                PageWorkflows pageWorkflows = WorkflowsResources.this.workflowAccessor.getPageWorkflows(page);
                String string = appName = WorkflowsResources.this.workflowsFeatureManager.isWorkflowsApp() ? "Workflow" : "Approval";
                if (pageWorkflows != null) {
                    List<Workflow> workflows = pageWorkflows.getWorkflows();
                    debugsString.append("\n\nActive ").append(appName).append("s\n");
                    for (Workflow workflow : workflows) {
                        debugsString.append(workflow.getName()).append(" |  Labels: ").append(workflow.getLabelNames()).append(" invertLabels: ").append(workflow.isInvertLabels()).append("\n");
                    }
                    debugsString.append("\n\n").append(appName).append(" Markup\n");
                    for (Workflow workflow : workflows) {
                        debugsString.append(workflow.getName()).append("\n");
                        debugsString.append(workflow.getWorkflowMarkup()).append("\n\n");
                    }
                    debugsString.append("Suggested Contributors: [").append(WorkflowsResources.this.userSearchManager.getContributors(page, true).toString()).append("]\n\n");
                } else {
                    debugsString.append("\n\nNo Active ").append(appName).append("s\n\n");
                }
                debugsString.append("Plugin and License info\n");
                Plugin plugin = WorkflowsResources.this.pluginAccessor.getEnabledPlugin(WorkflowsResources.this.workflowsFeatureManager.getPluginKey());
                debugsString.append(plugin.getName()).append(" ").append(plugin.getPluginInformation().getVersion()).append("\n");
                PluginLicenseStatus status = WorkflowsResources.this.licenseManager.getLicenseStatus();
                if (StringUtils.isNotBlank((CharSequence)status.getMessageHtml())) {
                    debugsString.append(status.getMessageHtml()).append("\n");
                }
                if (StringUtils.isNotBlank((CharSequence)status.getStatus().name())) {
                    debugsString.append(status.getStatus().name()).append("\n");
                }
                return Response.ok((Object)debugsString.toString()).build();
            }
        }
        return new GetDebuggingInfo().execute(pageId);
    }

    @ViewWorkflowPermissionRequired
    @GET
    @Produces(value={"application/json"})
    @Path(value="/{pageId}/actions")
    public Response getActions(@PathParam(value="pageId") long pageId, final @QueryParam(value="admin") boolean admin, final @QueryParam(value="publishedView") boolean publishedView) {
        class GetActionsCommand
        extends AbstractRestResources.WorkflowCommand {
            GetActionsCommand() {
            }

            @Override
            public Response doInCommand(AbstractPage page) {
                WorkflowAction workflowAction = WorkflowsResources.this.makeWorkflowAction(page, admin, false, publishedView);
                if (WorkflowsResources.this.licenseManager.isLicensed()) {
                    return Response.ok((Object)workflowAction).build();
                }
                workflowAction.setMessageHtml(WorkflowsResources.this.licenseManager.getLicenseStatus().getMessageHtml());
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)workflowAction).build();
            }
        }
        return new GetActionsCommand().execute(pageId);
    }

    private String makeAdhocWorkflowMarkup(String stateNames) {
        String[] states = MiscUtils.splitAndTrim(stateNames);
        StringBuilder workflow = new StringBuilder("{workflow:name=").append(CUSTOM_STATES_WORKFLOWS_NAME).append("}\n");
        for (String state : states) {
            workflow.append("{state:").append(state).append("|taskable=true}{state}\n");
        }
        return workflow.append("\n{workflow}").toString();
    }
}

