/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoc.notification.model;

import com.atlassian.confluence.util.GeneralUtil;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public abstract class Notification {
    public static final String ACTIVITY_DESCRIPTION_I18N = "activityDescription";
    public static final String SLACK_ACTIVITY_DESCRIPTION_I18N = "slackActivityDescription";
    protected long entityId;
    protected Map<String, Object> contextProperties = new HashMap<String, Object>();

    public abstract String getSubject();

    public abstract String getTemplateName();

    public abstract String getBody(MessageSystem var1);

    public String getTemplateLocation() {
        return "/templates/adhocworkflows/email/" + this.getTemplateName() + ".vm";
    }

    public long getEntityId() {
        return this.entityId;
    }

    public void setEntityId(long entityId) {
        this.entityId = entityId;
    }

    public void addContextProperty(String key, Object value) {
        this.contextProperties.put(key, value);
    }

    public Map<String, Object> getContextProperties() {
        return this.contextProperties;
    }

    protected String getBaseUrl() {
        String domainName = GeneralUtil.getGlobalSettings().getBaseUrl();
        if (StringUtils.isNotBlank((CharSequence)domainName) && domainName.endsWith("/")) {
            domainName = domainName.substring(0, domainName.length() - 1);
        }
        return domainName;
    }

    public static enum MessageSystem {
        SLACK,
        EMAIL;

    }
}

