/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoc.notification.model;

import com.atlassian.confluence.user.ConfluenceUser;
import com.comalatech.confluence.adhoc.notification.model.Notification;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import org.springframework.web.util.HtmlUtils;

public class ApprovalAssignedNotification
extends Notification {
    public static final String APPROVAL_NAME_KEY = "approvalName";
    public static final String ASSIGNEE_KEY = "assignee";
    public static final String PAGE_TITLE_KEY = "pageTitle";
    public static final String NOTE_KEY = "assignmentNoteHtml";

    @Override
    public String getSubject() {
        return HtmlUtils.htmlEscape((String)ComalaI18nBean.getComalaI18nBean().getText("com.comalatech.approval.notification.assigned.subject", new String[]{(String)this.getContextProperties().get(APPROVAL_NAME_KEY), (String)this.getContextProperties().get(PAGE_TITLE_KEY)}));
    }

    @Override
    public String getTemplateName() {
        return "approval-assigned";
    }

    @Override
    public String getBody(Notification.MessageSystem notificationMessageSystem) {
        ConfluenceUser assignee = (ConfluenceUser)this.getContextProperties().get(ASSIGNEE_KEY);
        String approvalId = "approvalv2-" + this.getContextProperties().get(APPROVAL_NAME_KEY).hashCode() + "-" + assignee.getName().hashCode();
        String approvalLinkHtml = this.getBaseUrl() + "/pages/viewpage.action?pageId=" + this.getEntityId() + "&approval=" + approvalId;
        switch (notificationMessageSystem) {
            case EMAIL: {
                String description = (String)this.getContextProperties().get("activityDescription");
                return HtmlUtils.htmlEscape((String)ComalaI18nBean.getComalaI18nBean().getText(description, new String[]{(String)this.getContextProperties().get(APPROVAL_NAME_KEY), approvalLinkHtml}));
            }
            case SLACK: {
                String description = (String)this.getContextProperties().get("slackActivityDescription");
                return ComalaI18nBean.getComalaI18nBean().getText(description, new String[]{(String)this.getContextProperties().get(APPROVAL_NAME_KEY), approvalLinkHtml});
            }
        }
        throw new IllegalArgumentException("Type notification not valid");
    }
}

