/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

var requirejs = require || requirejs;
requirejs(['cw', 'jquery'], function (CW, $) {
    console.log('designer.js');
    CW.toInit(function () {
        // Load Workflow designer in an iframe
        var iframe = new CW.iframe({
            id: 'cwdesigner-iframe',
            url: '/designer/' + CW.getParam('pageId'),
        });
        $('#cwdesigner').html(iframe.render());

        // move navigation to top
        $('#main-header').prepend($('#navigation'));
    });
});