/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

var AWP = AWP || {};
var requirejs = require || requirejs;

/**
 * Stuff to handle the instructions in the RTE
 */
AWP.BlueprintsHelper = (function() {
    "use strict";
    requirejs(['cw', 'jquery'], function(CW, $) {
        CW.toInit(function () {
            var idPageMessage = "#editor-messages";
            // for confluence 5.10 use #all-messages
            if($("#editor-messages").length <= 0){ 
                idPageMessage = "#all-messages";
            }
            // available at CONF 5.2
            var blueprintKey = $('meta[name=ajs-blueprint-module-complete-key]').attr("content");
            var urlParams = "";

            // only show workflow-instructions when creating the page
            // when creating, pageId is always 0
            if (CW.getParam('pageId') == "0") {
                if (! blueprintKey || blueprintKey.length === 0) {
                    // CONF 5.3+ compatibility
                    // creating page with predefined labels
                    if($('#createPageLabelsString').val().length) {
                        urlParams = "?label="+$('#createPageLabelsString').val();
                    }
                }else{
                    urlParams = "?blueprintKey=" + blueprintKey;
                }
                
                var url = CW.contextPath + "/rest/adhocworkflows/latest/workflow/" + CW.getParam('spaceKey') + "/instructions/create"+urlParams;
                CW.request({
                    url: url,
                    type: "get",
                    cache: false,
                    contentType: "application/json; charset=utf-8",
                    success: function(instructions, textStatus, jqXHR) {
                        if (instructions) {
                            setTimeout(function() {
                                var msg = {
                                    title: instructions.title ? instructions.title : "",
                                    body: instructions.body,
                                    closeable: true
                                };
                                CW.message(instructions.style, idPageMessage, msg);
                            },500);
                        }
                    }
                });
            }
        });
    });
})();