/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.storage;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.ListResourceBundle;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import org.randombits.storage.BasedStorage;
import org.randombits.storage.StringBasedStorage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceStorage
extends StringBasedStorage {
    private ResourceBundle resourceBundle;
    private Set<String> keySet;

    private ResourceStorage() {
        super(BasedStorage.BoxType.Virtual);
    }

    public ResourceStorage(ResourceBundle resourceBundle) {
        this();
        this.resourceBundle = resourceBundle;
    }

    public ResourceStorage(String name) {
        this(name, Locale.getDefault());
    }

    public ResourceStorage(String name, Locale locale) {
        this(name, locale, ResourceStorage.class.getClassLoader());
    }

    public ResourceStorage(String name, Locale locale, ClassLoader classLoader) {
        this();
        this.resourceBundle = this.findResourceBundle(name, locale, classLoader);
    }

    public ResourceStorage(Class<?> type) {
        this(type, Locale.getDefault());
    }

    public ResourceStorage(Class<?> type, Locale locale) {
        this(type.getName(), locale, type.getClassLoader());
    }

    protected ResourceBundle findResourceBundle(String name, Locale locale, ClassLoader classLoader) {
        try {
            return ResourceBundle.getBundle(name, locale, classLoader);
        }
        catch (MissingResourceException e) {
            return new ListResourceBundle(){

                protected Object[][] getContents() {
                    return new Object[0][];
                }
            };
        }
    }

    public ResourceBundle getBundle() {
        return this.resourceBundle;
    }

    @Override
    protected Set<String> baseNameSet() {
        if (this.resourceBundle != null && this.keySet == null) {
            this.keySet = new HashSet<String>();
            Enumeration<String> keys = this.resourceBundle.getKeys();
            while (keys.hasMoreElements()) {
                this.keySet.add(keys.nextElement());
            }
        }
        return this.keySet;
    }

    @Override
    protected String getBaseString(String name) {
        try {
            if (this.resourceBundle != null) {
                return this.resourceBundle.getString(name);
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return null;
    }

    public String getMessage(String name, String def, Object[] arguments) {
        String value = this.getString(name, def);
        if (value != null && arguments != null && arguments.length > 0) {
            value = MessageFormat.format(value, arguments);
        }
        return value;
    }

    public String getMessage(String name, Object[] arguments) {
        return this.getMessage(name, name, arguments);
    }

    public String getMessage(String name, Collection<?> arguments) {
        return this.getMessage(name, name, arguments);
    }

    public String getMessage(String name, String def, Collection<?> arguments) {
        Object[] args = null;
        if (arguments != null) {
            args = new Object[arguments.size()];
            int i = 0;
            for (Object arg : arguments) {
                args[i++] = arg;
            }
        }
        return this.getMessage(name, def, args);
    }

    public String getMessage(String name) {
        return this.getMessage(name, name, (Object[])null);
    }

    @Override
    protected void setBaseString(String name, String value) {
        this.checkReadOnly();
    }

    @Override
    public final boolean isReadOnly() {
        return true;
    }
}

