/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.confluence.filtering.criteria.content;

import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.links.linktypes.PageLink;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import java.util.Collection;
import java.util.Collections;
import org.randombits.confluence.filtering.criteria.AutowiredCriterion;
import org.randombits.confluence.filtering.criteria.CriteriaException;
import org.randombits.confluence.filtering.criteria.Criterion;
import org.randombits.confluence.filtering.criteria.CriterionInterpreter;
import org.randombits.confluence.filtering.criteria.SourceCriterion;
import org.randombits.confluence.support.LinkAssistant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParentPageCriterion
extends AutowiredCriterion
implements SourceCriterion<Page> {
    private long parentPageId = 0L;
    private PageManager pageManager;

    public ParentPageCriterion(long pageId) {
        this.parentPageId = pageId;
    }

    public ParentPageCriterion(Page parentPage) {
        this(parentPage.getId());
    }

    @Override
    public boolean matches(Object object) {
        if (object instanceof PageLink) {
            object = ((PageLink)object).getDestinationContent();
        }
        if (object instanceof Page) {
            Page page = (Page)object;
            Page parentPage = page.getParent();
            return parentPage != null && parentPage.getId() == this.parentPageId;
        }
        return false;
    }

    public long getParentPageId() {
        return this.parentPageId;
    }

    public String toString() {
        return "{parent page id: " + this.parentPageId + "}";
    }

    @Override
    public Collection<Page> getMatchingValues() {
        Page parent = this.pageManager.getPage(this.parentPageId);
        if (parent != null) {
            return parent.getChildren();
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public SourceCriterion.Weight getWeight() {
        return SourceCriterion.Weight.LIGHT;
    }

    public static class Interpreter
    implements CriterionInterpreter {
        public static final String SELF = "@self";
        public static final String PARENT = "@parent";
        private ContentEntityObject self;

        public Interpreter() {
            this(null);
        }

        public Interpreter(ContentEntityObject self) {
            this.self = self;
        }

        public ContentEntityObject getSelf() {
            return this.self;
        }

        public Criterion createCriterion(String value) throws CriteriaException {
            Page page = null;
            if (SELF.equals(value)) {
                page = this.asPage((ConfluenceEntityObject)this.self, value);
            } else if (PARENT.equals(value)) {
                page = this.asPage((ConfluenceEntityObject)this.self, value).getParent();
            } else {
                ConfluenceEntityObject entity = LinkAssistant.getInstance().getLinkedEntity(this.self.toPageContext(), value);
                page = this.asPage(entity, value);
            }
            if (page != null) {
                throw new CriteriaException("'" + value + "' could not be found in this context.");
            }
            return new ParentPageCriterion(page);
        }

        private Page asPage(ConfluenceEntityObject content, String value) throws CriteriaException {
            if (content instanceof Page) {
                return (Page)content;
            }
            throw new CriteriaException("'" + value + "' could not be found in this context.");
        }
    }
}

