/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.service;

import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.model.search.SearchOptions;
import com.atlassian.confluence.api.model.search.SearchPageResponse;
import com.atlassian.confluence.api.model.search.SearchResult;
import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.atlassian.confluence.rest.api.model.ExpansionsParser;
import com.comalatech.confluence.workflow.documentReport.DocumentReportService;
import com.comalatech.confluence.workflow.restv2.model.documentreport.DocumentReport;
import com.comalatech.confluence.workflowreports.model.presenter.cql.CqlFilterParameter;
import com.comalatech.confluence.workflowreports.service.ApprovalDocumentReportService;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ApprovalDocumentReportServiceImpl
implements ApprovalDocumentReportService {
    public static final String BASIC_CQL_PARAMETER = CqlFilterParameter.HAS_WORKFLOW.getCqlField() + " = true AND " + CqlFilterParameter.HAS_APPROVAL.getCqlField() + " = true ";
    private static final List<String> EXPAND = Arrays.asList("content.metadata.properties.comalaworkflows", "content.history.lastUpdated", "content.metadata.properties.comalaworkflowspendingapprovers", "content.metadata.properties.comalaworkflowsfinishedapprovers", "content.metadata.properties.comalaworkflowslastfinalversionapprovers", "content.metadata.properties.comalaworflowscurrentmodelversion", "content.metadata.properties.comalaworkflowsapprovals", "content.space");
    private final CQLSearchService cqlSearchService;
    private final DocumentReportService documentReportService;

    public ApprovalDocumentReportServiceImpl(CQLSearchService cqlSearchService, DocumentReportService documentReportService) {
        this.cqlSearchService = cqlSearchService;
        this.documentReportService = documentReportService;
    }

    @Override
    public DocumentReport generateDocumentReport(String cql, int start, int limit) {
        String cqlSearch = BASIC_CQL_PARAMETER;
        if (StringUtils.isNotBlank((CharSequence)cql)) {
            cqlSearch = cqlSearch + "AND " + cql;
        }
        SearchPageResponse search = this.cqlSearchService.search(cqlSearch, SearchOptions.buildDefault(), (PageRequest)new SimplePageRequest(start, limit), ExpansionsParser.parse((String)StringUtils.join(EXPAND, (String)",")));
        DocumentReport documentReport = this.documentReportService.buildDocumentReportModelFromCqlResponse((SearchPageResponse<SearchResult>)search);
        this.filterCQLReportData(documentReport, cqlSearch);
        return documentReport;
    }

    private void filterCQLReportData(DocumentReport documentReport, String cqlSearch) {
        if (documentReport.getWorkflowsReportList().isEmpty()) {
            return;
        }
        boolean hasReviewFilter = cqlSearch.contains(CqlFilterParameter.PENDING_APPROVAL_NAME.getCqlField()) || cqlSearch.contains(CqlFilterParameter.APPROVED_APPROVAL_NAME.getCqlField()) || cqlSearch.contains(CqlFilterParameter.REJECTED_APPROVAL_NAME.getCqlField());
        boolean hasAssigneeFilter = cqlSearch.contains(CqlFilterParameter.PENDING_APPROVAL_USER_NAME.getCqlField());
        if (!hasReviewFilter && !hasAssigneeFilter) {
            return;
        }
        documentReport.getWorkflowsReportList().forEach(workflowsReportData -> workflowsReportData.getApprovals().removeIf(userApprovalContent -> hasReviewFilter && !cqlSearch.contains(userApprovalContent.name) && !cqlSearch.contains(userApprovalContent.status) || hasAssigneeFilter && userApprovalContent.pendingApprovers.stream().noneMatch(pendingApprover -> cqlSearch.contains(pendingApprover.userKeyProperty)) && userApprovalContent.completed.stream().noneMatch(completedApprover -> cqlSearch.contains(completedApprover.user.userKeyProperty))));
    }
}

