/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.resources;

import com.comalatech.confluence.workflowreports.service.ApprovalDocumentReportService;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/document/report")
@Produces(value={"application/json"})
public class ApprovalReportResource {
    private static final Logger log = LoggerFactory.getLogger(ApprovalReportResource.class);
    private final ApprovalDocumentReportService approvalDocumentReportService;

    public ApprovalReportResource(ApprovalDocumentReportService approvalDocumentReportService) {
        this.approvalDocumentReportService = approvalDocumentReportService;
    }

    @Path(value="/approvals")
    @Produces(value={"application/json"})
    @GET
    public Response search(@QueryParam(value="cql") String cql, @QueryParam(value="start") int start, @QueryParam(value="limit") int limit) {
        try {
            return Response.ok((Object)this.approvalDocumentReportService.generateDocumentReport(cql, start, limit)).build();
        }
        catch (Exception e) {
            log.error("Unable to retrieve data for approval report CQL: {} , start: {} ,limit: {} ", new Object[]{cql, start, limit, e});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
    }
}

