/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.model.presenter;

import com.comalatech.confluence.workflowreports.model.WorkflowStatesReportFilters;
import com.comalatech.confluence.workflowreports.model.presenter.MacroParametersPresenter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowStateReportFiltersJsonPresenter
implements MacroParametersPresenter {
    private static final Logger log = LoggerFactory.getLogger(WorkflowStateReportFiltersJsonPresenter.class);
    public static final String STATE_FILTER_KEY = "reportStateFilter";
    public static final String WORKFLOW_FILTER_KEY = "reportWorkflowFilter";
    private final WorkflowStatesReportFilters filters;
    private final ObjectMapper objectMapper;

    public WorkflowStateReportFiltersJsonPresenter(WorkflowStatesReportFilters filters, ObjectMapper objectMapper) {
        this.filters = filters;
        this.objectMapper = objectMapper;
    }

    @Override
    public Map<String, Object> present() {
        HashMap<String, Object> propertiesMap = new HashMap<String, Object>();
        propertiesMap.put(STATE_FILTER_KEY, this.toJson(this.filters.getStateNames()));
        propertiesMap.put(WORKFLOW_FILTER_KEY, this.toJson(this.filters.getSpaceWorkflows()));
        return propertiesMap;
    }

    private String toJson(Object parameter) {
        if (parameter != null) {
            try {
                return this.objectMapper.writeValueAsString(parameter);
            }
            catch (IOException e) {
                log.error(e.getMessage());
            }
        }
        return "";
    }
}

