/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.macro.parameter.model;

import com.comalatech.confluence.workflowreports.macro.parameter.StringReportParameterValue;
import com.comalatech.confluence.workflowreports.macro.parameter.model.ReportParameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public enum ApprovalsReportParameters {
    SPACE("space", "@self"),
    ITEMS_PER_PAGE("maxItems", "20"),
    COLUMNS_TO_SHOW("columns", "title,approval,state,approvers,pending approvers,last page update,status"),
    ASSIGNEE("assignee"),
    PARENT_PAGE("parent"),
    LABEL("label"),
    APPROVAL_NAME("approvalName"),
    APPROVAL_STATUS("approvalStatus", "Any"),
    STATE("state"),
    WORKFLOW("workflow"),
    CQL_FILTER("cqlFilter");

    final String key;
    String defaultValue;

    private ApprovalsReportParameters(String key) {
        this.key = key;
    }

    private ApprovalsReportParameters(String key, String defaultValue) {
        this.key = key;
        this.defaultValue = defaultValue;
    }

    public static Optional<ApprovalsReportParameters> fromString(String text) {
        return Arrays.stream(ApprovalsReportParameters.values()).filter(reportFilter -> reportFilter.key.equalsIgnoreCase(text)).findFirst();
    }

    public static List<ReportParameter> getFiltersFrom(Set<Map.Entry> macroParameterSet) {
        ArrayList<ReportParameter> approvalsReportFilters = new ArrayList<ReportParameter>();
        for (Map.Entry macroParam : macroParameterSet) {
            Optional<ApprovalsReportParameters> filter = ApprovalsReportParameters.fromString(macroParam.getKey().toString());
            if (!filter.isPresent()) continue;
            String value = macroParam.getValue() == null ? null : macroParam.getValue().toString().trim();
            approvalsReportFilters.add(new ReportParameter(filter.get().key, new StringReportParameterValue(value, filter.get().defaultValue)));
        }
        ApprovalsReportParameters.addMandatoryParameters(approvalsReportFilters);
        return approvalsReportFilters;
    }

    private static void addMandatoryParameters(List<ReportParameter> approvalsReportFilters) {
        boolean existAssignee;
        boolean existColumns;
        boolean existApprovalStatus;
        boolean existItemsPerPage;
        boolean existSpaceParam = approvalsReportFilters.stream().anyMatch(param -> param.getKey().equals(SPACE.getKey()));
        if (!existSpaceParam) {
            approvalsReportFilters.add(new ReportParameter(ApprovalsReportParameters.SPACE.key, new StringReportParameterValue(null, ApprovalsReportParameters.SPACE.defaultValue)));
        }
        if (!(existItemsPerPage = approvalsReportFilters.stream().anyMatch(param -> param.getKey().equals(ITEMS_PER_PAGE.getKey())))) {
            approvalsReportFilters.add(new ReportParameter(ApprovalsReportParameters.ITEMS_PER_PAGE.key, new StringReportParameterValue(null, ApprovalsReportParameters.ITEMS_PER_PAGE.defaultValue)));
        }
        if (!(existApprovalStatus = approvalsReportFilters.stream().anyMatch(param -> param.getKey().equals(APPROVAL_STATUS.getKey())))) {
            approvalsReportFilters.add(new ReportParameter(ApprovalsReportParameters.APPROVAL_STATUS.key, new StringReportParameterValue(null, ApprovalsReportParameters.APPROVAL_STATUS.defaultValue)));
        }
        if (!(existColumns = approvalsReportFilters.stream().anyMatch(param -> param.getKey().equals(COLUMNS_TO_SHOW.getKey())))) {
            approvalsReportFilters.add(new ReportParameter(ApprovalsReportParameters.COLUMNS_TO_SHOW.key, new StringReportParameterValue(null, ApprovalsReportParameters.COLUMNS_TO_SHOW.defaultValue)));
        }
        if (!(existAssignee = approvalsReportFilters.stream().anyMatch(param -> param.getKey().equals(ASSIGNEE.getKey())))) {
            approvalsReportFilters.add(new ReportParameter(ApprovalsReportParameters.ASSIGNEE.key, new StringReportParameterValue(null, ApprovalsReportParameters.ASSIGNEE.defaultValue)));
        }
    }

    public String getKey() {
        return this.key;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }
}

