/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.macro;

import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.macro.MacroException;
import com.comalatech.confluence.workflow.restv2.model.report.RestSpaceReportFilterWorkflow;
import com.comalatech.confluence.workflowreports.macro.BaseWorkflowReportMacro;
import com.comalatech.confluence.workflowreports.macro.parameter.ApprovalsMacroParameters;
import com.comalatech.confluence.workflowreports.model.WorkflowApprovalsReportFilters;
import com.comalatech.confluence.workflowreports.model.WorkflowApprovalsReportFiltersJsonPresenter;
import com.comalatech.confluence.workflowreports.model.WorkflowApprovalsReportOptions;
import com.comalatech.confluence.workflowreports.model.presenter.WorkflowApprovalsReportOptionsCqlPresenter;
import com.comalatech.workflow.model.Workflow;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class WorkflowApprovalsReportMacro
extends BaseWorkflowReportMacro {
    private static final String APPROVALS_TEMPLATE = "/templates/reports/macros/approvals-report-macro.vm";
    protected ApprovalsMacroParameters options;

    @Override
    public String execute(Map parameters, RenderContext renderContext) throws MacroException {
        this.options = new ApprovalsMacroParameters(parameters, renderContext, this.workflowsFeatureManager, this.userAccessor, this.pageManager);
        WorkflowApprovalsReportOptions approvalsReportOptions = this.options.getWorkflowApprovalsReportOptions();
        WorkflowApprovalsReportFilters approvalsReportFilters = this.buildReportFilters();
        Map contextMap = MacroUtils.defaultVelocityContext();
        contextMap.putAll(new WorkflowApprovalsReportOptionsCqlPresenter(approvalsReportOptions, this.objectMapper).present());
        contextMap.putAll(new WorkflowApprovalsReportFiltersJsonPresenter(approvalsReportFilters, this.objectMapper).present());
        contextMap.put("currentSpaceKey", this.getCurrentSpaceKey(renderContext));
        contextMap.put("workflowLicenseMessageHtml", this.getWorkflowLicenseMessageHtml());
        return this.renderTemplate(contextMap, APPROVALS_TEMPLATE);
    }

    private WorkflowApprovalsReportFilters buildReportFilters() {
        List<String> states = this.getReportApprovalsFilter();
        List<RestSpaceReportFilterWorkflow> workflows = this.getReportWorkflowFilter();
        return new WorkflowApprovalsReportFilters(states, workflows);
    }

    protected List<String> getReportApprovalsFilter() {
        ArrayList<String> spaceStates = new ArrayList<String>();
        if (this.options.getWorkflowApprovalsReportOptions().isSingleSpace()) {
            spaceStates.addAll(this.approvalsSearchService.getSpaceStates(this.options.getWorkflowApprovalsReportOptions().getFirstSpaceKey()));
        }
        return spaceStates;
    }

    protected List<RestSpaceReportFilterWorkflow> getReportWorkflowFilter() {
        ArrayList<RestSpaceReportFilterWorkflow> restWorkflows = new ArrayList<RestSpaceReportFilterWorkflow>();
        if (this.workflowsFeatureManager.isWorkflowsApp() || this.workflowsFeatureManager.isWorkflowsLiteApp()) {
            ArrayList<Workflow> workflows = new ArrayList<Workflow>();
            if (this.options.getWorkflowApprovalsReportOptions().isSingleSpace()) {
                workflows.addAll(this.workflowService.getWorkflows(this.options.getWorkflowApprovalsReportOptions().getFirstSpaceKey()));
            }
            for (Workflow workflow : workflows) {
                if (!workflow.isActive()) continue;
                RestSpaceReportFilterWorkflow restWorkflow = new RestSpaceReportFilterWorkflow();
                restWorkflow.name = workflow.getName();
                restWorkflow.states = workflow.getStateNames();
                restWorkflows.add(restWorkflow);
            }
        }
        return restWorkflows;
    }
}

