/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.action;

import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.pages.actions.AbstractPaginatedListAction;
import com.atlassian.confluence.spaces.actions.SpaceAware;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.renderer.RendererConfiguration;
import com.atlassian.user.User;
import com.comalatech.confluence.workflow.WorkflowConfigurationManager;
import com.comalatech.confluence.workflow.service.ApprovalsSearchService;
import com.comalatech.confluence.workflowcontainer.model.WorkflowVisibilityInternal;
import com.comalatech.confluence.workflowreports.WorkflowReportManager;
import com.comalatech.confluence.workflowreports.model.WorkflowReport;
import com.comalatech.confluence.workflowreports.model.WorkflowReportOptions;
import com.comalatech.confluence.workflowreports.model.WorkflowReportSortEnum;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class WorkflowReportAction
extends AbstractPaginatedListAction
implements SpaceAware {
    private WorkflowReport workflowReport;
    private String state;
    private String approval;
    private String assignee;
    private String filter;
    private String workflowId;
    private String type;
    private String sort;
    private String order;
    private RendererConfiguration rendererConfiguration;
    private WorkflowReportManager workflowReportManager;
    private ApprovalsSearchService approvalsSearchService;
    private WorkflowConfigurationManager workflowConfigurationManager;
    private AccessModeService accessModeService;

    public WorkflowReportAction() {
    }

    public WorkflowReportAction(int itemsPerPage) {
        super(itemsPerPage);
    }

    public List getItems() {
        this.workflowReport = this.workflowReportManager.createReport(this.getOptions(), this.getPaginationSupport());
        this.workflowReport.setUrl(this.rendererConfiguration.getWebAppContextPath() + "/spaces/" + this.getActionName() + ".action?key=" + this.space.getKey());
        return this.getPaginationSupport().getItems();
    }

    public String getActionName() {
        return "workflowreport";
    }

    protected WorkflowReportOptions getOptions() {
        WorkflowReportOptions options = new WorkflowReportOptions(this.space.getKey(), null, this.getSort(), 20);
        options.setStateNames(this.getState());
        options.setAssignee(this.getAssignee());
        options.setApprovalFilter(this.getFilter(), this.getApproval());
        options.setStatesActionReport(true);
        if (!StringUtils.isNotBlank((CharSequence)this.getState())) {
            List<String> list = this.approvalsSearchService.getSpaceStates(options.getSpaceKey());
        }
        return options;
    }

    public String getType() {
        return this.type;
    }

    private WorkflowReportSortEnum getSort() {
        return WorkflowReportSortEnum.makeSort(this.sort, this.order);
    }

    public String getState() {
        return this.state;
    }

    public String getApproval() {
        return this.approval;
    }

    public String getFilter() {
        return this.filter;
    }

    public String getWorkflowId() {
        return this.workflowId;
    }

    public String getAssignee() {
        return this.assignee;
    }

    public void setAssignee(String assignee) {
        this.assignee = assignee;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public void setOrder(String order) {
        this.order = order;
    }

    public boolean isPermitted() {
        boolean superIsPermitted = super.isPermitted();
        return (Boolean)this.accessModeService.withReadOnlyAccessExemption(() -> {
            WorkflowVisibilityInternal visibility = this.workflowConfigurationManager.getHistoryVisibility(this.getSpaceKey());
            if (WorkflowVisibilityInternal.CONTRIBUTORS.equals((Object)visibility)) {
                return superIsPermitted && this.spacePermissionManager.hasPermission("EDITSPACE", this.space, (User)AuthenticatedUserThreadLocal.get());
            }
            if (WorkflowVisibilityInternal.ANY.equals((Object)visibility)) {
                return superIsPermitted && this.spacePermissionManager.hasPermission("VIEWSPACE", this.space, (User)AuthenticatedUserThreadLocal.get());
            }
            return superIsPermitted;
        });
    }

    public boolean isSpaceRequired() {
        return true;
    }

    public boolean isViewPermissionRequired() {
        return true;
    }

    public boolean isSpaceAdmin() {
        return this.spacePermissionManager.hasPermission("SETSPACEPERMISSIONS", this.space, (User)this.getAuthenticatedUser()) || this.permissionManager.isConfluenceAdministrator((User)this.getAuthenticatedUser());
    }

    public WorkflowReport getWorkflowReport() {
        return this.workflowReport;
    }

    public void setState(String state) {
        this.state = state;
    }

    public void setApproval(String approval) {
        this.approval = approval;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public void setWorkflowId(String workflowId) {
        this.workflowId = workflowId;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setWorkflowReportManager(WorkflowReportManager workflowReportManager) {
        this.workflowReportManager = workflowReportManager;
    }

    public void setRendererConfiguration(RendererConfiguration rendererConfiguration) {
        this.rendererConfiguration = rendererConfiguration;
    }

    public void setWorkflowConfigurationManager(WorkflowConfigurationManager workflowConfigurationManager) {
        this.workflowConfigurationManager = workflowConfigurationManager;
    }

    public void setAccessModeService(AccessModeService accessModeService) {
        this.accessModeService = accessModeService;
    }

    public void setApprovalsSearchService(ApprovalsSearchService approvalsSearchService) {
        this.approvalsSearchService = approvalsSearchService;
    }
}

