/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports;

import bucket.core.actions.PaginationSupport;
import com.atlassian.confluence.core.persistence.AnyTypeDao;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.search.v2.ISearch;
import com.atlassian.confluence.search.v2.InvalidSearchException;
import com.atlassian.confluence.search.v2.SearchManager;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.SearchResult;
import com.atlassian.confluence.search.v2.SearchResults;
import com.atlassian.confluence.search.v2.query.BooleanQuery;
import com.atlassian.confluence.search.v2.query.TextFieldQuery;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.plugin.PluginController;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.comalatech.confluence.workflow.Constants;
import com.comalatech.confluence.workflowreports.AbstractWorkflowReportCreator;
import com.comalatech.confluence.workflowreports.WorkflowReportCreator;
import com.comalatech.confluence.workflowreports.model.TasksReportFilter;
import com.comalatech.confluence.workflowreports.model.WorkflowReport;
import com.comalatech.confluence.workflowreports.model.WorkflowReportEntry;
import com.comalatech.confluence.workflowreports.model.WorkflowReportOptions;
import com.comalatech.confluence.workflowreports.search.ApprovalAssigneeQuery;
import com.comalatech.confluence.workflowreports.search.AssigneeQuery;
import com.comalatech.confluence.workflowreports.search.PageStateQuery;
import com.comalatech.confluence.workflowreports.search.TaskAssigneeQuery;
import com.comalatech.confluence.workflowreports.search.TasksStatusQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwoPointNineWorkflowReportCreator
extends AbstractWorkflowReportCreator
implements WorkflowReportCreator {
    private static final Logger log = LoggerFactory.getLogger(TwoPointNineWorkflowReportCreator.class);
    private final PluginController pluginController;
    private final DarkFeatureManager darkFeatureManager;

    public TwoPointNineWorkflowReportCreator(SearchManager searchManager, AnyTypeDao anyTypeDao, PluginController pluginController, DarkFeatureManager darkFeatureManager) {
        super(searchManager, anyTypeDao);
        this.pluginController = pluginController;
        this.darkFeatureManager = darkFeatureManager;
    }

    @Override
    public List<WorkflowReportEntry> createStatesReport(WorkflowReportOptions options, PaginationSupport paginationSupport, WorkflowReportCreator.EntryCreator entryCreator) {
        Collection<SearchQuery> queries = this.makeDefaultQueries(options);
        this.appendStateQuery(options, queries);
        if (StringUtils.isNotBlank((CharSequence)options.getAssignee())) {
            queries.add(new AssigneeQuery(options.getAssignee()));
        }
        BooleanQuery query = new BooleanQuery(queries, null, null);
        return this.makeEntries(options, paginationSupport, entryCreator, (SearchQuery)query);
    }

    @Override
    public List<WorkflowReportEntry> createDashboardReport(WorkflowReportOptions options, PaginationSupport paginationSupport, WorkflowReportCreator.EntryCreator entryCreator) {
        BooleanQuery approvalStatusBoolean;
        Collection<SearchQuery> queries = this.makeDefaultQueries(options);
        String assignee = options.getAssignee();
        if (assignee == null && (assignee = options.getUserName()) == null) {
            assignee = AuthenticatedUserThreadLocal.getUsername();
        }
        if (assignee == null) {
            return Collections.emptyList();
        }
        if (log.isDebugEnabled()) {
            log.debug("Creating dashboard report for user " + assignee);
        }
        HashSet<Object> tasksQuery = new HashSet<Object>();
        tasksQuery.add(new TasksStatusQuery(TasksReportFilter.ACTIVE_TASKS));
        tasksQuery.add(new TaskAssigneeQuery(assignee));
        BooleanQuery tasksBoolean = new BooleanQuery(tasksQuery, null, null);
        HashSet<ApprovalAssigneeQuery> approvalAssigneeQuery = new HashSet<ApprovalAssigneeQuery>();
        approvalAssigneeQuery.add(new ApprovalAssigneeQuery(assignee));
        BooleanQuery approvalAssigneeBoolean = new BooleanQuery(approvalAssigneeQuery, null, null);
        TextFieldQuery partial = this.makeFieldQuery("partial", "[* TO *]");
        TextFieldQuery pending = this.makeFieldQuery("pending", "[* TO *]");
        if (this.darkFeatureManager.isEnabledForAllUsers("comalatech.workflows.dashboard.report.pending.approvals").orElse(false).booleanValue()) {
            HashSet<TextFieldQuery> partialOrPendingQuery = new HashSet<TextFieldQuery>();
            partialOrPendingQuery.add(partial);
            partialOrPendingQuery.add(pending);
            approvalStatusBoolean = new BooleanQuery(null, partialOrPendingQuery, null);
        } else {
            HashSet<BooleanQuery> partialXorPendingQuery = new HashSet<BooleanQuery>();
            HashSet<TextFieldQuery> partialQuery = new HashSet<TextFieldQuery>();
            partialQuery.add(partial);
            HashSet<TextFieldQuery> pendingQuery = new HashSet<TextFieldQuery>();
            pendingQuery.add(pending);
            BooleanQuery partialAndNotPending = new BooleanQuery(partialQuery, null, pendingQuery);
            BooleanQuery pendingAndNotPartial = new BooleanQuery(pendingQuery, null, partialQuery);
            partialXorPendingQuery.add(partialAndNotPending);
            partialXorPendingQuery.add(pendingAndNotPartial);
            approvalStatusBoolean = new BooleanQuery(null, partialXorPendingQuery, null);
        }
        HashSet<BooleanQuery> approvalsQuery = new HashSet<BooleanQuery>();
        approvalsQuery.add(approvalAssigneeBoolean);
        approvalsQuery.add(approvalStatusBoolean);
        BooleanQuery approvalsBoolean = new BooleanQuery(approvalsQuery, null, null);
        HashSet<BooleanQuery> tasksOrApprovals = new HashSet<BooleanQuery>();
        tasksOrApprovals.add(tasksBoolean);
        tasksOrApprovals.add(approvalsBoolean);
        queries.add((SearchQuery)new BooleanQuery(null, tasksOrApprovals, null));
        BooleanQuery query = new BooleanQuery(queries, null, null);
        return this.makeEntries(options, paginationSupport, entryCreator, (SearchQuery)query);
    }

    @Override
    public List<WorkflowReportEntry> createTasksReport(WorkflowReportOptions options, PaginationSupport paginationSupport, WorkflowReportCreator.EntryCreator entryCreator) {
        Collection<SearchQuery> queries = this.makeDefaultQueries(options);
        queries.add(new TasksStatusQuery(options.getTasksFilter()));
        if (options.getAssignee() != null) {
            queries.add(new TaskAssigneeQuery(options.getAssignee()));
        }
        if (options.getStateNames() != null && !options.getStateNames().isEmpty()) {
            HashSet<PageStateQuery> statesQuery = new HashSet<PageStateQuery>();
            for (String state : options.getStateNames()) {
                statesQuery.add(new PageStateQuery(state.toLowerCase().replace("_", " ")));
            }
            queries.add((SearchQuery)new BooleanQuery(null, statesQuery, null));
        }
        BooleanQuery query = new BooleanQuery(queries, null, null);
        return this.makeEntries(options, paginationSupport, entryCreator, (SearchQuery)query);
    }

    @Override
    public WorkflowReport createWorkflowStats(WorkflowReportOptions options) {
        WorkflowReport report = new WorkflowReport(options);
        for (String stateName : options.getStateNames()) {
            Collection<SearchQuery> queries = this.makeDefaultQueries(options);
            queries.add(new PageStateQuery(stateName.toLowerCase().replace("_", " ")));
            BooleanQuery query = new BooleanQuery(queries, null, null);
            try {
                ISearch search = this.createSearchObject(options, new PaginationSupport(2), (SearchQuery)query);
                SearchResults results = this.searchManager.search(search);
                report.addStateCount(stateName, results.getUnfilteredResultsCount());
            }
            catch (InvalidSearchException invalidSearchException) {}
        }
        return report;
    }

    private List<WorkflowReportEntry> makeEntries(WorkflowReportOptions options, PaginationSupport paginationSupport, WorkflowReportCreator.EntryCreator entryCreator, SearchQuery query) {
        ArrayList<WorkflowReportEntry> entries;
        block13: {
            entries = new ArrayList<WorkflowReportEntry>();
            ISearch search = this.createSearchObject(options, paginationSupport, query);
            try {
                int count;
                SearchResults results = this.searchManager.search(search);
                int initialCount = count = results.getUnfilteredResultsCount();
                int entriesCount = 0;
                int pageSize = paginationSupport.getPageSize();
                int searchPage = paginationSupport.getStartIndex() / pageSize + 1;
                int totalSearchPages = (count - 1) / pageSize + 1;
                if (log.isDebugEnabled()) {
                    log.debug("makeEntries() -> Retrieving entries from index:" + paginationSupport.getStartIndex() + ", pageSize:" + paginationSupport.getPageSize() + ", results: " + results.getAll().size() + ", total results:" + results.getUnfilteredResultsCount());
                }
                for (int i = 0; i < totalSearchPages; ++i) {
                    for (SearchResult searchResult : results.getAll()) {
                        AbstractPage abstractPage = (AbstractPage)this.anyTypeDao.findByHandle(searchResult.getHandle());
                        if (abstractPage == null || !abstractPage.isLatestVersion() || abstractPage.isDeleted()) {
                            if (log.isDebugEnabled()) {
                                log.debug("makeEntries() ->  entry discarded:" + searchResult.getHandle());
                            }
                            --count;
                        } else {
                            List<WorkflowReportEntry> workflowReportEntries = entryCreator.makeEntries(abstractPage);
                            if (workflowReportEntries == null || workflowReportEntries.isEmpty()) {
                                --count;
                                if (log.isDebugEnabled()) {
                                    log.debug("makeEntries() -> procesing page: " + abstractPage.getTitle() + ", NO resulting entries");
                                }
                            } else {
                                if (log.isDebugEnabled()) {
                                    log.debug("makeEntries() -> procesing page: " + abstractPage.getTitle() + ", resulting entries:" + workflowReportEntries.size());
                                }
                                entries.addAll(workflowReportEntries);
                                entriesCount += workflowReportEntries.size();
                            }
                        }
                        if (entriesCount != pageSize) continue;
                        break;
                    }
                    if (pageSize <= entriesCount || searchPage >= totalSearchPages) break;
                    paginationSupport.setStartIndex(entriesCount);
                    search = this.createSearchObject(options, paginationSupport, query);
                    results = this.searchManager.search(search);
                }
                if (log.isDebugEnabled()) {
                    log.debug("makeEntries() -> resulting entries-> unfilteredResultsCount:" + initialCount + " ResultsAfterFiltering:" + count + " TotalEntries:" + entriesCount);
                }
                paginationSupport.setTotal(count);
            }
            catch (InvalidSearchException e) {
                log.error("Invalid search, may be related to mapped query error (APRV-392/CONF-22014)");
                this.reloadQueryMapperModules();
                if (!log.isDebugEnabled()) break block13;
                log.error("", (Throwable)e);
            }
        }
        return entries;
    }

    @Override
    public List<WorkflowReportEntry> createApprovalsReport(WorkflowReportOptions options, PaginationSupport paginationSupport, WorkflowReportCreator.EntryCreator entryCreator) {
        Collection<SearchQuery> queries = this.makeDefaultQueries(options);
        if (options.getApproverName() != null) {
            queries.add(new ApprovalAssigneeQuery(options.getApproverName()));
        }
        if (options.getUserName() != null) {
            HashSet<ApprovalAssigneeQuery> userApprovalAssigneeQuery = new HashSet<ApprovalAssigneeQuery>();
            userApprovalAssigneeQuery.add(new ApprovalAssigneeQuery(options.getUserName()));
            BooleanQuery userApprovalAssigneeBooleanQuery = new BooleanQuery(userApprovalAssigneeQuery, null, null);
            HashSet<TextFieldQuery> nullApprovalAssignee = new HashSet<TextFieldQuery>();
            nullApprovalAssignee.add(this.makeFieldQuery("approvalAssignee", "[* TO *]"));
            BooleanQuery nullApprovalAssigneeBooleanQuery = new BooleanQuery(null, null, nullApprovalAssignee);
            HashSet<BooleanQuery> userFilterQuery = new HashSet<BooleanQuery>();
            userFilterQuery.add(userApprovalAssigneeBooleanQuery);
            userFilterQuery.add(nullApprovalAssigneeBooleanQuery);
            queries.add((SearchQuery)new BooleanQuery(null, userFilterQuery, null));
        }
        String[] approvalNames = StringUtils.split((String)options.getApprovalName(), (String)",");
        BooleanQuery approvalIds = new String[approvalNames.length];
        for (int i = 0; i < approvalNames.length; ++i) {
            approvalIds[i] = Constants.makeId(approvalNames[i].trim());
        }
        HashSet<TextFieldQuery> approvals = new HashSet<TextFieldQuery>();
        for (String approvalId : approvalIds) {
            if ("pending".equalsIgnoreCase(options.getApprovalFilter())) {
                approvals.add(this.makeFieldQuery("pending", approvalId));
                approvals.add(this.makeFieldQuery("outdated", approvalId));
                approvals.add(this.makeFieldQuery("partial", approvalId));
                continue;
            }
            approvals.add(this.makeFieldQuery(options.getApprovalFilter(), approvalId));
        }
        queries.add((SearchQuery)new BooleanQuery(null, approvals, null));
        BooleanQuery query = new BooleanQuery(queries, null, null);
        return this.makeEntries(options, paginationSupport, entryCreator, (SearchQuery)query);
    }

    private void reloadQueryMapperModules() {
        this.reloadPluginModule("pagestate");
    }

    private void reloadPluginModule(String key) {
        String fullKey = "reloading com.comalatech.workflow:" + key;
        try {
            log.warn("reloading " + fullKey);
            this.pluginController.disablePluginModule(fullKey);
            this.pluginController.enablePluginModule(fullKey);
        }
        catch (Exception e) {
            log.error("error reloading " + fullKey, (Throwable)e);
        }
    }
}

