/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowcontainer.remote;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.util.http.HttpRequest;
import com.atlassian.confluence.util.http.HttpResponse;
import com.atlassian.confluence.util.http.HttpRetrievalService;
import com.atlassian.upm.api.license.entity.LicenseType;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import com.comalatech.confluence.license.AdhocWorkflowsLicenseManager;
import com.comalatech.confluence.workflow.ApprovalCheckDecorator;
import com.comalatech.confluence.workflow.WorkflowConfigurationManager;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflowcontainer.model.RemoteWorkflowsRepository;
import com.comalatech.confluence.workflowcontainer.remote.RemoteRepositoryConverter;
import com.comalatech.confluence.workflowcontainer.remote.RemoteRepositoryProxy;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Date;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DefaultRemoteRepositoryProxy
implements RemoteRepositoryProxy {
    private static final Logger log = LoggerFactory.getLogger(DefaultRemoteRepositoryProxy.class);
    private static final String REFRESH_KEY = "com.comalatech.workflow.repository.refresh";
    private static final ConfluenceBandanaContext CONTEXT = new ConfluenceBandanaContext();
    private static final long TTL = 14400000L;
    private static final String REPOSITORY_URL = "http://exchange.adhocworkflows.com/plugins/servlet/workflowsrepository";
    private RemoteWorkflowsRepository repository;
    private final BandanaManager bandanaManager;
    private final HttpRetrievalService httpRetrievalService;
    private final WorkflowConfigurationManager workflowConfigurationManager;
    private final ApprovalCheckDecorator approvalCheckDecorator;
    private final AdhocWorkflowsLicenseManager licenseManager;
    private final ComalaI18nBean comalaI18nBean;

    public DefaultRemoteRepositoryProxy(BandanaManager bandanaManager, HttpRetrievalService httpRetrievalService, WorkflowConfigurationManager workflowConfigurationManager, ApprovalCheckDecorator approvalCheckDecorator, @Qualifier(value="adhocWorkflowsLicenseManager") AdhocWorkflowsLicenseManager licenseManager, ComalaI18nBean comalaI18nBean) {
        this.bandanaManager = bandanaManager;
        this.httpRetrievalService = httpRetrievalService;
        this.workflowConfigurationManager = workflowConfigurationManager;
        this.approvalCheckDecorator = approvalCheckDecorator;
        this.licenseManager = licenseManager;
        this.comalaI18nBean = comalaI18nBean;
    }

    @Override
    public RemoteWorkflowsRepository getRemoteRepository(boolean forceLoad) {
        if (!forceLoad && this.repository != null && System.currentTimeMillis() <= this.getRefreshTime()) {
            return (RemoteWorkflowsRepository)this.repository.clone();
        }
        this.resetRefreshTime();
        this.loadRepository();
        if (this.repository == null) {
            this.repository = new RemoteWorkflowsRepository(new Date(), false);
        }
        return (RemoteWorkflowsRepository)this.repository.clone();
    }

    private void loadRepository() {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(this.readContent(this.getRepositoryUrl()));
            this.repository = this.parse(is);
            this.repository.setStatus(this.comalaI18nBean.getText("com.comalatech.workflow.repository.status.ok", new Object[]{this.approvalCheckDecorator.decorateDateTimePretty(this.repository.getDate()), this.approvalCheckDecorator.decorateDateTimePretty(new Date())}));
        }
        catch (WorkflowException e) {
            log.error("Could not be possible " + e.getMessage());
            this.repository = new RemoteWorkflowsRepository(null, false);
            this.repository.setStatus(this.comalaI18nBean.getText("com.comalatech.workflow.repository.status.error", new Object[]{REPOSITORY_URL}));
        }
    }

    private String getRepositoryUrl() {
        LicenseType licenseType = this.licenseManager.getLicenseType();
        StringBuilder sb = new StringBuilder(REPOSITORY_URL);
        sb.append("?version=").append(this.workflowConfigurationManager.getConfiguration().getPluginVersionNumber());
        if (licenseType == LicenseType.COMMERCIAL || licenseType == LicenseType.ACADEMIC) {
            if (licenseType == LicenseType.STARTER) {
                sb.append("&starter=true");
            }
        } else if (this.workflowConfigurationManager.getConfiguration().getConfluenceUsers() <= 10) {
            sb.append("&trial=true&starter=true");
        } else {
            sb.append("&trial=true");
        }
        return sb.toString();
    }

    private byte[] readContent(String url) throws WorkflowException {
        HttpResponse response = null;
        HttpRequest httpRequest = this.httpRetrievalService.getDefaultRequestFor(url);
        try {
            response = this.httpRetrievalService.get(httpRequest);
            if (response.isNotFound()) {
                throw new WorkflowException("not found: " + url);
            }
            if (response.isNotPermitted()) {
                throw new WorkflowException("not permitted: " + url);
            }
            if (response.isFailed()) {
                throw new WorkflowException("Error accessing " + url + ": " + response.getStatusMessage());
            }
            byte[] byArray = this.readResponse(response);
            return byArray;
        }
        catch (IOException e) {
            throw new WorkflowException(e.getMessage());
        }
        finally {
            if (null != response) {
                response.finish();
            }
        }
    }

    private byte[] readResponse(HttpResponse response) throws IOException {
        int read;
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        InputStream in = response.getResponse();
        byte[] bytes = new byte[1024];
        while ((read = in.read(bytes)) != -1) {
            bytesOut.write(bytes, 0, read);
        }
        return bytesOut.toByteArray();
    }

    public void resetRefreshTime() {
        this.setValue(REFRESH_KEY, Long.toString(System.currentTimeMillis() + 14400000L));
    }

    public long getRefreshTime() {
        String value = this.getValue(REFRESH_KEY);
        try {
            return Long.parseLong(value);
        }
        catch (Exception e) {
            return 0L;
        }
    }

    private String getValue(String key) {
        return (String)this.bandanaManager.getValue((BandanaContext)CONTEXT, key);
    }

    private void setValue(String key, String value) {
        this.bandanaManager.setValue((BandanaContext)CONTEXT, key, (Object)value);
    }

    public RemoteWorkflowsRepository parse(String schema) throws WorkflowException {
        try {
            RemoteRepositoryConverter converter = new RemoteRepositoryConverter();
            SAXParser parser = this.getParser();
            parser.parse(new InputSource(new StringReader(schema)), (DefaultHandler)converter);
            return converter.getRepository();
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug(schema);
            }
            throw new WorkflowException("Parsing error: " + e.getMessage());
        }
    }

    private RemoteWorkflowsRepository parse(InputStream is) throws WorkflowException {
        try {
            RemoteRepositoryConverter converter = new RemoteRepositoryConverter();
            SAXParser parser = this.getParser();
            parser.parse(is, (DefaultHandler)converter);
            return converter.getRepository();
        }
        catch (Exception e) {
            throw new WorkflowException("Parsing error: " + e.getMessage());
        }
    }

    private SAXParser getParser() throws SAXException, ParserConfigurationException {
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        saxParserFactory.setValidating(false);
        saxParserFactory.setNamespaceAware(false);
        return saxParserFactory.newSAXParser();
    }
}

