/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowcontainer.action;

import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessBlocked;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.actions.AbstractSpaceAction;
import com.atlassian.confluence.spaces.actions.SpaceAware;
import com.atlassian.confluence.velocity.htmlsafe.HtmlSafe;
import com.atlassian.core.util.PairType;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.user.User;
import com.atlassian.xwork.ParameterSafe;
import com.comalatech.confluence.license.AdhocWorkflowsLicenseManager;
import com.comalatech.confluence.workflow.WorkflowConfigurationManager;
import com.comalatech.confluence.workflow.events.admin.SpaceWorkflowConfigurationUpdatedEventImpl;
import com.comalatech.confluence.workflowcontainer.model.WorkflowVisibilityInternal;
import com.comalatech.workflow.model.MacroTransformStatus;
import com.comalatech.workflow.model.PageUpdateResetApprovalStatus;
import com.comalatech.workflow.model.TasksMode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Qualifier;

public class SpaceConfigurationAction
extends AbstractSpaceAction
implements SpaceAware {
    protected WorkflowConfigurationManager workflowConfigurationManager;
    protected EventPublisher eventPublisher;
    private AdhocWorkflowsLicenseManager licenseManager;
    private DarkFeatureManager darkFeatureManager;
    protected boolean draftView;
    protected String tasksMode;
    private String licenseStatusMessage;
    protected String workflowVisibility;
    protected String macroTransformEnable;
    protected String resetApproval;

    public String execute() throws Exception {
        this.draftView = this.workflowConfigurationManager.isViewDraftByDefault(this.getSpace());
        this.resetApproval = this.workflowConfigurationManager.getResetApprovalStatus(this.getSpaceKey(), false).toString();
        this.licenseStatusMessage = this.licenseManager.getLicenseStatus().getMessageHtml();
        return "success";
    }

    @ReadOnlyAccessBlocked
    public String updateSpaceConfiguration() {
        Map<String, String> newConfig;
        Map<String, String> existingConfig = this.createConfigMap();
        this.workflowConfigurationManager.setViewDraftByDefault(this.getSpace(), this.draftView);
        this.workflowConfigurationManager.setTasksMode(this.getSpaceKey(), TasksMode.valueOf(this.tasksMode));
        this.workflowConfigurationManager.setHistoryVisibility(this.getSpaceKey(), WorkflowVisibilityInternal.parse(this.workflowVisibility));
        this.workflowConfigurationManager.setResetApprovalStatus(this.getSpaceKey(), PageUpdateResetApprovalStatus.valueOf(this.resetApproval));
        if (StringUtils.isNotBlank((CharSequence)this.macroTransformEnable)) {
            this.workflowConfigurationManager.setMacroTransformEnable(this.getSpaceKey(), MacroTransformStatus.valueOf(this.macroTransformEnable));
        }
        if (!existingConfig.equals(newConfig = this.createConfigMap())) {
            SpaceWorkflowConfigurationUpdatedEventImpl configEvent = new SpaceWorkflowConfigurationUpdatedEventImpl(this.getSpace(), existingConfig, newConfig);
            this.eventPublisher.publish((Object)configEvent);
        }
        return "success";
    }

    protected Map<String, String> createConfigMap() {
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("draftView", Boolean.valueOf(this.workflowConfigurationManager.isViewDraftByDefault(this.getSpace())).toString());
        configMap.put("taskMode", this.workflowConfigurationManager.getTasksMode(this.getSpaceKey(), false).toString());
        configMap.put("workflowVisibility", this.workflowConfigurationManager.getHistoryVisibility(this.getSpaceKey(), false).toString());
        configMap.put("includeMacroTransform", this.workflowConfigurationManager.getMacroTransformEnable(this.getSpaceKey(), false).toString());
        configMap.put("approvalReset", this.workflowConfigurationManager.getResetApprovalStatus(this.getSpaceKey(), false).toString());
        return configMap;
    }

    public boolean isDraftView() {
        return this.draftView;
    }

    private boolean isConfluenceAdministrator() {
        return this.permissionManager.hasPermission((User)this.getAuthenticatedUser(), Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION);
    }

    public boolean isPermitted() {
        return super.isPermitted() && (this.isConfluenceAdministrator() || this.permissionManager.hasPermission((User)this.getAuthenticatedUser(), Permission.ADMINISTER, (Object)this.getSpace()));
    }

    public boolean isViewPermissionRequired() {
        return true;
    }

    public boolean isSpaceRequired() {
        return true;
    }

    public void setWorkflowConfigurationManager(WorkflowConfigurationManager workflowConfigurationManager) {
        this.workflowConfigurationManager = workflowConfigurationManager;
    }

    public List<TasksMode> getTasksModes() {
        return Arrays.asList(TasksMode.values());
    }

    public List<WorkflowVisibilityInternal> getWorkflowVisibilities() {
        return Arrays.asList(WorkflowVisibilityInternal.values());
    }

    public TasksMode getCurrentTasksMode() {
        return this.workflowConfigurationManager.getTasksMode(this.getSpaceKey(), false);
    }

    public TasksMode getGlobalTasksMode() {
        return this.workflowConfigurationManager.getTasksMode(null, false);
    }

    public WorkflowVisibilityInternal getCurrentWorkflowVisibility() {
        return this.workflowConfigurationManager.getHistoryVisibility(this.getSpaceKey(), false);
    }

    public WorkflowVisibilityInternal getGlobalWorkflowVisibility() {
        return this.workflowConfigurationManager.getHistoryVisibility();
    }

    @HtmlSafe
    public String getLicenseStatusMessage() {
        return this.licenseStatusMessage;
    }

    public void setLicenseManager(@Qualifier(value="adhocWorkflowsLicenseManager") AdhocWorkflowsLicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    public String getMacroTransformEnable() {
        return this.workflowConfigurationManager.getMacroTransformEnable(this.getSpaceKey(), false).toString();
    }

    public List getMacroTransformEnableList() {
        ArrayList<PairType> transformOptions = new ArrayList<PairType>();
        String globalDefault = this.getText("comalatech.awp.space.settings.macrotransform." + this.workflowConfigurationManager.getMacroTransformEnable().toString());
        String defaultL18n = this.getText("comalatech.awp.space.settings.macrotransform.DEFAULT", new String[]{globalDefault});
        transformOptions.add(new PairType((Serializable)((Object)MacroTransformStatus.DEFAULT.toString()), (Serializable)((Object)defaultL18n)));
        transformOptions.add(new PairType((Serializable)((Object)MacroTransformStatus.DISABLED.toString()), (Serializable)((Object)this.getText("comalatech.awp.space.settings.macrotransform.DISABLED"))));
        transformOptions.add(new PairType((Serializable)((Object)MacroTransformStatus.ENABLED.toString()), (Serializable)((Object)this.getText("comalatech.awp.space.settings.macrotransform.ENABLED"))));
        return transformOptions;
    }

    public List getResetApprovalList() {
        ArrayList<PairType> options = new ArrayList<PairType>();
        String globalDefault = this.getText("comalatech.awp.space.settings.resetapproval." + this.workflowConfigurationManager.getResetApprovalStatus().toString());
        String defaultL18n = this.getText("comalatech.awp.space.settings.resetapproval.DEFAULT", new String[]{globalDefault});
        options.add(new PairType((Serializable)((Object)PageUpdateResetApprovalStatus.DEFAULT.toString()), (Serializable)((Object)defaultL18n)));
        options.add(new PairType((Serializable)((Object)PageUpdateResetApprovalStatus.RESET.toString()), (Serializable)((Object)this.getText("comalatech.awp.space.settings.resetapproval.RESET"))));
        options.add(new PairType((Serializable)((Object)PageUpdateResetApprovalStatus.IGNORE.toString()), (Serializable)((Object)this.getText("comalatech.awp.space.settings.resetapproval.IGNORE"))));
        return options;
    }

    public void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public String getResetApproval() {
        return this.resetApproval;
    }

    public DarkFeatureManager getDarkFeatureManager() {
        return this.darkFeatureManager;
    }

    public void setDarkFeatureManager(DarkFeatureManager darkFeatureManager) {
        this.darkFeatureManager = darkFeatureManager;
    }

    @ParameterSafe
    public void setResetApproval(String resetApproval) {
        this.resetApproval = resetApproval;
    }

    @ParameterSafe
    public void setTasksMode(String tasksMode) {
        this.tasksMode = tasksMode;
    }

    @ParameterSafe
    public void setWorkflowVisibility(String workflowVisibility) {
        this.workflowVisibility = workflowVisibility;
    }

    @ParameterSafe
    public void setMacroTransformEnable(String macroTransformEnable) {
        this.macroTransformEnable = macroTransformEnable;
    }

    @ParameterSafe
    public void setDraftView(boolean draftView) {
        this.draftView = draftView;
    }
}

