/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.template;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.user.User;
import com.comalatech.confluence.license.AdhocWorkflowsLicenseManager;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.workflow.WorkflowConfigurationManager;
import com.comalatech.workflow.StateService;
import com.comalatech.workflow.WorkflowService;
import com.comalatech.workflow.model.State;
import com.comalatech.workflow.model.Workflow;
import java.util.List;
import org.springframework.beans.factory.annotation.Qualifier;

public class WorkflowsVelocityContextItem {
    private final PageManager pageManager;
    private final PermissionManager permissionManager;
    private final AdhocWorkflowsLicenseManager licenseManager;
    private final WorkflowService workflowService;
    private final StateService stateService;
    private final WorkflowsFeatureManager workflowsFeatureManager;
    private final WorkflowConfigurationManager workflowConfigurationManager;
    private String supportUrl = "https://apps.appf.re/cdmdc/support/g9PHJ2";

    public WorkflowsVelocityContextItem(PageManager pageManager, PermissionManager permissionManager, @Qualifier(value="adhocWorkflowsLicenseManager") AdhocWorkflowsLicenseManager licenseManager, WorkflowService workflowService, StateService stateService, WorkflowsFeatureManager workflowsFeatureManager, WorkflowConfigurationManager workflowConfigurationManager) {
        this.pageManager = pageManager;
        this.permissionManager = permissionManager;
        this.licenseManager = licenseManager;
        this.workflowService = workflowService;
        this.stateService = stateService;
        this.workflowsFeatureManager = workflowsFeatureManager;
        this.workflowConfigurationManager = workflowConfigurationManager;
    }

    public State stateForPage(Long pageId, boolean publishedOnly) {
        AbstractPage page = this.pageManager.getAbstractPage(pageId.longValue());
        if (page != null && this.canView(page) && this.licenseManager.isLicensed()) {
            return publishedOnly ? this.stateService.getPublishedState((ContentEntityObject)page) : this.stateService.getCurrentState((ContentEntityObject)page);
        }
        return null;
    }

    public String getPluginKey() {
        return this.workflowsFeatureManager.getPluginKey();
    }

    public State stateForPage(Long pageId) {
        return this.stateForPage(pageId, false);
    }

    public State stateForPage(String pageId, boolean publishedOnly) {
        return this.stateForPage(Long.parseLong(pageId), publishedOnly);
    }

    public State stateForPage(String pageId) {
        return this.stateForPage(Long.parseLong(pageId));
    }

    public Workflow workflowForPage(Long pageId) {
        AbstractPage page = this.pageManager.getAbstractPage(pageId.longValue());
        if (page != null && this.canView(page) && this.licenseManager.isLicensed()) {
            return this.workflowService.getWorkflow((ContentEntityObject)page);
        }
        return null;
    }

    public Workflow workflowForPage(String pageId) {
        return this.workflowForPage(Long.parseLong(pageId));
    }

    public List<Workflow> activeWorkflowsForPage(Long pageId) {
        AbstractPage page = this.pageManager.getAbstractPage(pageId.longValue());
        if (page != null && this.canView(page) && this.licenseManager.isLicensed()) {
            return this.workflowService.getActiveWorkflows((ContentEntityObject)page);
        }
        return null;
    }

    public List<Workflow> activeWorkflowsForPage(String pageId) {
        return this.activeWorkflowsForPage(Long.parseLong(pageId));
    }

    private boolean canView(AbstractPage page) {
        return this.permissionManager.hasPermission((User)AuthenticatedUserThreadLocal.get(), Permission.VIEW, (Object)page);
    }

    public WorkflowsFeatureManager getFeatureManager() {
        return this.workflowsFeatureManager;
    }

    public WorkflowConfigurationManager getConfigurationManager() {
        return this.workflowConfigurationManager;
    }

    public String getSupportUrl() {
        return this.supportUrl;
    }
}

