/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.supportconsole.mappers;

import com.atlassian.confluence.pages.AbstractPage;
import com.comalatech.confluence.documentActivity.service.DocumentActivityService;
import com.comalatech.confluence.documentActivity.service.model.DocumentActivityQueryScope;
import com.comalatech.confluence.documentActivity.service.model.DocumentActivityResult;
import com.comalatech.confluence.documentActivity.service.model.InternalDocumentActivityQuery;
import com.comalatech.confluence.documentActivity.service.model.InternalDocumentActivityQueryFilter;
import com.comalatech.confluence.workflow.supportconsole.mappers.contract.SupportConsoleReportDataPopulator;
import com.comalatech.confluence.workflow.supportconsole.model.DocumentActivityData;
import com.comalatech.confluence.workflowreports.model.ActivityReportOptions;
import com.comalatech.confluence.workflowreports.pageactivity.DocActivityCsvServiceImpl;
import com.comalatech.confluence.workflowreports.pageactivity.PageActivityCsvConfig;

public class DocumentActivityDataPopulator
implements SupportConsoleReportDataPopulator<DocumentActivityData, AbstractPage> {
    private final DocActivityCsvServiceImpl docActivityCsvService;
    private final DocumentActivityService documentActivityService;

    public DocumentActivityDataPopulator(DocActivityCsvServiceImpl docActivityCsvService, DocumentActivityService documentActivityService) {
        this.docActivityCsvService = docActivityCsvService;
        this.documentActivityService = documentActivityService;
    }

    @Override
    public DocumentActivityData populateForTarget(AbstractPage page) {
        InternalDocumentActivityQuery query = new InternalDocumentActivityQuery();
        InternalDocumentActivityQueryFilter filter = new InternalDocumentActivityQueryFilter();
        filter.setScope(DocumentActivityQueryScope.createScopePage(page.getId()));
        query.setFilters(filter);
        DocumentActivityResult result = this.documentActivityService.get(query);
        return DocumentActivityData.builder().activityReport(this.docActivityCsvService.getPageActivityFileContent(result.getActivities(), page, PageActivityCsvConfig.builder().skipOtherVersion(false).build())).build();
    }

    private ActivityReportOptions getOptions() {
        ActivityReportOptions options = new ActivityReportOptions();
        options.setAscending(false);
        options.setHideComments(false);
        options.setHideTasks(false);
        options.setHideEdits(false);
        options.setHideStates(false);
        options.setPublishView(false);
        return options;
    }
}

