/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.restv2.model.mappers.documentreport;

import com.atlassian.confluence.user.UserAccessor;
import com.comalatech.confluence.dataextractor.model.ApprovalContentPropertyModel;
import com.comalatech.confluence.dataextractor.model.UserContentPropertyModel;
import com.comalatech.confluence.workflow.documentReport.UsersContentPropertiesKeys;
import com.comalatech.confluence.workflow.restv2.model.documentreport.UserApprovalContent;
import com.comalatech.confluence.workflow.restv2.model.documentreport.WorkflowsReportData;
import com.comalatech.confluence.workflow.restv2.model.mappers.documentreport.DocumentReportJsonPropertyMapper;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserApprovalsMapper
implements DocumentReportJsonPropertyMapper {
    private static final Logger log = LoggerFactory.getLogger(UserApprovalsMapper.class);
    private static final String KEY = "comalaworkflowsapprovals";
    private final UserAccessor userAccessor;
    private static final ObjectMapper mapper = new ObjectMapper();

    public UserApprovalsMapper(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    @Override
    public WorkflowsReportData map(String key, String json, WorkflowsReportData result) {
        if (result == null) {
            result = new WorkflowsReportData();
        }
        if (KEY.equalsIgnoreCase(key)) {
            UsersContentPropertiesKeys usersContentPropertiesKeys = UsersContentPropertiesKeys.COMALA_WORKFLOWS_PENDING_APPROVERS;
            try {
                ApprovalContentPropertyModel[] approvalContentPropertyModels;
                for (ApprovalContentPropertyModel storedModel : approvalContentPropertyModels = (ApprovalContentPropertyModel[])mapper.readValue(json, ApprovalContentPropertyModel[].class)) {
                    UserApprovalContent userApprovalContent = new UserApprovalContent();
                    userApprovalContent.name = storedModel.name;
                    userApprovalContent.status = storedModel.status;
                    userApprovalContent.pendingApprovers = this.mapPendingApprovers(storedModel.pendingApprovers.getUserKeyList(), usersContentPropertiesKeys);
                    userApprovalContent.completed = this.mapCompletedContentPropertyModel(storedModel, usersContentPropertiesKeys);
                    result.getApprovals().add(userApprovalContent);
                }
            }
            catch (Exception e) {
                log.warn("Cannot map {}  to object : {}  ", new Object[]{KEY, json, e});
            }
        }
        return result;
    }

    private List<UserContentPropertyModel> mapPendingApprovers(Set<String> userKeys, UsersContentPropertiesKeys dataEnum) {
        ArrayList<String> keys = new ArrayList<String>(userKeys);
        return dataEnum.getUserData(keys, this.userAccessor);
    }

    private List<UserApprovalContent.CompletedContentPropertyModel> mapCompletedContentPropertyModel(ApprovalContentPropertyModel approvalContentPropertyModel, UsersContentPropertiesKeys dataEnum) {
        ArrayList<UserApprovalContent.CompletedContentPropertyModel> result = new ArrayList<UserApprovalContent.CompletedContentPropertyModel>();
        for (ApprovalContentPropertyModel.CompletedContentPropertyModel currentCompletedModel : approvalContentPropertyModel.completed) {
            UserApprovalContent.CompletedContentPropertyModel mappedResult = new UserApprovalContent.CompletedContentPropertyModel();
            mappedResult.action = currentCompletedModel.action;
            mappedResult.date = currentCompletedModel.date;
            mappedResult.user = dataEnum.getUserDataFromKey(currentCompletedModel.getUser(), this.userAccessor);
            if (!Objects.nonNull(mappedResult.user)) continue;
            this.filterUserApprovals(result, mappedResult);
        }
        return result;
    }

    private void filterUserApprovals(List<UserApprovalContent.CompletedContentPropertyModel> result, UserApprovalContent.CompletedContentPropertyModel mappedResult) {
        Instant findDate;
        UserApprovalContent.CompletedContentPropertyModel completedContentPropertyModel = result.stream().filter(contentPropertyModel -> contentPropertyModel.user.userKeyProperty.equals(mappedResult.user.userKeyProperty)).findFirst().orElse(null);
        if (Objects.isNull(completedContentPropertyModel)) {
            result.add(mappedResult);
            return;
        }
        Instant mappedDate = Instant.ofEpochSecond(Long.parseLong(mappedResult.date));
        if (mappedDate.isAfter(findDate = Instant.ofEpochSecond(Long.parseLong(completedContentPropertyModel.date)))) {
            result.remove(completedContentPropertyModel);
            result.add(mappedResult);
        }
    }

    static {
        mapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(DeserializationConfig.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
    }
}

