/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.restv2.model.mappers;

import com.comalatech.confluence.workflow.model.WorkflowParameter;
import com.comalatech.confluence.workflow.restv2.model.RestParameter;
import com.comalatech.confluence.workflow.restv2.model.mappers.Mapper;
import com.comalatech.workflow.model.WorkflowParameterType;
import org.apache.commons.lang3.StringUtils;

public class ParameterMapper
implements Mapper<com.comalatech.workflow.model.WorkflowParameter, RestParameter> {
    @Override
    public RestParameter toRest(com.comalatech.workflow.model.WorkflowParameter parameter) {
        RestParameter.Type type;
        switch (parameter.getType()) {
            case STRING: {
                type = RestParameter.Type.STRING;
                break;
            }
            case USER: {
                type = RestParameter.Type.USER;
                break;
            }
            case GROUP: {
                type = RestParameter.Type.GROUP;
                break;
            }
            case USERORGROUP: {
                type = RestParameter.Type.USERORGROUP;
                break;
            }
            case DURATION: {
                type = RestParameter.Type.DURATION;
                break;
            }
            case LIST: {
                type = RestParameter.Type.OPTIONS;
                break;
            }
            default: {
                type = RestParameter.Type.DEFAULT;
            }
        }
        String options = StringUtils.join(parameter.getOptions(), (String)",");
        return new RestParameter(parameter.getName(), type, parameter.getDescription(), StringUtils.isNotBlank((CharSequence)options) ? options : null, parameter.isPageEditable(), parameter.getValue());
    }

    @Override
    public com.comalatech.workflow.model.WorkflowParameter fromRest(RestParameter parameter) {
        WorkflowParameterType type;
        switch (RestParameter.Type.fromString(parameter.type.toString())) {
            case STRING: {
                type = WorkflowParameterType.STRING;
                break;
            }
            case USER: {
                type = WorkflowParameterType.USER;
                break;
            }
            case GROUP: {
                type = WorkflowParameterType.GROUP;
                break;
            }
            case USERORGROUP: {
                type = WorkflowParameterType.USERORGROUP;
                break;
            }
            case DURATION: {
                type = WorkflowParameterType.DURATION;
                break;
            }
            case OPTIONS: {
                type = WorkflowParameterType.LIST;
                break;
            }
            default: {
                type = WorkflowParameterType.STRING;
            }
        }
        return new WorkflowParameter(parameter.name, parameter.description, type, parameter.value, parameter.options != null ? parameter.options : "", parameter.editable != null ? parameter.editable : false);
    }
}

