/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.rest.resources;

import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.event.api.EventPublisher;
import com.comalatech.confluence.adhoc.dao.AdhocWorkflowDao;
import com.comalatech.confluence.adhocworkflows.rest.permissions.WorkflowsAppRequired;
import com.comalatech.confluence.ipc.api.DefaultWorkflowTemplateManager;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.workflow.DefaultWorkflowService;
import com.comalatech.confluence.workflow.Workflow;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.WorkflowService;
import com.comalatech.confluence.workflow.events.GlobalWorkflowLinkedToCategoryEvent;
import com.comalatech.confluence.workflow.rest.model.PermissionRequired;
import com.comalatech.confluence.workflow.rest.model.RestLabelsList;
import com.comalatech.confluence.workflow.rest.model.RestLongRunningTaskInfo;
import com.comalatech.confluence.workflow.rest.model.RestSpace;
import com.comalatech.confluence.workflow.rest.model.RestSpacesList;
import com.comalatech.confluence.workflow.rest.model.RestWorkflow;
import com.comalatech.confluence.workflow.rest.resources.AbstractAdminRestResource;
import com.comalatech.confluence.workflowcontainer.services.LinkWorkflowToSpaceCategoryService;
import com.comalatech.workflow.model.Workflow;
import com.comalatech.workflow.template.LinkedTemplateManager;
import com.comalatech.workflow.template.WorkflowTemplateManager;
import com.webcohesion.enunciate.metadata.rs.ResponseCode;
import com.webcohesion.enunciate.metadata.rs.StatusCodes;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;

@WorkflowsAppRequired
@Path(value="/admin/workflows")
@Produces(value={"application/json"})
public class WorkflowAdminResource
extends AbstractAdminRestResource {
    public static final String UPDATE_PARAM_LABELS = "labels";
    public static final String REMOVE_PARAM_LABEL = "label";
    public static final String LINK_PARAM_SPACEKEYS = "spaces";
    private final LinkedTemplateManager linkedTemplateManager;
    private final SettingsManager settingsManager;
    private final EventPublisher eventPublisher;
    private final LinkWorkflowToSpaceCategoryService linkWorkflowToSpaceCategoryService;
    private final WorkflowService workflowService;

    public WorkflowAdminResource(WorkflowService workflowService, PermissionManager permissionManager, SpaceManager spaceManager, WorkflowTemplateManager workflowTemplateManager, AdhocWorkflowDao adhocWorkflowDao, WorkflowsFeatureManager workflowsFeatureManager, PageManager pageManager, LinkedTemplateManager linkedTemplateManager, SettingsManager settingsManager, EventPublisher eventPublisher, LinkWorkflowToSpaceCategoryService linkWorkflowToSpaceCategoryService) {
        super(permissionManager, spaceManager, workflowTemplateManager, adhocWorkflowDao, workflowsFeatureManager, pageManager);
        this.linkedTemplateManager = linkedTemplateManager;
        this.settingsManager = settingsManager;
        this.linkWorkflowToSpaceCategoryService = linkWorkflowToSpaceCategoryService;
        this.eventPublisher = eventPublisher;
        this.workflowService = workflowService;
    }

    @GET
    @Path(value="{workflowId}")
    @PermissionRequired(value={"ADMINISTER"})
    public Response getWorkflow(final @PathParam(value="workflowId") String workflowId) {
        return new AbstractAdminRestResource.RestCommand(){

            @Override
            public Response doExecute() {
                try {
                    Workflow workflow = WorkflowAdminResource.this.workflowService.getWorkflow(null, workflowId);
                    if (workflow == null) {
                        return Response.noContent().build();
                    }
                    if (StringUtils.isNotBlank((CharSequence)workflow.getErrorMessage())) {
                        return Response.ok().entity((Object)WorkflowAdminResource.this.buildRestWorkflow(workflow, WorkflowAdminResource.this.workflowService.getGlobalWorkflowMarkup(workflowId))).build();
                    }
                    return Response.ok().entity((Object)WorkflowAdminResource.this.buildRestWorkflow(workflow)).build();
                }
                catch (WorkflowException e) {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)StringEscapeUtils.escapeHtml4((String)e.getMessage())).build();
                }
            }
        }.execute();
    }

    @GET
    @PermissionRequired(value={"ADMINISTER"})
    public Response getGlobalTemplates() {
        return new AbstractAdminRestResource.RestCommand(){

            @Override
            public Response doExecute() {
                return WorkflowAdminResource.this.buildGlobalTemplateRestWorkflowList();
            }
        }.execute();
    }

    @ReadOnlyAccessAllowed
    @POST
    @Path(value="{workflowHandle}/activate")
    @PermissionRequired(value={"ADMINISTER"})
    @Consumes(value={"application/json"})
    public Response activateGlobalTemplate(final @PathParam(value="workflowHandle") String workflowHandle) {
        return new AbstractAdminRestResource.RestCommand(){

            @Override
            public Response doExecute() {
                String workflowName = WorkflowAdminResource.this.workflowService.getNameFromHandle(null, workflowHandle);
                try {
                    WorkflowAdminResource.this.workflowTemplateManager.activateGlobalTemplate(workflowName);
                }
                catch (com.comalatech.workflow.WorkflowException e) {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)StringEscapeUtils.escapeHtml4((String)e.getMessage())).build();
                }
                return WorkflowAdminResource.this.buildGlobalTemplateRestWorkflowList();
            }
        }.execute();
    }

    @GET
    @Path(value="{workflowHandle}/spacesLinked")
    @PermissionRequired(value={"ADMINISTER"})
    @Consumes(value={"application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="OK"), @ResponseCode(code=204, condition="There are no linked spaces with this workflow"), @ResponseCode(code=404, condition="Workflow not found"), @ResponseCode(code=500, condition="Internal Server Error")})
    public Response findSpacesLinked(final @PathParam(value="workflowHandle") String workflowHandle) {
        return new AbstractAdminRestResource.RestCommand(){

            @Override
            public Response doExecute() {
                String workflowName = WorkflowAdminResource.this.workflowService.getNameFromHandle(null, workflowHandle);
                if (workflowName == null) {
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
                }
                List<Space> spaceList = WorkflowAdminResource.this.linkedTemplateManager.getLinkedSpacesList(workflowName);
                if (spaceList.isEmpty()) {
                    return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
                }
                return WorkflowAdminResource.this.buildRestSpaceList(spaceList);
            }
        }.execute();
    }

    @ReadOnlyAccessAllowed
    @POST
    @Path(value="{workflowHandle}/deactivate")
    @PermissionRequired(value={"ADMINISTER"})
    @Consumes(value={"application/json"})
    public Response deactivateGlobalTemplate(final @PathParam(value="workflowHandle") String workflowHandle) {
        return new AbstractAdminRestResource.RestCommand(){

            @Override
            public Response doExecute() {
                String workflowName = WorkflowAdminResource.this.workflowService.getNameFromHandle(null, workflowHandle);
                try {
                    WorkflowAdminResource.this.workflowTemplateManager.deactivateGlobalTemplate(workflowName);
                }
                catch (com.comalatech.workflow.WorkflowException e) {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)StringEscapeUtils.escapeHtml4((String)e.getMessage())).build();
                }
                return WorkflowAdminResource.this.buildGlobalTemplateRestWorkflowList();
            }
        }.execute();
    }

    @ReadOnlyAccessAllowed
    @POST
    @Path(value="{workflowHandle}/copy")
    @PermissionRequired(value={"ADMINISTER"})
    @Consumes(value={"application/json"})
    public Response copyWorkflow(final @PathParam(value="workflowHandle") String workflowHandle) {
        return new AbstractAdminRestResource.RestCommand(){

            @Override
            public Response doExecute() {
                String workflowName = WorkflowAdminResource.this.workflowService.getNameFromHandle(null, workflowHandle);
                WorkflowAdminResource.this.workflowTemplateManager.copyGlobalTemplate(workflowName);
                return WorkflowAdminResource.this.buildGlobalTemplateRestWorkflowList();
            }
        }.execute();
    }

    @ReadOnlyAccessAllowed
    @POST
    @PermissionRequired(value={"ADMINISTER"})
    @Consumes(value={"application/json"})
    public Response addWorkflow(final Map<String, String> updateJson) {
        return new AbstractAdminRestResource.RestCommand(){

            @Override
            public Response doExecute() {
                String markup = (String)updateJson.get("markup");
                if (StringUtils.isNotBlank((CharSequence)markup)) {
                    try {
                        WorkflowAdminResource.this.workflowTemplateManager.addWorkflowTemplate(null, markup);
                    }
                    catch (com.comalatech.workflow.WorkflowException e) {
                        return WorkflowAdminResource.this.handleException(e);
                    }
                }
                return WorkflowAdminResource.this.buildGlobalTemplateRestWorkflowList();
            }
        }.execute();
    }

    @ReadOnlyAccessAllowed
    @PUT
    @Path(value="{workflowHandle}")
    @PermissionRequired(value={"ADMINISTER"})
    @Consumes(value={"application/json"})
    public Response updateWorkflow(final @PathParam(value="workflowHandle") String workflowHandle, final Map<String, Object> updateJson) {
        return new AbstractAdminRestResource.RestCommand(){

            @Override
            public Response doExecute() {
                try {
                    String name = (String)updateJson.get("name");
                    String label = (String)updateJson.get(WorkflowAdminResource.REMOVE_PARAM_LABEL);
                    String description = (String)updateJson.get("description");
                    String markup = (String)updateJson.get("markup");
                    WorkflowAdminResource.this.workflowService.updateWorkflow(null, workflowHandle, name, description, label, markup, true);
                    return WorkflowAdminResource.this.buildGlobalTemplateRestWorkflowList();
                }
                catch (com.comalatech.workflow.WorkflowException e) {
                    String errorAsJson = WorkflowAdminResource.this.convertXHtmlToJson(e.getMessage());
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorAsJson).build();
                }
                catch (ClassCastException e) {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)StringEscapeUtils.escapeHtml4((String)e.getMessage())).build();
                }
            }
        }.execute();
    }

    @ReadOnlyAccessAllowed
    @DELETE
    @Path(value="{workflowHandle}")
    @PermissionRequired(value={"ADMINISTER"})
    @Consumes(value={"application/json"})
    public Response deleteWorkflow(final @PathParam(value="workflowHandle") String workflowHandle) {
        return new AbstractAdminRestResource.RestCommand(){

            @Override
            public Response doExecute() {
                String workflowName = WorkflowAdminResource.this.workflowService.getNameFromHandle(null, workflowHandle);
                if (workflowName != null) {
                    ((DefaultWorkflowTemplateManager)WorkflowAdminResource.this.workflowTemplateManager).removeGlobalWorkflowTemplate(workflowName);
                }
                return WorkflowAdminResource.this.buildGlobalTemplateRestWorkflowList();
            }
        }.execute();
    }

    @ReadOnlyAccessAllowed
    @POST
    @Path(value="{workflowHandle}/spaceLabels")
    @PermissionRequired(value={"ADMINISTER"})
    @Consumes(value={"application/json"})
    public Response addSpaceLabel(final @PathParam(value="workflowHandle") String workflowHandle, final Map<String, Object> labelsJsonMap) {
        return new AbstractAdminRestResource.RestCommand(){

            @Override
            public Response doExecute() {
                String workflowName = WorkflowAdminResource.this.workflowService.getNameFromHandle(null, workflowHandle);
                List<String> labels = WorkflowAdminResource.this.createLabelsListFromJson(labelsJsonMap);
                for (String label : labels) {
                    WorkflowAdminResource.this.linkedTemplateManager.addSpaceLabelLink(label, workflowName);
                }
                return WorkflowAdminResource.this.buildRestLabelList(workflowName);
            }
        }.execute();
    }

    @ReadOnlyAccessAllowed
    @PUT
    @Path(value="{workflowHandle}/spaceLabels")
    @PermissionRequired(value={"ADMINISTER"})
    @Consumes(value={"application/json"})
    public Response deleteSpaceLabel(final @PathParam(value="workflowHandle") String workflowHandle, final LinkedHashMap labelMap) {
        return new AbstractAdminRestResource.RestCommand(){

            @Override
            public Response doExecute() {
                String workflowName = WorkflowAdminResource.this.workflowService.getNameFromHandle(null, workflowHandle);
                String label = labelMap.get(WorkflowAdminResource.REMOVE_PARAM_LABEL).toString();
                WorkflowAdminResource.this.linkedTemplateManager.removeSpaceLabelLink(label, workflowName);
                return WorkflowAdminResource.this.buildRestLabelList(workflowName);
            }
        }.execute();
    }

    @ReadOnlyAccessAllowed
    @POST
    @Path(value="{workflowHandle}/linkWorkflowTask")
    @PermissionRequired(value={"ADMINISTER"})
    @Consumes(value={"application/json"})
    public Response linkWorkflowToSpacesTask(final @PathParam(value="workflowHandle") String workflowHandle, final Map<String, Object> spaceKeysJsonMap) {
        return new AbstractAdminRestResource.RestCommand(){

            @Override
            public Response doExecute() {
                List spaceKeys = WorkflowAdminResource.this.createSpaceKeysListFromJson(spaceKeysJsonMap);
                String taskId = WorkflowAdminResource.this.linkWorkflowToSpaceCategoryService.startSpacesLinkedToWorkflowTask(workflowHandle, spaceKeys).toString();
                WorkflowAdminResource.this.eventPublisher.publish((Object)new GlobalWorkflowLinkedToCategoryEvent());
                try {
                    return WorkflowAdminResource.this.buildRestCategoryLinkTaskRequestResponse(taskId);
                }
                catch (URISyntaxException e) {
                    return Response.serverError().build();
                }
            }
        }.execute();
    }

    @GET
    @Path(value="{workflowHandle}/spaceLabels/spaces/{category}")
    @PermissionRequired(value={"ADMINISTER"})
    @Consumes(value={"application/json"})
    public Response findSpaceLabel(final @PathParam(value="workflowHandle") String workflowHandle, final @PathParam(value="category") String category) {
        return new AbstractAdminRestResource.RestCommand(){

            @Override
            public Response doExecute() {
                String workflowName = WorkflowAdminResource.this.workflowService.getNameFromHandle(null, workflowHandle);
                if (workflowName == null) {
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
                }
                Label spaceCategoryLabel = WorkflowAdminResource.this.linkWorkflowToSpaceCategoryService.getSpaceCategoryLabel(category);
                if (spaceCategoryLabel == null) {
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
                }
                List<Space> spacesToBeLinked = WorkflowAdminResource.this.linkWorkflowToSpaceCategoryService.getSpacesToBeLinkedToAGlobalWorkflow(workflowHandle, spaceCategoryLabel);
                if (spacesToBeLinked.isEmpty()) {
                    return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
                }
                return WorkflowAdminResource.this.buildRestSpaceList(spacesToBeLinked);
            }
        }.execute();
    }

    protected Response buildRestCategoryLinkTaskRequestResponse(String taskId) throws URISyntaxException {
        URI createdLongRunningTask = new URI(this.settingsManager.getGlobalSettings().getBaseUrl() + "/longrunningtask.action?taskId=" + taskId);
        RestLongRunningTaskInfo longRunningTaskInfo = new RestLongRunningTaskInfo(createdLongRunningTask, taskId);
        return Response.ok().entity((Object)longRunningTaskInfo).build();
    }

    protected Response buildRestLabelList(String workflowName) {
        List<String> allLabels = this.linkedTemplateManager.getLinkedSpaceLabels(workflowName);
        RestLabelsList restLabels = new RestLabelsList();
        restLabels.setLabels(allLabels);
        return Response.ok().entity((Object)restLabels).build();
    }

    protected Response buildRestSpaceList(List<Space> spaces) {
        List<RestSpace> restSpaces = spaces.stream().map(space -> new RestSpace(space.getName(), space.getKey())).collect(Collectors.toList());
        RestSpacesList restSpacesList = new RestSpacesList();
        restSpacesList.setSpaces(restSpaces);
        return Response.ok().entity((Object)restSpacesList).build();
    }

    protected List<String> createLabelsListFromJson(Map<String, Object> labelsJsonMap) {
        Object labelsJson = labelsJsonMap.get(UPDATE_PARAM_LABELS);
        ArrayList<String> labels = new ArrayList<String>();
        if (labelsJson instanceof String) {
            labels.add((String)labelsJson);
        }
        if (labelsJson instanceof List) {
            labels.addAll((List)labelsJson);
        }
        return labels;
    }

    private List<String> createSpaceKeysListFromJson(Map<String, Object> spaceKeysJsonMap) {
        Object spaceKeysJson = spaceKeysJsonMap.get(LINK_PARAM_SPACEKEYS);
        ArrayList<String> spaceKeys = new ArrayList<String>();
        if (spaceKeysJson instanceof List) {
            spaceKeys.addAll((Collection)spaceKeysJson);
        }
        return spaceKeys;
    }

    private Response buildGlobalTemplateRestWorkflowList() {
        return this.buildGlobalTemplateRestWorkflowList(((DefaultWorkflowTemplateManager)this.workflowTemplateManager).getAllWorkflowTemplates());
    }

    private Response buildGlobalTemplateRestWorkflowList(List<Workflow> globalWorkflows) {
        if (globalWorkflows == null) {
            return Response.ok().entity((Object)Collections.EMPTY_LIST).build();
        }
        List restWorkflows = globalWorkflows.stream().map(w -> {
            String workflowHandle = DefaultWorkflowService.createHandle(Workflow.WorkflowType.GLOBALE_TEMPLATE, w);
            List<String> spaceLabelLinks = this.linkedTemplateManager.getLinkedSpaceLabels(w.getName());
            Integer numberLinkedSpaces = this.linkedTemplateManager.getLinkedSpaces(w.getName()).size();
            RestWorkflow restWorkflow = new RestWorkflow((Workflow)w);
            restWorkflow.global = true;
            restWorkflow.page = false;
            restWorkflow.handle = workflowHandle;
            restWorkflow.spaceLabelLinks = spaceLabelLinks;
            restWorkflow.numberLinkedSpaces = numberLinkedSpaces;
            if (StringUtils.isNotBlank((CharSequence)w.getErrorMessage())) {
                String body;
                restWorkflow.markup = body = this.adhocWorkflowDao.getWorkflowTemplateBody(null, w.getName());
                restWorkflow.errorMessage = w.getErrorMessage();
            } else {
                restWorkflow.markup = w.getWorkflowMarkup();
            }
            return restWorkflow;
        }).collect(Collectors.toList());
        return Response.ok().entity(restWorkflows).build();
    }
}

