/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.mywork.listener;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.util.WorkflowsListener;
import com.comalatech.confluence.workflow.mywork.AdhocInAppNotificationService;
import com.comalatech.confluence.workflow.mywork.notification.approval.ApprovalAssigneeNotification;
import com.comalatech.confluence.workflow.mywork.notification.approval.ApprovalUnassignNotification;
import com.comalatech.workflow.event.approval.ApprovalAssignedEvent;
import com.comalatech.workflow.event.approval.ApprovalUnassignedEvent;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;

public class ApprovalMyWorkNotificationListener
extends WorkflowsListener {
    protected final AdhocInAppNotificationService adhocInAppNotificationService;
    private WorkflowsFeatureManager workflowsFeatureManager;

    public ApprovalMyWorkNotificationListener(EventPublisher eventPublisher, AdhocInAppNotificationService adhocInAppNotificationService, WorkflowsFeatureManager workflowsFeatureManager) {
        super(eventPublisher);
        this.adhocInAppNotificationService = adhocInAppNotificationService;
        this.workflowsFeatureManager = workflowsFeatureManager;
    }

    @EventListener
    public void assignmentEvent(ApprovalAssignedEvent event) {
        ApprovalAssigneeNotification notification = new ApprovalAssigneeNotification(event, this.workflowsFeatureManager.getPluginKey());
        ArrayList<String> assignees = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)event.getAssignment().getAssignee())) {
            assignees.add(event.getAssignment().getAssignee());
        }
        this.adhocInAppNotificationService.sendNotification(notification, assignees);
    }

    @EventListener
    public void approvalUnassigned(ApprovalUnassignedEvent event) {
        ApprovalUnassignNotification notification = new ApprovalUnassignNotification(event, this.workflowsFeatureManager.getPluginKey());
        ArrayList<String> assignees = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)event.getAssignment().getAssignee())) {
            assignees.add(event.getAssignment().getAssignee());
        }
        this.adhocInAppNotificationService.sendNotification(notification, assignees);
    }
}

