/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.model;

import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.velocity.htmlsafe.HtmlSafe;
import com.atlassian.renderer.links.UrlLink;
import com.atlassian.user.Entity;
import com.comalatech.confluence.workflow.ApprovalCheckDecorator;
import com.comalatech.confluence.workflow.SelectorManager;
import com.comalatech.confluence.workflow.ValueStore;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.model.Approval;
import com.comalatech.confluence.workflow.model.ApprovalCheck;
import com.comalatech.confluence.workflow.model.ApprovalStatus;
import com.comalatech.confluence.workflow.model.Approver;
import com.comalatech.confluence.workflow.model.Selector;
import com.comalatech.workflow.model.ApprovalAction;
import com.comalatech.workflow.model.AssignedApprover;
import com.comalatech.workflow.model.Selectable;
import com.comalatech.workflow.model.SignatureType;
import com.comalatech.workflow.model.StateApproval;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecoratedApprovalCheck
implements Comparable,
ApprovalAction,
StateApproval {
    private static final Logger log = LoggerFactory.getLogger(DecoratedApprovalCheck.class);
    public static final int STATE_APPROVED = 0;
    public static final int STATE_REJECTED = 1;
    public static final int STATE_AVAILABLE_NEVERAPPROVED = 2;
    public static final int STATE_UNAVAILABLE = 3;
    public static final int STATE_PARTIALLY_APPROVED = 4;
    public static final int STATE_PARTIALLY_REJECTED = 5;
    private static String[] STATE_NAMES = new String[]{"approved", "rejected", "available", "unavailable", "partiallyapproved", "partiallyrejected"};
    private static final String CAN_APPROVE_CSS_CLASS = "can-approve";
    private static final String CAN_REJECT_CSS_CLASS = "can-reject";
    private static ApprovalCheckDecorator decorator;
    private static SelectorManager selectorManager;
    private String name;
    private Approval approval;
    private ApprovalCheck approvalCheck;
    private ApprovalStatus approvalStatus;
    private Selectable.Selector selector;
    private ValueStore valueStore;
    private int state;
    private boolean upToDate;
    private boolean forReporting;
    private boolean canApprove;
    private boolean canAssign;
    private boolean canReject;
    private List<DecoratedApprover> recentApprovers;
    private DecoratedApprover[] decoratedApprovers;
    private DecoratedApprover[] decoratedRejectors;
    private int weight;
    private SignatureType signatureType;
    private AttachmentManager attachmentManager;

    public DecoratedApprovalCheck(ValueStore valueStore, ApprovalCheck approvalCheck, Approval approval, boolean publishView, boolean releaseViewAction, AttachmentManager attachmentManager) throws WorkflowException {
        this.approvalCheck = approvalCheck;
        this.valueStore = valueStore;
        this.attachmentManager = attachmentManager;
        if (approval != null) {
            this.approval = approval;
            this.name = approval.getName();
            this.approvalStatus = approval.getStatus(valueStore, approvalCheck);
            this.weight = approval.getWeight();
            this.signatureType = approval.getCredentials();
            this.selector = approval.isAssignable() && this.approvalStatus.isAllowedToAssign() ? selectorManager.makeUiSelector(Selector.DEFAULT_SELECTOR, valueStore) : (!approval.isAssignable() && !this.approvalStatus.isAllowedToAssign() && this.approvalStatus.getPossibleApprovers().size() > 0 ? selectorManager.makeUiSelector(null, valueStore) : selectorManager.makeUiSelector(approval.getSelector(), valueStore));
        } else {
            this.name = approvalCheck.getName();
            this.approvalStatus = ApprovalStatus.NOT_READY;
        }
        if (publishView) {
            this.approvalStatus.setCanApprove(false);
        }
        if (approvalCheck != null) {
            this.setState(approvalCheck);
            this.weight = approvalCheck.getWeight();
            this.makeDecoratedApprovers(approvalCheck.getMostRecentApprovers());
            this.upToDate = approvalCheck.isCheckUpToDate(valueStore.getPage(), valueStore.getPageState(), !releaseViewAction && valueStore.getPage().isLatestVersion(), attachmentManager);
        } else {
            this.recentApprovers = Collections.emptyList();
            this.state = this.approvalStatus.isCanApprove() ? 2 : 3;
            this.upToDate = true;
        }
        this.setPossibleActionFlags();
    }

    @Override
    public boolean isRolesEnabled() {
        return this.approval.isRoles();
    }

    public DecoratedApprovalCheck(ValueStore valueStore, Approval approval, AttachmentManager attachmentManager) throws WorkflowException {
        this(valueStore, null, approval, false, false, attachmentManager);
    }

    public DecoratedApprovalCheck(ValueStore valueStore, ApprovalCheck approvalCheck, AttachmentManager attachmentManager) {
        this.name = approvalCheck.getName();
        this.approvalCheck = approvalCheck;
        this.valueStore = valueStore;
        this.attachmentManager = attachmentManager;
        this.approvalStatus = ApprovalStatus.NOT_READY;
        this.state = approvalCheck.isApproved() ? 0 : 1;
        this.makeDecoratedApprovers(approvalCheck.getMostRecentApprovers());
        this.upToDate = approvalCheck.isCheckUpToDate(valueStore.getPage(), null, valueStore.getPage().isLatestVersion(), attachmentManager);
        this.forReporting = true;
        this.setState(approvalCheck);
    }

    public DecoratedApprovalCheck(String name, int state, boolean upToDate, boolean canApprove, boolean canAssign, boolean canReject, ApprovalStatus approvalStatus) {
        this.name = name;
        this.approvalStatus = approvalStatus;
        this.state = state;
        this.upToDate = upToDate;
        this.canApprove = canApprove;
        this.canAssign = canAssign;
        this.canReject = canReject;
    }

    private void setState(ApprovalCheck approvalCheck) {
        this.state = approvalCheck.isApproved() ? 0 : (approvalCheck.isRejected(true) ? 1 : (approvalCheck.isRejected(false) ? 5 : 4));
    }

    @Nullable
    public String getRolename(String username) {
        if (this.approvalCheck != null) {
            return this.approvalCheck.getRolename(username);
        }
        return null;
    }

    private void setPossibleActionFlags() {
        if (this.approvalStatus.isCanApprove()) {
            if (this.approvalCheck != null && this.upToDate) {
                String username = AuthenticatedUserThreadLocal.getUsername();
                Approver lastCheck = this.approvalCheck.getLatestApprover(username);
                if (lastCheck != null) {
                    if (lastCheck.isApproved()) {
                        this.canApprove = false;
                        this.canReject = true;
                    } else {
                        this.canApprove = true;
                        this.canReject = false;
                    }
                } else {
                    this.canReject = true;
                    this.canApprove = !this.approvalCheck.isApproved();
                }
            } else {
                this.canApprove = true;
                this.canReject = true;
            }
        } else {
            this.canApprove = false;
            this.canReject = false;
        }
        this.canAssign = this.approvalStatus.isAllowedToAssign() && this.approval.isAssignable();
    }

    private void makeDecoratedApprovers(Approver[] approvers) {
        this.recentApprovers = new ArrayList<DecoratedApprover>(approvers.length);
        ArrayList<DecoratedApprover> approversList = new ArrayList<DecoratedApprover>(approvers.length);
        ArrayList<DecoratedApprover> rejectorsList = new ArrayList<DecoratedApprover>(approvers.length);
        for (Approver approver : approvers) {
            DecoratedApprover decoratedApprover = new DecoratedApprover(approver);
            this.recentApprovers.add(decoratedApprover);
            if (approver.isApproved()) {
                approversList.add(decoratedApprover);
                continue;
            }
            rejectorsList.add(decoratedApprover);
        }
        this.decoratedApprovers = approversList.toArray(new DecoratedApprover[approversList.size()]);
        this.decoratedRejectors = rejectorsList.toArray(new DecoratedApprover[rejectorsList.size()]);
    }

    @Override
    public String getHint() {
        return this.getApprovalInformation();
    }

    @HtmlSafe
    public String getApprovalInformation() {
        String info;
        if (!this.forReporting && (info = this.getSelectorMessage()) != null) {
            return info;
        }
        if (this.upToDate || this.forReporting) {
            if (this.state == 0) {
                return decorator.getText("approvalsworkflow.approvals.info.approved", this.makeApproversList(this.decoratedApprovers));
            }
            if (this.state == 1) {
                return decorator.getText("approvalsworkflow.approvals.info.rejected", this.makeApproversList(this.decoratedRejectors));
            }
            if (this.state == 5) {
                if (this.decoratedApprovers.length == 0) {
                    return decorator.getText("approvalsworkflow.approvals.info.rejected.pending", new String[]{this.makeApproversList(this.decoratedRejectors), decorator.makeUserNamesList(this.approvalCheck.getPendingApproversArray(false), false, this.forReporting)});
                }
                String[] pendingApprovers = this.approvalCheck.getPendingApproversArray(false);
                String textKey = pendingApprovers.length > 0 ? "approvalsworkflow.approvals.info.rejected.partial.pending" : "approvalsworkflow.approvals.info.rejected.partial";
                return decorator.getText(textKey, new String[]{this.makeApproversList(this.decoratedApprovers), this.makeApproversList(this.decoratedRejectors), decorator.makeUserNamesList(this.approvalCheck.getPendingApproversArray(false), false, this.forReporting)});
            }
            if (this.state == 4) {
                if (this.decoratedApprovers.length == 0) {
                    return decorator.getText("approvalsworkflow.approvals.info.assigned", decorator.makeUserNamesList(this.approvalCheck.getPendingApproversArray(true), false, this.forReporting));
                }
                return decorator.getText("approvalsworkflow.approvals.info.approved.partial", new String[]{this.makeApproversList(this.decoratedApprovers), decorator.makeUserNamesList(this.approvalCheck.getPendingApproversArray(true), false, this.forReporting)});
            }
        }
        if (this.state == 2 || this.approvalStatus.isReady()) {
            String[] requiredApprovers = this.approvalStatus.getRequiredApprovers();
            if (requiredApprovers.length > 0) {
                return decorator.getText("approvalsworkflow.approvals.info.ready", decorator.makeUserNamesList(requiredApprovers, false, this.forReporting));
            }
            Collection<Entity> possibleApprovers = this.approvalStatus.getPossibleApprovers();
            if (possibleApprovers.size() > 0) {
                return decorator.getText("approvalsworkflow.approvals.info.ready", decorator.makeUsersAndGroupsList(possibleApprovers, true, this.forReporting));
            }
            return decorator.getText("approvalsworkflow.approvals.info.waiting-for-approval");
        }
        if (this.approvalStatus.getPrecedingApprovalsNames() != null) {
            return decorator.getText("approvalsworkflow.approvals.info.requires-other-approval", this.approvalStatus.getPrecedingApprovalsNames());
        }
        return decorator.getText("approvalsworkflow.approvals.info.not-ready");
    }

    private String getSelectorMessage() {
        if (this.selector == null || this.selector.isFixed() || this.selector.getMinAssignees() <= 1 || this.approvalCheck == null) {
            return null;
        }
        int count = this.approvalCheck.getRequiredApprovers().length;
        if (count >= this.selector.getMinAssignees()) {
            return null;
        }
        if (count == 0) {
            return decorator.getText("approvalsworkflow.approvals.info.requiredapprovers.total", Integer.toString(this.selector.getMinAssignees()));
        }
        int missing = this.selector.getMinAssignees() - count;
        if (missing == 1) {
            return decorator.getText("approvalsworkflow.approvals.info.requiredapprovers.one-more");
        }
        return decorator.getText("approvalsworkflow.approvals.info.requiredapprovers.more", Integer.toString(missing));
    }

    private String makeApproversList(DecoratedApprover[] approvers) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < approvers.length; ++i) {
            DecoratedApprover approver = approvers[i];
            if (i > 0) {
                if (i == approvers.length - 1) {
                    sb.append(' ').append(decorator.getText("and.word")).append(' ');
                } else {
                    sb.append(", ");
                }
            }
            sb.append(approver.toString(approvers.length == 1));
        }
        return sb.toString();
    }

    public String getVersionInformation() {
        String version = Integer.toString(this.approvalCheck.getVersion());
        if (this.state == 0) {
            return decorator.getText("approvalsworkflow.approvals.info.was-approved", new String[]{version, this.makeApproversList(this.decoratedApprovers)});
        }
        if (this.state == 1 || this.state == 5) {
            if (this.decoratedApprovers.length > 0) {
                return decorator.getText("approvalsworkflow.approvals.info.was-rejected.multiple", new String[]{version, this.makeApproversList(this.decoratedApprovers), this.makeApproversList(this.decoratedRejectors)});
            }
            return decorator.getText("approvalsworkflow.approvals.info.was-rejected", new String[]{version, this.makeApproversList(this.decoratedRejectors)});
        }
        return "";
    }

    @Override
    public String getFilterUsers() {
        return this.asCommaSeparated(this.approvalStatus.getPossibleUserApproverNameStrings());
    }

    @Override
    public String getFilterGroups() {
        return this.asCommaSeparated(this.approvalStatus.getPossibleGroupApproverNameStrings());
    }

    @Override
    public String getFilterExcludedUsers() {
        return this.asCommaSeparated(this.approvalStatus.getExcludedUserApproversNameStrings());
    }

    @Override
    public String getApproveLabel() {
        return this.approval.getApproveLabel();
    }

    @Override
    public String getRejectLabel() {
        return this.approval.getRejectLabel();
    }

    private String asCommaSeparated(Collection<String> list) {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (String s : list) {
            if (!first) {
                sb.append(",");
            }
            sb.append(s);
            first = false;
        }
        return sb.toString();
    }

    public List getRecentApprovers() {
        return this.recentApprovers;
    }

    @Override
    public boolean isApproved() {
        if (this.isUpToDate()) {
            return this.state == 0;
        }
        return false;
    }

    @Override
    public boolean isRejected() {
        if (this.isUpToDate()) {
            return this.state == 1;
        }
        return false;
    }

    public boolean isUpToDate() {
        return this.upToDate;
    }

    public boolean isCanApprove() {
        return this.canApprove;
    }

    public boolean isCanReject() {
        return this.canReject;
    }

    @Override
    public boolean canApprove() {
        return this.canApprove;
    }

    public boolean canAssign() {
        return this.canAssign;
    }

    @Override
    public boolean canReject() {
        return this.canReject;
    }

    @Override
    public SignatureType getSignatureType() {
        return this.signatureType;
    }

    @Override
    public List<com.comalatech.workflow.model.Approval> getApprovals() {
        if (this.approvalCheck != null && this.isUpToDate()) {
            return this.approvalCheck.getApprovals();
        }
        return Collections.emptyList();
    }

    @Override
    public List<com.comalatech.workflow.model.Approval> getMostRecentApprovalsOnly() {
        if (this.approvalCheck != null && this.isUpToDate()) {
            return this.approvalCheck.getMostRectentApprovals();
        }
        return Collections.emptyList();
    }

    public List<Approver> getUpdatedFinishedApprovers(boolean approved) {
        ArrayList<Approver> finishedApprovers = new ArrayList<Approver>();
        if (this.approvalCheck != null && this.approvalCheck.isCheckUpToDate(this.valueStore.getPage(), this.valueStore.getPageState(), true, this.attachmentManager)) {
            return this.approvalCheck.getLatestApprovers(approved);
        }
        return finishedApprovers;
    }

    @Override
    public List<AssignedApprover> getAssignments() {
        if (this.approvalCheck != null) {
            if (this.approvalCheck.isCheckUpToDate(this.valueStore.getPage(), this.valueStore.getPageState(), true, this.attachmentManager)) {
                return this.approvalCheck.getActualApproversAndRequiredApprovers(AuthenticatedUserThreadLocal.getUsername(), this.signatureType, this.approvalStatus.isCanApprove());
            }
            ApprovalCheck dummyCheck = new ApprovalCheck(this.name);
            dummyCheck.setRequiredApprovers(this.approvalCheck.getRequiredApprovers());
            return dummyCheck.getActualApproversAndRequiredApprovers(AuthenticatedUserThreadLocal.getUsername(), this.signatureType, this.approvalStatus.isCanApprove());
        }
        ApprovalCheck dummyCheck = new ApprovalCheck(this.name);
        dummyCheck.setRequiredApprovers(this.approvalStatus.getRequiredApprovers());
        return dummyCheck.getActualApproversAndRequiredApprovers(AuthenticatedUserThreadLocal.getUsername(), this.signatureType, this.approvalStatus.isCanApprove());
    }

    @Override
    public List<AssignedApprover> getPendingAssignments() {
        return this.getAssignments().stream().filter(assignment -> !assignment.isApproved() && !assignment.isRejected()).collect(Collectors.toList());
    }

    @Override
    public List<AssignedApprover> getCompletedAssignments() {
        return this.getAssignments().stream().filter(assignment -> assignment.isApproved() || assignment.isRejected()).collect(Collectors.toList());
    }

    @Override
    public int getMinimumApprovers() {
        if (this.approvalCheck != null) {
            return this.approvalCheck.getMinimumApproversRequired();
        }
        if (this.approval != null) {
            if (StringUtils.isNumeric((CharSequence)this.approval.getMinRequiredApprovers())) {
                return Integer.parseInt(this.approval.getMinRequiredApprovers());
            }
            String value = null;
            try {
                value = this.valueStore.getValue(this.approval.getMinRequiredApprovers());
                return Double.valueOf(value).intValue();
            }
            catch (Exception e) {
                log.error("MinRequiredValue expression cannot be evaluated. Expression: '" + this.approval.getMinRequiredApprovers() + "'. Value: '" + value + "'.", (Throwable)e);
            }
        }
        return 0;
    }

    public ApprovalCheck getApprovalCheck() {
        return this.approvalCheck;
    }

    @Override
    public String getAssignerUserName(String approverUserName) {
        if (this.approvalCheck != null) {
            return this.approvalCheck.getAssignerUserName(approverUserName);
        }
        return null;
    }

    @Override
    public Selectable.Selector getSelector() {
        return this.selector;
    }

    @Override
    public boolean canExecute() {
        return this.canApprove || this.canReject;
    }

    public String getPossibleActions() {
        if (this.isReadOnly()) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        if (this.canApprove) {
            sb.append(' ').append(CAN_APPROVE_CSS_CLASS);
        }
        if (this.canReject) {
            sb.append(' ').append(CAN_REJECT_CSS_CLASS);
        }
        return sb.toString();
    }

    public int getWeight() {
        return this.weight;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Approval getApproval() {
        return this.approval;
    }

    public int getState() {
        return this.state;
    }

    public String getStateName() {
        String strState = STATE_NAMES[this.state];
        if (this.state == 4 && this.approvalStatus.isCanApprove()) {
            return strState + "-available";
        }
        return strState;
    }

    public String getNiceDate() {
        if (this.approvalCheck == null) {
            return "";
        }
        return decorator.decorateDatePretty(this.getDate());
    }

    public String getTimeDate() {
        if (this.approvalCheck == null) {
            return "";
        }
        return decorator.decorateTimeDate(this.getDate());
    }

    public Date getDate() {
        return this.approvalCheck.getLastApprover().getDate();
    }

    public boolean isReadOnly() {
        return !this.approvalStatus.isCanApprove();
    }

    public Date getTime() {
        if (this.recentApprovers.size() == 0) {
            return null;
        }
        return this.recentApprovers.get(0).getApprover().getDate();
    }

    public UrlLink getApprovedPageLink() {
        if (this.approvalCheck != null) {
            return decorator.decorateMarkedVersion(this.valueStore.getPage(), this.approvalCheck.getVersion(), this.approvalCheck.getId(), this.upToDate);
        }
        return null;
    }

    public int getCredentials() {
        if (Arrays.asList(SignatureType.PASSWORD, SignatureType.USERID_AND_PASSWORD).contains((Object)this.signatureType)) {
            return this.signatureType.getId();
        }
        return SignatureType.NONE.getId();
    }

    public String getId() {
        return Integer.toString(this.name.hashCode());
    }

    public static void setDecorator(ApprovalCheckDecorator decorator) {
        DecoratedApprovalCheck.decorator = decorator;
    }

    public static void setSelectorManager(SelectorManager selectorManager) {
        DecoratedApprovalCheck.selectorManager = selectorManager;
    }

    public int compareTo(Object o) {
        DecoratedApprovalCheck c = (DecoratedApprovalCheck)o;
        if (this.name.equals(c.getName())) {
            return 0;
        }
        if (this.state != c.getState()) {
            if (this.state <= 1) {
                if (c.getState() > 1) {
                    return -1;
                }
            } else if (c.getState() <= 1) {
                return 1;
            }
        }
        if (this.weight < c.getWeight()) {
            return -1;
        }
        if (this.weight > c.getWeight()) {
            return 1;
        }
        return this.name.compareTo(c.getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DecoratedApprovalCheck that = (DecoratedApprovalCheck)o;
        if (this.state != that.state) {
            return false;
        }
        if (this.upToDate != that.upToDate) {
            return false;
        }
        if (this.canApprove != that.canApprove) {
            return false;
        }
        if (this.canReject != that.canReject) {
            return false;
        }
        if (!Objects.equals(this.approvalStatus, that.approvalStatus)) {
            return false;
        }
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.approvalStatus != null ? this.approvalStatus.hashCode() : 0);
        result = 31 * result + this.state;
        result = 31 * result + this.weight;
        result = 31 * result + (this.upToDate ? 1 : 0);
        return result;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("name", (Object)this.name).append("state", (Object)this.getStateName()).append("uptodate", this.upToDate).append("canApprove", this.canApprove).append("canReject", this.canReject).append((Object)this.approvalStatus).toString();
    }

    @Override
    public List<String> getAssignees() {
        return this.approvalCheck != null ? this.approvalCheck.getAssignees() : new ArrayList();
    }

    @Override
    public List<String> getPendingApprovers() {
        return this.approvalCheck != null ? this.approvalCheck.getPendingApprovers() : new ArrayList();
    }

    public class DecoratedApprover {
        Approver approver;

        public DecoratedApprover(Approver approver) {
            this.approver = approver;
        }

        public String getUserLink() {
            return decorator.decorateUser(this.approver.getUser());
        }

        public String getDate() {
            return decorator.decorateTimeDate(this.approver.getDate());
        }

        public String getFullName() {
            return decorator.getUserFullName(this.approver.getUser());
        }

        public String getUserName() {
            return this.approver.getUser();
        }

        public String toString(boolean single) {
            String fullName = DecoratedApprovalCheck.this.forReporting ? decorator.decorateUser(this.approver.getUser()) : decorator.getUserFullName(this.approver.getUser());
            StringBuffer sb = new StringBuffer(fullName);
            sb.append(' ');
            if (!single) {
                sb.append("(");
            }
            if (DecoratedApprovalCheck.this.forReporting) {
                sb.append(decorator.decorateDateTimeFormal(this.approver.getDate()));
            } else {
                sb.append(decorator.decorateDatePretty(this.approver.getDate()));
            }
            String comment = this.approver.getComment();
            if (StringUtils.isNotBlank((CharSequence)comment)) {
                sb.append(" - ").append(comment);
            }
            if (!single) {
                sb.append(")");
            }
            return sb.toString();
        }

        public String getComment() {
            String comment = this.approver.getComment();
            return comment != null ? comment : "";
        }

        public String getCommentInBraces() {
            String comment = this.approver.getComment();
            return StringUtils.isNotBlank((CharSequence)comment) ? "(" + comment + ")" : "";
        }

        public Approver getApprover() {
            return this.approver;
        }
    }
}

