/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.model;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.user.Entity;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import com.comalatech.confluence.util.PluginContainerManager;
import com.comalatech.confluence.workflow.ApprovalManager;
import com.comalatech.confluence.workflow.SelectorManager;
import com.comalatech.confluence.workflow.UsersListResolver;
import com.comalatech.confluence.workflow.ValueStore;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.model.AbstractUserGroupApproverCondition;
import com.comalatech.confluence.workflow.model.ApprovalCheck;
import com.comalatech.confluence.workflow.model.Selector;
import com.comalatech.confluence.workflowcontainer.model.SerializableMacro;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApproverCondition
extends AbstractUserGroupApproverCondition {
    private static final Logger log = LoggerFactory.getLogger(ApproverCondition.class);
    private final Selector selector;
    private UsersListResolver.UsersReference reference = null;
    private final ApproverConditionType conditionType;

    public ApproverCondition(Selector selector, ApproverConditionType conditionType) {
        super(false);
        this.selector = selector;
        this.conditionType = conditionType;
    }

    @Override
    protected boolean evaluateBinary(ValueStore valueStore) throws WorkflowException {
        ConfluenceUser user = this.getUser();
        if (user == null) {
            return false;
        }
        ApprovalManager approvalManager = this.getApprovalManager();
        if (approvalManager != null) {
            ApprovalCheck approvalCheck = approvalManager.getLastApprovalByName(valueStore, this.selector.getApprovalName(), true);
            if (approvalCheck != null) {
                String[] approvers;
                for (String approvalUser : approvers = approvalCheck.getRequiredApprovers()) {
                    if (!approvalUser.equalsIgnoreCase(user.getName())) continue;
                    return true;
                }
            } else {
                ApproverCondition.getSelectorManager().getRequiredUsersNames(this.selector, valueStore);
            }
        }
        return false;
    }

    public Selector getSelector() {
        return this.selector;
    }

    public void generateUsersGroupsList() {
        this.reference = this.conditionType.equals((Object)ApproverConditionType.GROUP) ? this.getUsersListResolver().makeGroupsReference(this.selector.getUsers()) : this.getUsersListResolver().makeUsersReference(this.selector.getUsers());
    }

    public String getUserList() {
        if (this.reference == null) {
            this.generateUsersGroupsList();
        }
        return this.reference.getUsersList();
    }

    public String getGroupList() {
        if (this.reference == null) {
            this.generateUsersGroupsList();
        }
        return this.reference.getGroupsList();
    }

    @Override
    public String toString(ValueStore valueStore) {
        if (valueStore == null) {
            log.error("need to provide value store");
            return "";
        }
        try {
            return this.selectorToString(this.selector, valueStore);
        }
        catch (WorkflowException e) {
            return "{warning}" + e.getMessage() + "{warning}";
        }
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    private String selectorToString(Selector selector, ValueStore valueStore) throws WorkflowException {
        String caption = selector.getCaption() == null ? "" : " as _\"" + selector.getCaption() + "\"_";
        if (selector.isAllMustApprove()) {
            return "all users in \\{" + this.getUsersListResolver().usersReferenceToWiki(valueStore, selector.getUsers(), " and ") + "\\} must approve";
        }
        if (selector.isAnyCanApprove()) {
            return "any user in \\{" + this.getUsersListResolver().usersReferenceToWiki(valueStore, selector.getUsers(), " or ") + "\\}" + caption;
        }
        if (selector.isSelectOne()) {
            return "user is selected from \\{" + this.getUsersListResolver().usersReferenceToWiki(valueStore, selector.getUsers(), " or ") + "\\}" + caption;
        }
        if (selector.isSelectMultiple()) {
            String countBlurb = selector.getMinimum().equals("1") ? "at least one user is " : "at least " + selector.getMinimum() + " users are ";
            return countBlurb + "selected from \\{" + this.getUsersListResolver().usersReferenceToWiki(valueStore, selector.getUsers(), " or ") + "\\}" + caption;
        }
        throw new WorkflowException("Invalid selector");
    }

    @Override
    public void addMacroParameters(SerializableMacro macro) {
        ComalaI18nBean comalaI18nBean = ComalaI18nBean.getComalaI18nBean();
        if (!comalaI18nBean.getText("approvalsworkflow.approvals.next-approver").equals(this.selector.getCaption())) {
            macro.addParameter("caption", (Object)this.selector.getCaption());
        }
        if (!comalaI18nBean.getText("approvalsworkflow.approvals.next-approver.hint").equals(this.selector.getHint())) {
            macro.addParameter("hint", (Object)this.selector.getCaption());
        }
        if (this.selector.isAllMustApprove()) {
            this.generateUsersGroupsList();
            String userList = this.getUserList();
            String groupList = this.getGroupList();
            if (StringUtils.isNotBlank((CharSequence)userList)) {
                macro.addParameter("user", (Object)("&" + userList));
            }
            if (StringUtils.isNotBlank((CharSequence)groupList)) {
                macro.addParameter("group", (Object)("&" + groupList));
            }
        } else if (this.selector.isAnyCanApprove()) {
            macro.addParameter("user", (Object)this.selector.getUsers());
        } else if (this.selector.isSelectOne()) {
            macro.addParameter("selectedapprover", (Object)this.selector.getUsers());
        } else if (this.selector.isSelectMultiple()) {
            macro.addParameter("selectedapprovers", (Object)this.selector.getUsers());
        } else {
            throw new RuntimeException("invalid selector " + this.selector);
        }
        try {
            int minimumSelectorVal = Integer.parseInt(this.selector.getMinimum());
            if (minimumSelectorVal > 1) {
                macro.addParameter("minimum", (Object)this.selector.getMinimum());
            }
        }
        catch (NumberFormatException ex) {
            macro.addParameter("minimum", (Object)this.selector.getMinimum());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApproverCondition that = (ApproverCondition)o;
        return !(this.selector != null ? !this.selector.equals(that.selector) : that.selector != null);
    }

    public int hashCode() {
        return this.selector != null ? this.selector.hashCode() : 0;
    }

    public static SelectorManager getSelectorManager() {
        return PluginContainerManager.getComponent("selectorManager", SelectorManager.class);
    }

    public ApproverConditionType getConditionType() {
        return this.conditionType;
    }

    @Override
    public Collection<Entity> getSelectableUsersOrGroups(ValueStore valueStore, Selector selector) throws WorkflowException {
        return ApproverCondition.getSelectorManager().getSelectableUsersOrGroups(selector, valueStore);
    }

    @Override
    public ConfluenceUser[] getSelectableUsers(ValueStore valueStore, Selector selector, boolean ignoreExceptions) throws WorkflowException {
        return ApproverCondition.getSelectorManager().getSelectableUsers(valueStore, selector, ignoreExceptions);
    }

    @Override
    public boolean isApplicableToProduct() {
        return this.selector.isAllMustApprove() && ApproverCondition.getWorkflowsFeatureManager().isWorkflowsLiteApp() || ApproverCondition.getWorkflowsFeatureManager().isWorkflowsApp();
    }

    public static enum ApproverConditionType {
        USER("user"),
        GROUP("group");

        public static ApproverConditionType DEFAULT;
        private static Map<String, ApproverConditionType> TYPES_MAP;
        private String name;

        private ApproverConditionType(String name) {
            this.name = name;
        }

        @JsonCreator
        public static ApproverConditionType fromString(String string) {
            return Optional.ofNullable(TYPES_MAP.get(string)).orElseThrow(() -> new IllegalArgumentException(string));
        }

        @JsonValue
        public String toString() {
            return this.name;
        }

        static {
            DEFAULT = USER;
            TYPES_MAP = Stream.of(ApproverConditionType.values()).collect(Collectors.toMap(s -> s.name, Function.identity()));
        }
    }
}

