/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.macros.templates;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.macro.MacroException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class MacroParameters {
    private Map parameters;
    private RenderContext renderContext;

    public MacroParameters(Map parameters, RenderContext renderContext) throws MacroException {
        this.parameters = parameters;
        this.renderContext = renderContext;
    }

    public MacroParameters(Map parameters) throws MacroException {
        this.parameters = parameters;
    }

    public MacroParameters(RenderContext renderContext) throws MacroException {
        this.renderContext = renderContext;
    }

    public String get(String[] keys, boolean mandatory) throws MacroException {
        String value = null;
        for (int i = 0; value == null && i < keys.length; ++i) {
            String key = keys[i];
            value = (String)this.parameters.get(key);
        }
        if (!StringUtils.isNotBlank(value) && mandatory) {
            throw new MacroException("Must provide a value for parameter " + this.getFirstParamName(keys));
        }
        return value;
    }

    private String getFirstParamName(String[] keys) {
        return keys[0].equals("0") ? "" : "'" + keys[0] + "'";
    }

    public String get(String key, boolean mandatory) throws MacroException {
        return this.get(new String[]{key}, mandatory);
    }

    public String get(String key) throws MacroException {
        return this.get(key, false);
    }

    public String get(String[] keys) throws MacroException {
        return this.get(keys, false);
    }

    public String get(String[] keys, String defaultValue) throws MacroException {
        String value = this.get(keys, false);
        return !StringUtils.isNotBlank((CharSequence)value) ? defaultValue : value;
    }

    public String get(String key, String defaultValue) throws MacroException {
        return this.get(new String[]{key}, defaultValue);
    }

    public int getInt(String[] keys, boolean mandatory) throws MacroException {
        String value = this.get(keys, mandatory);
        if (!StringUtils.isNotBlank((CharSequence)value)) {
            return 0;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException var5) {
            throw new MacroException("Expected a numeric value for parameter " + this.getFirstParamName(keys) + " + but got " + value);
        }
    }

    public int getInt(String key, boolean mandatory) throws MacroException {
        return this.getInt(new String[]{key}, mandatory);
    }

    public int getInt(String key) throws MacroException {
        return this.getInt(key, false);
    }

    public int getInt(String[] keys) throws MacroException {
        return this.getInt(keys, false);
    }

    public int getInt(String[] keys, int defaultValue) throws MacroException {
        String value = this.get(keys, false);
        if (!StringUtils.isNotBlank((CharSequence)value)) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException var5) {
            throw new MacroException("Expected a numeric value for parameter " + this.getFirstParamName(keys) + " + but got " + value);
        }
    }

    public int getInt(String key, int defaultValue) throws MacroException {
        return this.getInt(new String[]{key}, defaultValue);
    }

    public boolean getFlag(String[] keys, boolean mandatory) throws MacroException {
        String flag = this.get(keys, mandatory);
        return Boolean.TRUE.toString().equalsIgnoreCase(flag);
    }

    public boolean getFlag(String key, boolean mandatory) throws MacroException {
        return this.getFlag(new String[]{key}, mandatory);
    }

    public boolean getFlag(String key) throws MacroException {
        return this.getFlag(new String[]{key}, false);
    }

    public boolean getFlag(String[] keys) throws MacroException {
        return this.getFlag(keys, false);
    }

    public boolean getFlagWithDefault(String[] keys, boolean defaultValue) throws MacroException {
        String flag = this.get(keys, false);
        return !StringUtils.isNotBlank((CharSequence)flag) ? defaultValue : Boolean.TRUE.toString().equalsIgnoreCase(flag);
    }

    public boolean getFlagWithDefault(String key, boolean defaultValue) throws MacroException {
        return this.getFlagWithDefault(new String[]{key}, defaultValue);
    }

    public PageContext getPageContext() throws MacroException {
        if (!(this.renderContext instanceof PageContext)) {
            throw new MacroException("this macro only works within a page or blog post context");
        }
        return (PageContext)this.renderContext;
    }

    public boolean isRenderingTemplate() {
        if (!(this.renderContext instanceof PageContext)) {
            return false;
        }
        AbstractPage page = (AbstractPage)((PageContext)this.renderContext).getEntity();
        return page.getId() == 0L;
    }

    public AbstractPage getAbstractPage() throws MacroException {
        return this.getPageContext().getEntity() instanceof AbstractPage ? (AbstractPage)this.getPageContext().getEntity() : null;
    }

    public Page getPage() throws MacroException {
        AbstractPage page = this.getAbstractPage();
        if (!(page instanceof Page)) {
            throw new MacroException("this macro only works within a page");
        }
        return (Page)page;
    }

    public BlogPost getBlogPost() throws MacroException {
        AbstractPage page = this.getAbstractPage();
        if (!(page instanceof BlogPost)) {
            throw new MacroException("this macro only works within a blog post");
        }
        return (BlogPost)page;
    }
}

