/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.macros.templates;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.plugin.services.VelocityHelperService;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.SubRenderer;
import com.atlassian.renderer.v2.macro.MacroException;
import com.comalatech.confluence.workflow.macros.templates.MacroParameters;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseMacro
extends com.atlassian.renderer.v2.macro.BaseMacro {
    private static final Logger log = LoggerFactory.getLogger(BaseMacro.class);
    private SubRenderer subRenderer;
    private VelocityHelperService velocityHelperService;

    protected BaseMacro() {
    }

    public boolean isInline() {
        return false;
    }

    protected String getParam(Map parameters, String[] keys, boolean mandatory) throws MacroException {
        return new MacroParameters(parameters).get(keys, mandatory);
    }

    protected String getParam(Map parameters, String key, boolean mandatory) throws MacroException {
        return this.getParam(parameters, new String[]{key}, mandatory);
    }

    protected String getParam(Map parameters, String key) throws MacroException {
        return this.getParam(parameters, key, false);
    }

    protected String getParam(Map parameters, String[] keys) throws MacroException {
        return this.getParam(parameters, keys, false);
    }

    protected String getParam(Map parameters, String[] keys, String defaultValue) throws MacroException {
        return new MacroParameters(parameters).get(keys, defaultValue);
    }

    protected String getParam(Map parameters, String key, String defaultValue) throws MacroException {
        return this.getParam(parameters, new String[]{key}, defaultValue);
    }

    protected int getParamAsInt(Map parameters, String[] keys, boolean mandatory) throws MacroException {
        return new MacroParameters(parameters).getInt(keys, mandatory);
    }

    protected int getParamAsInt(Map parameters, String key, boolean mandatory) throws MacroException {
        return this.getParamAsInt(parameters, new String[]{key}, mandatory);
    }

    protected int getParamAsInt(Map parameters, String key) throws MacroException {
        return this.getParamAsInt(parameters, key, false);
    }

    protected int getParamAsInt(Map parameters, String[] keys) throws MacroException {
        return this.getParamAsInt(parameters, keys, false);
    }

    protected int getParamAsInt(Map parameters, String[] keys, int defaultValue) throws MacroException {
        return new MacroParameters(parameters).getInt(keys, defaultValue);
    }

    protected int getParamAsInt(Map parameters, String key, int defaultValue) throws MacroException {
        return this.getParamAsInt(parameters, new String[]{key}, defaultValue);
    }

    protected boolean getParamAsFlag(Map parameters, String[] keys, boolean mandatory) throws MacroException {
        return new MacroParameters(parameters).getFlag(keys, mandatory);
    }

    protected boolean getParamAsFlag(Map parameters, String key, boolean mandatory) throws MacroException {
        return this.getParamAsFlag(parameters, new String[]{key}, mandatory);
    }

    protected boolean getParamAsFlag(Map parameters, String key) throws MacroException {
        return this.getParamAsFlag(parameters, new String[]{key}, false);
    }

    protected boolean getParamAsFlag(Map parameters, String[] keys) throws MacroException {
        return this.getParamAsFlag(parameters, keys, false);
    }

    protected boolean getParamAsFlagWithDefault(Map parameters, String[] keys, boolean defaultValue) throws MacroException {
        return new MacroParameters(parameters).getFlagWithDefault(keys, defaultValue);
    }

    protected boolean getParamAsFlagWithDefault(Map parameters, String key, boolean defaultValue) throws MacroException {
        return this.getParamAsFlagWithDefault(parameters, new String[]{key}, defaultValue);
    }

    public PageContext getPageContext(RenderContext renderContext) throws MacroException {
        if (!(renderContext instanceof PageContext)) {
            throw new MacroException("this macro only works within a page or blog post context");
        }
        return (PageContext)renderContext;
    }

    public AbstractPage getAbstractPage(RenderContext renderContext) throws MacroException {
        return (AbstractPage)this.getPageContext(renderContext).getEntity();
    }

    public Page getPage(RenderContext renderContext) throws MacroException {
        AbstractPage page = this.getAbstractPage(renderContext);
        if (!(page instanceof Page)) {
            throw new MacroException("this macro only works within a page");
        }
        return (Page)page;
    }

    public BlogPost getBlogPost(RenderContext renderContext) throws MacroException {
        AbstractPage page = this.getAbstractPage(renderContext);
        if (!(page instanceof BlogPost)) {
            throw new MacroException("this macro only works within a blog post");
        }
        return (BlogPost)page;
    }

    protected String renderTemplate(Map<String, Object> parameters, String templatePath) throws MacroException {
        Map contextMap = MacroUtils.defaultVelocityContext();
        contextMap.putAll(parameters);
        try {
            return this.velocityHelperService.getRenderedTemplateWithoutSwallowingErrors(templatePath, contextMap);
        }
        catch (Exception var5) {
            log.error("", (Throwable)var5);
            throw new MacroException((Throwable)var5);
        }
    }

    protected String render(String wiki, RenderContext renderContext, RenderMode renderMode) {
        return this.subRenderer.render(wiki, renderContext, renderMode);
    }

    protected String render(String wiki, RenderContext renderContext) {
        return this.subRenderer.render(wiki, renderContext);
    }

    public void setSubRenderer(SubRenderer subRenderer) {
        this.subRenderer = subRenderer;
    }

    public void setVelocityHelperService(VelocityHelperService velocityHelperService) {
        this.velocityHelperService = velocityHelperService;
    }
}

