/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.listeners.triggers.labels;

import com.atlassian.confluence.event.events.ConfluenceEvent;
import com.atlassian.confluence.event.events.label.LabelAddEvent;
import com.atlassian.confluence.event.events.label.LabelEvent;
import com.atlassian.confluence.event.events.label.LabelRemoveEvent;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.labels.Namespace;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.user.User;
import com.comalatech.confluence.documentActivity.manager.EventHistoryManager;
import com.comalatech.confluence.workflow.PageWorkflows;
import com.comalatech.confluence.workflow.WorkflowAccessor;
import com.comalatech.confluence.workflow.WorkflowActionManager;
import com.comalatech.confluence.workflow.listeners.StateHandler;
import com.comalatech.confluence.workflow.listeners.triggers.TriggersListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LabelTriggersListener
extends TriggersListener {
    private static final Logger log = LoggerFactory.getLogger(LabelTriggersListener.class);
    private final PermissionManager permissionManager;
    private final LabelManager labelManager;
    private final StateHandler stateHandler;
    private final ThreadLocal<Label> stickyLabelThreadLocal = new ThreadLocal();

    public LabelTriggersListener(WorkflowAccessor workflowAccessor, WorkflowActionManager workflowActionManager, EventPublisher eventPublisher, PermissionManager permissionManager, LabelManager labelManager, StateHandler stateHandler, EventHistoryManager eventHistoryManager, DarkFeatureManager darkFeatureManager) {
        super(workflowAccessor, workflowActionManager, eventHistoryManager, darkFeatureManager, eventPublisher);
        this.permissionManager = permissionManager;
        this.labelManager = labelManager;
        this.stateHandler = stateHandler;
    }

    @EventListener
    public void onLabelAddEvent(LabelAddEvent event) {
        try {
            this.logEventSource((ConfluenceEvent)event);
            if (!(event.getLabelled() instanceof AbstractPage)) {
                return;
            }
            PageWorkflows pageWorkflows = this.getPageWorkflows((ConfluenceEvent)event);
            if (pageWorkflows == null) {
                return;
            }
            if (event.getLabel().equals((Object)this.stickyLabelThreadLocal.get())) {
                return;
            }
            if (Namespace.isPersonal((Label)event.getLabel())) {
                return;
            }
            this.stateHandler.handle(event, pageWorkflows);
            this.evaluateTriggers(pageWorkflows, (ConfluenceEvent)event);
        }
        catch (Exception e) {
            log.error("There has been an exception handling the event.", (Throwable)e);
        }
        catch (Error e) {
            log.error("There has been an error handling the event.", (Throwable)e);
        }
    }

    @EventListener
    public void onLabelRemoveEvent(LabelRemoveEvent event) {
        try {
            this.logEventSource((ConfluenceEvent)event);
            if (!(event.getLabelled() instanceof AbstractPage)) {
                return;
            }
            PageWorkflows pageWorkflows = this.getPageWorkflows((ConfluenceEvent)event);
            if (pageWorkflows == null) {
                return;
            }
            if (this.addLabelAgainIfSticky(pageWorkflows, (LabelEvent)event)) {
                return;
            }
            if (Namespace.isPersonal((Label)event.getLabel())) {
                return;
            }
            this.evaluateTriggers(pageWorkflows, (ConfluenceEvent)event);
        }
        catch (Exception e) {
            log.error("There has been an exception handling the event.", (Throwable)e);
        }
        catch (Error e) {
            log.error("There has been an error handling the event.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addLabelAgainIfSticky(PageWorkflows pageWorkflows, LabelEvent event) {
        if (!pageWorkflows.isLabelSticky(event.getLabel())) {
            return false;
        }
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (this.permissionManager.hasPermission((User)user, Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION) || this.permissionManager.hasPermission((User)user, Permission.ADMINISTER, (Object)((AbstractPage)event.getLabelled()).getSpace())) {
            return false;
        }
        this.stickyLabelThreadLocal.set(event.getLabel());
        try {
            this.labelManager.addLabel(event.getLabelled(), event.getLabel());
        }
        finally {
            this.stickyLabelThreadLocal.remove();
        }
        return true;
    }
}

