/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.esignatures.resources;

import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.comalatech.confluence.adhocworkflows.rest.permissions.WorkflowsAppRequired;
import com.comalatech.confluence.adhocworkflows.rest.permissions.WorkflowsLiteAppRequired;
import com.comalatech.confluence.encryption.AESEncryptionException;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.workflow.esignatures.configuration.ESignaturesConfigurationManager;
import com.comalatech.confluence.workflow.esignatures.model.EmailSigningRequest;
import com.comalatech.confluence.workflow.esignatures.model.SigningToken;
import com.comalatech.confluence.workflow.esignatures.model.SigningTokenStatus;
import com.comalatech.confluence.workflow.esignatures.model.TokenRequest;
import com.comalatech.confluence.workflow.esignatures.resources.AbstractRestOTPResource;
import com.comalatech.confluence.workflow.esignatures.service.ESignaturesService;
import com.comalatech.confluence.workflow.esignatures.service.TOTPHelper;
import com.comalatech.confluence.workflow.esignatures.validator.ESignatureValidator;
import com.webcohesion.enunciate.metadata.rs.ResponseCode;
import com.webcohesion.enunciate.metadata.rs.StatusCodes;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WorkflowsAppRequired
@WorkflowsLiteAppRequired
@Path(value="/user/config/otp/{userKey}")
@Produces(value={"application/json"})
public class OneTimePasswordResource
extends AbstractRestOTPResource {
    private static final Logger log = LoggerFactory.getLogger(OneTimePasswordResource.class);
    private final ESignaturesService eSignaturesService;
    private ESignatureValidator validator;

    public OneTimePasswordResource(PermissionManager permissionManager, WorkflowsFeatureManager workflowsFeatureManager, ESignaturesService eSignaturesService, ESignaturesConfigurationManager eSignaturesConfigurationManager, UserAccessor userAccessor, ComalaI18nBean comalaI18nBean) {
        super(permissionManager, workflowsFeatureManager, eSignaturesConfigurationManager, comalaI18nBean);
        this.eSignaturesService = eSignaturesService;
        TOTPHelper totpHelper = new TOTPHelper();
        this.validator = new ESignatureValidator(totpHelper, userAccessor, comalaI18nBean);
    }

    @GET
    @Path(value="/status")
    @Produces(value={"application/json"})
    @StatusCodes(value={@ResponseCode(code=403, condition="User key in the path does is not the same as the logged user.")})
    public Response getOneTimePasswordStatus(final @PathParam(value="userKey") String userKey) {
        return new AbstractRestOTPResource.RestCommand(){

            @Override
            public Response doExecute() throws Exception {
                try {
                    ConfluenceUser loggedUser = AuthenticatedUserThreadLocal.get();
                    if (!OneTimePasswordResource.this.validator.isUserValid(loggedUser, userKey)) {
                        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)OneTimePasswordResource.this.validator.getJSONError()).build();
                    }
                    SigningTokenStatus signingTokenStatus = OneTimePasswordResource.this.eSignaturesService.getSigningTokenStatus(userKey);
                    return Response.ok().entity((Object)signingTokenStatus).type("application/json").build();
                }
                catch (AESEncryptionException e) {
                    log.error("Error parsing user OTP secret key, removing key for user: " + userKey, (Throwable)e);
                    OneTimePasswordResource.this.eSignaturesService.purgeTemporarySigningToken(userKey);
                    JSONObject error = new JSONObject();
                    error.put("status", Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
                    error.put("message", OneTimePasswordResource.this.comalaI18nBean.getText("comalatech.esignatures.signing.otp.error.encryption"));
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error.toString()).type("application/json").build();
                }
            }
        }.execute();
    }

    @PUT
    @Path(value="/create")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @StatusCodes(value={@ResponseCode(code=403, condition="User key in the path does is not the same as the logged user."), @ResponseCode(code=400, condition="The email provided is not the same as the logged one.")})
    public Response createSigningToken(final @PathParam(value="userKey") String userKey, final EmailSigningRequest emailSigningRequest) {
        return new AbstractRestOTPResource.RestCommand(){

            @Override
            public Response doExecute() throws Exception {
                ConfluenceUser loggedUser = AuthenticatedUserThreadLocal.get();
                if (!OneTimePasswordResource.this.validator.isUserValid(loggedUser, userKey)) {
                    return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)OneTimePasswordResource.this.validator.getJSONError()).build();
                }
                if (!OneTimePasswordResource.this.validator.isEmailValid(loggedUser, emailSigningRequest.getEmail())) {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)OneTimePasswordResource.this.validator.getJSONError()).build();
                }
                SigningTokenStatus signingTokenStatus = OneTimePasswordResource.this.eSignaturesService.getSigningTokenStatus(userKey);
                if (signingTokenStatus.getStatus() == SigningTokenStatus.Status.NONE && emailSigningRequest.isResend()) {
                    return Response.ok().entity((Object)signingTokenStatus).type("application/json").build();
                }
                OneTimePasswordResource.this.eSignaturesService.createSigningToken(userKey);
                signingTokenStatus = OneTimePasswordResource.this.eSignaturesService.getSigningTokenStatus(userKey);
                return Response.ok().entity((Object)signingTokenStatus).type("application/json").build();
            }
        }.execute();
    }

    @PUT
    @Path(value="/validate")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @StatusCodes(value={@ResponseCode(code=403, condition="User key in the path does is not the same as the logged user."), @ResponseCode(code=400, condition="Signing token is not valid")})
    public Response validateSigningToken(final @PathParam(value="userKey") String userKey, final TokenRequest tokenRequest) {
        return new AbstractRestOTPResource.RestCommand(){

            @Override
            public Response doExecute() throws Exception {
                try {
                    ConfluenceUser loggedUser = AuthenticatedUserThreadLocal.get();
                    if (!OneTimePasswordResource.this.validator.isUserValid(loggedUser, userKey)) {
                        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)OneTimePasswordResource.this.validator.getJSONError()).build();
                    }
                    SigningTokenStatus signingTokenStatus = OneTimePasswordResource.this.eSignaturesService.getSigningTokenStatus(userKey);
                    if (signingTokenStatus.getStatus() == SigningTokenStatus.Status.NONE) {
                        return Response.ok().entity((Object)signingTokenStatus).type("application/json").build();
                    }
                    SigningToken signingToken = OneTimePasswordResource.this.eSignaturesService.getSigningToken(userKey);
                    if (OneTimePasswordResource.this.validator.isTokenValid(signingToken.getSecretKey(), tokenRequest.getToken())) {
                        Long expiryTimestamp = signingToken.getExpiryTimestamp();
                        LocalDateTime time = Instant.ofEpochMilli(expiryTimestamp).atZone(ZoneOffset.UTC).toLocalDateTime();
                        LocalDateTime localDateTime = time.plusYears(1L);
                        signingToken.setExpiryTimestamp(localDateTime.atZone(ZoneOffset.UTC).toInstant().toEpochMilli());
                        OneTimePasswordResource.this.eSignaturesService.persistSigningToken(signingToken);
                        signingTokenStatus = OneTimePasswordResource.this.eSignaturesService.getSigningTokenStatus(userKey);
                        return Response.ok().entity((Object)signingTokenStatus).type("application/json").build();
                    }
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)OneTimePasswordResource.this.validator.getJSONError()).build();
                }
                catch (AESEncryptionException e) {
                    log.error("Error parsing user OTP secret key, removing key for user: " + userKey, (Throwable)e);
                    OneTimePasswordResource.this.eSignaturesService.purgeTemporarySigningToken(userKey);
                    JSONObject error = new JSONObject();
                    error.put("status", Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
                    error.put("message", OneTimePasswordResource.this.comalaI18nBean.getText("comalatech.esignatures.signing.otp.error.encryption"));
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error.toString()).type("application/json").build();
                }
            }
        }.execute();
    }
}

