/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.audit.action;

import com.atlassian.confluence.pages.actions.AbstractPaginatedListAction;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.user.User;
import com.comalatech.confluence.workflow.WorkflowConfigurationManager;
import com.comalatech.confluence.workflow.audit.model.AuditLegacyRecord;
import com.comalatech.confluence.workflow.audit.service.AuditService;
import java.util.List;

@WebSudoRequired
public class SpaceWorkflowsViewAuditLogAction
extends AbstractPaginatedListAction {
    private AuditService workflowAuditService;
    private WorkflowConfigurationManager workflowConfigurationManager;
    private UserAccessor userAccessor;
    private String docoUrl = "https://apps.appf.re/cdmdc/doco/spaceadminaudittools/Fc5vzf";

    public SpaceWorkflowsViewAuditLogAction() {
        super(100);
    }

    public List<AuditLegacyRecord> getItems() {
        return this.workflowAuditService.getLegacyRecords(this.getKey());
    }

    public boolean isPermitted() {
        return super.isPermitted() && this.permissionManager.hasPermission((User)this.getAuthenticatedUser(), Permission.ADMINISTER, (Object)this.getSpace());
    }

    public String getAuditLoggingStatusHtml() {
        Boolean auditLoggingEnabled = this.workflowConfigurationManager.isAuditLoggingEnabled();
        boolean enabled = auditLoggingEnabled == null ? false : auditLoggingEnabled;
        String css = enabled ? "aui-lozenge-success" : "";
        return String.format("<span class=\"aui-lozenge %s\">%s</span>", css, this.getText("approvalsworkflow.configuration.section.auditlog.enabled." + enabled));
    }

    public ConfluenceUser getUserByKey(String key) {
        return this.userAccessor.getUserByKey(new UserKey(key));
    }

    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    public void setWorkflowAuditService(AuditService workflowAuditService) {
        this.workflowAuditService = workflowAuditService;
    }

    public void setWorkflowConfigurationManager(WorkflowConfigurationManager workflowConfigurationManager) {
        this.workflowConfigurationManager = workflowConfigurationManager;
    }

    public String getDocoUrl() {
        return this.docoUrl;
    }
}

