/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.comalatech.confluence.adhoc.dao.ComalatechBandanaContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowAdvancedConfigurationManager {
    private static final Logger log = LoggerFactory.getLogger(WorkflowAdvancedConfigurationManager.class);
    private static final String CONFIG_CACHE_PRODUCTION_WORKFLOWS_KEY = "com.comalatech.workflow.cache.production.workflows";
    private static final String CONFIG_CACHE_GLOBAL_WORKFLOWS_KEY = "com.comalatech.workflow.cache.global.workflows";
    private static final String CONFIG_CACHE_GLOBAL_WORKFLOW_NAMES_KEY = "com.comalatech.workflow.cache.global.workflow.names";
    private static final String CONFIG_USER_SEARCH_MIN_CHARACTERS_KEY = "com.comalatech.workflow.user.search.min.characters";
    private static final String CONFIG_DATA_EXTRACTOR_BATCH_KEY = "com.comalatech.workflow.data.extractor.batch";
    private static final String CONFIG_EXPIRATION_JOB_BATCH_KEY = "com.comalatech.workflow.expiry.job.batch";
    private static final String CONFIG_MAX_HANDLED_USERS_KEY = "com.comalatech.workflow.max.handled.users";
    private static final String CONFIG_MAX_ALLOWED_APPROVERS_TO_SHOW_KEY = "com.comalatech.workflow.max.allowed.approvers.showed";
    private static final String CONFIG_SEARCH_LIMIT_KEY = "com.comalatech.workflow.search.limit";
    private static final int DEFAULT_CACHE_PRODUCTION_WORKFLOWS = 500;
    private static final int DEFAULT_CACHE_GLOBAL_WORKFLOWS = 50;
    private static final int DEFAULT_CACHE_GLOBAL_WORKFLOW_NAMES = 50;
    private static final int DEFAULT_USER_SEARCH_MIN_CHARACTERS = 2;
    private static final int DEFAULT_DATA_EXTRACTOR_BATCH_KEY = 100;
    private static final int DEFAULT_EXPIRATION_JOB_BATCH_KEY = 100;
    private static final int DEFAULT_MAX_HANDLED_USERS_KEY = 500;
    private static final int DEFAULT_MAX_ALLOWED_APPROVERS_TO_SHOW_KEY = 15;
    private static boolean userSearchMinQueryPropChecked = false;
    private static final String CONFIG_USER_SEARCH_MIN_CHARACTERS_SYS_PROP_SET = "com.comalatech.workflow.user.search.min.characters.sysprop.set";
    private static final int DEFAULT_SEARCH_LIMIT = 10;
    private static final int MAX_SEARCH_LIMIT = 500;
    private final BandanaManager bandanaManager;
    private final BandanaContext bandanaContext = ComalatechBandanaContext.COMALATECH_CONTEXT;

    public WorkflowAdvancedConfigurationManager(BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
    }

    public int getCacheProductionWorkflows() {
        return this.getIntegerValue(CONFIG_CACHE_PRODUCTION_WORKFLOWS_KEY, 500);
    }

    private int getIntegerValue(String key, int defaultValue) {
        Integer value = (Integer)this.bandanaManager.getValue(this.bandanaContext, key);
        return value != null ? value : defaultValue;
    }

    public void setCacheProductionWorkflows(int cacheProductionWorkflows) {
        this.setConfigProperty(CONFIG_CACHE_PRODUCTION_WORKFLOWS_KEY, cacheProductionWorkflows);
    }

    private void setConfigProperty(String key, int value) {
        this.bandanaManager.setValue(this.bandanaContext, key, (Object)value);
        if (log.isDebugEnabled()) {
            log.debug("'{}' saved: {}", (Object)key, (Object)value);
        }
    }

    public int getCacheGlobalWorkflows() {
        return this.getIntegerValue(CONFIG_CACHE_GLOBAL_WORKFLOWS_KEY, 50);
    }

    public void setCacheGlobalWorkflows(int cacheGlobalWorkflows) {
        this.setConfigProperty(CONFIG_CACHE_GLOBAL_WORKFLOWS_KEY, cacheGlobalWorkflows);
    }

    public int getCacheGlobalWorkflowNames() {
        return this.getIntegerValue(CONFIG_CACHE_GLOBAL_WORKFLOW_NAMES_KEY, 50);
    }

    public void setCacheGlobalWorkflowNames(int cacheGlobalWorkflowNames) {
        this.setConfigProperty(CONFIG_CACHE_GLOBAL_WORKFLOW_NAMES_KEY, cacheGlobalWorkflowNames);
    }

    public int getUserSearchMinCharacters() {
        Integer userSearchMinCharacters;
        if (!userSearchMinQueryPropChecked && !this.getMinQuerySysPropChecked()) {
            String MIN_QUERY_SYS_PROP = "comalatech.workflow.approval.minquery";
            if (System.getProperty("comalatech.workflow.approval.minquery") != null) {
                try {
                    String queryMinSysPropVal = System.getProperty("comalatech.workflow.approval.minquery");
                    if (log.isDebugEnabled()) {
                        log.debug("Minimum query length system property value is: " + (queryMinSysPropVal != null ? queryMinSysPropVal : "null"));
                    }
                    this.setUserSearchMinCharacters(Integer.parseInt(queryMinSysPropVal));
                }
                catch (NumberFormatException nfe) {
                    log.error("Error parsing comalatech.workflow.approval.minquery property.", (Throwable)nfe);
                }
            }
            this.setMinQuerySysPropChecked();
        }
        return (userSearchMinCharacters = (Integer)this.bandanaManager.getValue(this.bandanaContext, CONFIG_USER_SEARCH_MIN_CHARACTERS_KEY)) != null && userSearchMinCharacters > 2 ? userSearchMinCharacters : 2;
    }

    public void setUserSearchMinCharacters(int userSearchMinCharacters) {
        this.setConfigProperty(CONFIG_USER_SEARCH_MIN_CHARACTERS_KEY, userSearchMinCharacters);
    }

    public int getDataExtractorBatchSize() {
        return this.getIntegerValue(CONFIG_DATA_EXTRACTOR_BATCH_KEY, 100);
    }

    public int getExpirationJobBatchSize() {
        return this.getIntegerValue(CONFIG_EXPIRATION_JOB_BATCH_KEY, 100);
    }

    public void setDataExtractorBatchSize(int dataExtractorBatchSize) {
        this.setConfigProperty(CONFIG_DATA_EXTRACTOR_BATCH_KEY, dataExtractorBatchSize);
    }

    public void setExpirationJobBatchSize(int expirationJobBatchSize) {
        this.setConfigProperty(CONFIG_EXPIRATION_JOB_BATCH_KEY, expirationJobBatchSize);
    }

    public int getMaxHandledUsers() {
        return this.getIntegerValue(CONFIG_MAX_HANDLED_USERS_KEY, 500);
    }

    public void setMaxHandledUsers(int maxHandledUsers) {
        this.setConfigProperty(CONFIG_MAX_HANDLED_USERS_KEY, maxHandledUsers);
    }

    public int getMaxAllowedApproversToShow() {
        return this.getIntegerValue(CONFIG_MAX_ALLOWED_APPROVERS_TO_SHOW_KEY, 15);
    }

    public void setMaxAllowedApproversToShow(int maxAllowedApproversToShow) {
        this.setConfigProperty(CONFIG_MAX_ALLOWED_APPROVERS_TO_SHOW_KEY, maxAllowedApproversToShow);
    }

    private boolean getMinQuerySysPropChecked() {
        Object obj = this.bandanaManager.getValue(this.bandanaContext, CONFIG_USER_SEARCH_MIN_CHARACTERS_SYS_PROP_SET);
        return null != obj && (Boolean)obj != false;
    }

    private void setMinQuerySysPropChecked() {
        this.bandanaManager.setValue(this.bandanaContext, CONFIG_USER_SEARCH_MIN_CHARACTERS_SYS_PROP_SET, (Object)true);
        userSearchMinQueryPropChecked = true;
    }

    public int getSearchLimit() {
        return this.getIntegerValue(CONFIG_SEARCH_LIMIT_KEY, 10);
    }

    public void setSearchLimit(int searchLimit) {
        this.setConfigProperty(CONFIG_SEARCH_LIMIT_KEY, searchLimit);
    }

    public int getMaxSearchLimit() {
        return 500;
    }
}

