/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.comalatech.confluence.util.PluginContainerManager;
import java.util.Arrays;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ValueReferenceModifier {
    WIKI_LINK("wiki-link"),
    FULLNAME("fullname");

    private static final Logger log;
    private String modifier;
    private Pattern pattern;
    private static UserAccessor userAccessor;

    private ValueReferenceModifier(String modifier) {
        this.modifier = modifier;
        this.pattern = Pattern.compile(".+>\\s*(" + modifier + ")\\s*@$");
    }

    public String getModifier() {
        return this.modifier;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public String toString() {
        return this.modifier;
    }

    public String modify(String valueReference) {
        Function<String, String> converter = null;
        if (this.equals((Object)WIKI_LINK)) {
            converter = userName -> "[~" + userName.trim() + "]";
        } else if (this.equals((Object)FULLNAME)) {
            converter = userName -> this.getUserFullNameSafe(userName.trim());
        }
        if (converter != null) {
            return Arrays.stream(StringUtils.split((String)valueReference, (String)",")).map(converter).collect(Collectors.joining(", "));
        }
        return valueReference;
    }

    @Nullable
    public static ValueReferenceModifier extractValueReferenceModifier(String valueReference) {
        for (ValueReferenceModifier valueReferenceModifier : ValueReferenceModifier.values()) {
            Matcher matcher = valueReferenceModifier.pattern.matcher(valueReference.trim());
            if (!matcher.find()) continue;
            return valueReferenceModifier;
        }
        return null;
    }

    public static String removeValueReferenceModifier(String valueReference, ValueReferenceModifier valueReferenceModifier) {
        if (valueReferenceModifier != null) {
            return StringUtils.removePattern((String)valueReference, (String)("\\s*>\\s*" + valueReferenceModifier.getModifier() + "\\s*@$")).trim() + "@";
        }
        return valueReference;
    }

    private String getUserFullNameSafe(String userName) {
        ConfluenceUser user = ValueReferenceModifier.getUserAccessor().getUserByName(userName);
        if (user != null) {
            return user.getFullName();
        }
        log.error("unable to retrieve full name for user: " + userName + ". The user does not exist.");
        return "";
    }

    private static UserAccessor getUserAccessor() {
        return PluginContainerManager.getComponent("userAccessor", UserAccessor.class);
    }

    static {
        log = LoggerFactory.getLogger(ValueReferenceModifier.class);
    }
}

