/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.Namespace;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.ConfluenceUserImpl;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.WikiStyleRenderer;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.user.User;
import com.comalatech.confluence.adhoc.dao.BandanaKeysDao;
import com.comalatech.confluence.ipc.ValueAccessor;
import com.comalatech.confluence.ipc.supplier.SupplierAssistantAccessor;
import com.comalatech.confluence.ipc.supplier.SupplierAssistantHolder;
import com.comalatech.confluence.metadata.communardo.MetadataManagerAccessor;
import com.comalatech.confluence.metadata.communardo.MetadataManagerHolder;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.states.model.State;
import com.comalatech.confluence.states.model.StateSelection;
import com.comalatech.confluence.timers.TimerUtils;
import com.comalatech.confluence.workflow.InternalWorkflowParameterManager;
import com.comalatech.confluence.workflow.PageWorkflows;
import com.comalatech.confluence.workflow.StateSelectionManager;
import com.comalatech.confluence.workflow.UsersListResolver;
import com.comalatech.confluence.workflow.ValueStore;
import com.comalatech.confluence.workflow.ValueStoreManager;
import com.comalatech.confluence.workflow.Workflow;
import com.comalatech.confluence.workflow.WorkflowAccessor;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.WorkflowUserException;
import com.comalatech.confluence.workflow.events.WorkflowPageParameterUpdatedEventImpl;
import com.comalatech.confluence.workflow.events.admin.SpaceWorkflowParameterAddedEventImpl;
import com.comalatech.confluence.workflow.events.admin.SpaceWorkflowParameterRemovedEventImpl;
import com.comalatech.confluence.workflow.events.admin.SpaceWorkflowParameterUpdatedEventImpl;
import com.comalatech.confluence.workflow.model.PageWorkflowParameter;
import com.comalatech.confluence.workflow.model.PageWorkflowParameters;
import com.comalatech.confluence.workflow.model.WorkflowParameter;
import com.comalatech.workflow.model.Workflow;
import com.comalatech.workflow.model.WorkflowParameterType;
import com.communardo.confluence.metadata.DataObject;
import com.communardo.confluence.metadata.MetadataField;
import com.communardo.confluence.metadata.MetadataSet;
import com.communardo.confluence.metadata.service.MetadataManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.randombits.confluence.supplier.SupplierAssistant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class DefaultWorkflowParameterManager
implements InternalWorkflowParameterManager,
ApplicationContextAware,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(DefaultWorkflowParameterManager.class);
    public static final String PARAMETER_TYPE_PREFIX = "com.comalatech.workflow.parameters.type.";
    public static final String PARAMETER_VALUE_PREFIX = "com.comalatech.workflow.parameters.value.";
    public static final String PARAMETER_DESCRIPTION_PREFIX = "com.comalatech.workflow.parameters.description.";
    public static final String PARAMETER_OPTIONS_PREFIX = "com.comalatech.workflow.parameters.options.";
    private static final String POSTER = "poster";
    private static final String POSTED = "posted";
    private static final String CREATED = "created";
    private static final String LAST_MODIFICATION = "modification";
    private static final String LAST_MODIFIER = "modifier";
    private static final String PAGE = "page";
    private static final String PARENT = "parent";
    private static final String SPACE = "space";
    private static final String TITLE = "title";
    private static final String VERSION = "version";
    private static final String LABELS = "labels";
    private static final String ID = "id";
    private static final String CREATOR = "creator";
    private static final String AUTHOR = "author";
    private static final String MODIFIER = "modifier";
    private static final String USER = "user";
    private static final String[] PAGE_REFERENCES = new String[]{"@poster@", "@posted@", "@created@", "@modification@", "@modifier@", "@page@", "@parent@", "@space@", "@title@", "@version@", "@labels@", "@id@", "@creator@", "@author@", "@modifier@", "@user@"};
    protected static final String COMMUNARDO_USERFIELD_NAME = "USER";
    protected static final String COMMUNARDO_LINKFIELD_NAME = "LINK";
    private ApplicationContext applicationContext;
    private final BandanaManager bandanaManager;
    private final BandanaKeysDao bandanaKeysDao;
    private final ValueAccessor workflowValueAccessor;
    private final ValueStoreManager valueStoreManager;
    private final UsersListResolver usersListResolver;
    private final WikiStyleRenderer wikiStyleRenderer;
    private final SupplierAssistantAccessor supplierAssistantAccessor;
    private final SpaceManager spaceManager;
    private final EventPublisher eventPublisher;
    private final MetadataManagerAccessor metadataManagerAccessor;
    private WorkflowAccessor workflowAccessor;
    private final StateSelectionManager stateSelectionManager;

    public DefaultWorkflowParameterManager(BandanaManager bandanaManager, @Qualifier(value="bandanaKeysDao") BandanaKeysDao bandanaKeysDao, ValueAccessor workflowValueAccessor, ValueStoreManager valueStoreManager, UsersListResolver usersListResolver, WikiStyleRenderer wikiStyleRenderer, SupplierAssistantAccessor supplierAssistantAccessor, SpaceManager spaceManager, EventPublisher eventPublisher, MetadataManagerAccessor metadataManagerAccessor, StateSelectionManager stateSelectionManager) {
        this.bandanaManager = bandanaManager;
        this.bandanaKeysDao = bandanaKeysDao;
        this.workflowValueAccessor = workflowValueAccessor;
        this.valueStoreManager = valueStoreManager;
        this.usersListResolver = usersListResolver;
        this.wikiStyleRenderer = wikiStyleRenderer;
        this.supplierAssistantAccessor = supplierAssistantAccessor;
        this.spaceManager = spaceManager;
        this.eventPublisher = eventPublisher;
        this.metadataManagerAccessor = metadataManagerAccessor;
        this.stateSelectionManager = stateSelectionManager;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        this.workflowAccessor = (WorkflowAccessor)this.applicationContext.getBean("workflowAccessor", WorkflowAccessor.class);
    }

    private void setValue(String spaceKey, String prefix, String name, String value) {
        this.bandanaManager.setValue((BandanaContext)new ConfluenceBandanaContext(spaceKey), prefix + name, (Object)value);
    }

    private String getValue(String spaceKey, String prefix, String name) {
        return (String)this.bandanaManager.getValue((BandanaContext)new ConfluenceBandanaContext(spaceKey), prefix + name);
    }

    @Override
    public void registerWorkflowParameters(String spaceKey, List<com.comalatech.workflow.model.WorkflowParameter> workflowParameters) {
        for (com.comalatech.workflow.model.WorkflowParameter workflowParameter : workflowParameters) {
            this.registerWorkflowParameter(spaceKey, workflowParameter);
        }
    }

    @Override
    public void registerWorkflowParameter(String spaceKey, com.comalatech.workflow.model.WorkflowParameter workflowParameter) {
        if (!StringUtils.isNotBlank((CharSequence)spaceKey)) {
            return;
        }
        WorkflowParameterType currentType = this.getType(spaceKey, workflowParameter);
        String value = this.getSpaceOrGlobalValue(spaceKey, workflowParameter.getName());
        if (workflowParameter.getType() != currentType || value == null) {
            String resolvedValue = this.isPageReference(workflowParameter) ? workflowParameter.getValue() : this.valueStoreManager.createValueStore((AbstractPage)new Page()).replaceReferences(workflowParameter.getValue());
            this.setValue(spaceKey, PARAMETER_VALUE_PREFIX, workflowParameter.getName(), resolvedValue);
            this.setValue(spaceKey, PARAMETER_TYPE_PREFIX, workflowParameter.getName(), workflowParameter.getType().getName());
            if (WorkflowParameterType.LIST.equals((Object)workflowParameter.getType())) {
                String optionsList = StringUtils.join(workflowParameter.getOptions(), (String)",");
                this.setValue(spaceKey, PARAMETER_OPTIONS_PREFIX, workflowParameter.getName(), optionsList);
            }
        }
        this.setValue(spaceKey, PARAMETER_DESCRIPTION_PREFIX, workflowParameter.getName(), workflowParameter.getDescription());
        Space space = this.spaceManager.getSpace(spaceKey);
        SpaceWorkflowParameterAddedEventImpl event = new SpaceWorkflowParameterAddedEventImpl(space, workflowParameter);
        this.eventPublisher.publish((Object)event);
    }

    @Override
    public void unRegisterWorkflowParameter(String spaceKey, com.comalatech.workflow.model.WorkflowParameter workflowParameter) {
        this.setValue(spaceKey, PARAMETER_VALUE_PREFIX, workflowParameter.getName(), null);
        this.setValue(spaceKey, PARAMETER_TYPE_PREFIX, workflowParameter.getName(), null);
        this.setValue(spaceKey, PARAMETER_DESCRIPTION_PREFIX, workflowParameter.getName(), null);
        Space space = this.spaceManager.getSpace(spaceKey);
        SpaceWorkflowParameterRemovedEventImpl event = new SpaceWorkflowParameterRemovedEventImpl(space, workflowParameter);
        this.eventPublisher.publish((Object)event);
    }

    @Override
    public String getSpaceOrGlobalValue(String spaceKey, String name) {
        String value = this.getValue(spaceKey, PARAMETER_VALUE_PREFIX, name);
        if (!StringUtils.isNotBlank((CharSequence)value) && spaceKey != null) {
            value = this.getValue(null, PARAMETER_VALUE_PREFIX, name);
        }
        return value;
    }

    @Override
    public Object getSupplierValue(AbstractPage page, String reference) {
        return this.getSupplierValue(page, reference, false);
    }

    private Object getSupplierValue(AbstractPage page, String reference, boolean render) {
        try {
            SupplierAssistant supplierAssistant;
            SupplierAssistantHolder holder = this.supplierAssistantAccessor.getSupplierAssistant();
            if (holder != null) {
                supplierAssistant = (com.servicerocket.confluence.randombits.supplier.core.SupplierAssistant)holder.getSupplierAssistant();
                if (supplierAssistant == null) {
                    log.warn("SupplierAssistant is null (although SuppAssistantHolder is valid");
                } else {
                    return supplierAssistant.findValue(supplierAssistant.createContext(page), reference);
                }
            }
            if ((supplierAssistant = SupplierAssistant.getInstance()) == null) {
                log.error("SupplierAssistant is null. Check if Reporting For Confluence is correctly installed and enabled");
                return null;
            }
            return supplierAssistant.findValue(page, reference, render);
        }
        catch (Exception e) {
            log.error("Error getting Supplier value: '" + reference + "' for workflow on page: " + page, (Throwable)e);
            return null;
        }
    }

    @Override
    public String getSupplierValueAsString(AbstractPage page, String reference) {
        Object value = this.getSupplierValue(page, reference);
        List<String> stringValues = this.getSupplierValueAsString(value);
        return stringValues == null ? null : StringUtils.join(stringValues, (char)',');
    }

    private List<String> getSupplierValueAsString(Object value) {
        ArrayList<String> stringList = new ArrayList<String>();
        if (value == null) {
            stringList = null;
        } else if (value instanceof AbstractPage) {
            stringList.add(((AbstractPage)value).getTitle());
        } else if (value instanceof Date) {
            stringList.add(TimerUtils.dateToString((Date)value));
        } else if (value instanceof ConfluenceUser) {
            stringList.add(((ConfluenceUser)value).getName());
        } else if (value instanceof Space) {
            stringList.add(((Space)value).getKey());
        } else if (value instanceof Collection) {
            for (Object anElement : (Collection)value) {
                List<String> innerStringList = this.getSupplierValueAsString(anElement);
                if (innerStringList == null) continue;
                stringList.addAll(innerStringList);
            }
        } else {
            stringList.add(value.toString());
        }
        return stringList;
    }

    private boolean isPageReference(com.comalatech.workflow.model.WorkflowParameter workflowParameter) {
        String val = workflowParameter.getValue();
        boolean parameterContainsPageReference = Arrays.stream(PAGE_REFERENCES).anyMatch(val::contains);
        boolean parameterContainsSupplierReference = val.contains("@") && val.contains(":") && val.contains(">");
        return parameterContainsSupplierReference || parameterContainsPageReference;
    }

    private void validateValue(com.comalatech.workflow.model.WorkflowParameter workflowParameter) throws WorkflowException {
        ValueStore resolver = this.valueStoreManager.createValueStore((AbstractPage)new Page());
        if (workflowParameter.getType() == WorkflowParameterType.USER) {
            this.usersListResolver.validateReference(resolver, workflowParameter.getValue(), true, false);
        } else if (workflowParameter.getType() == WorkflowParameterType.GROUP) {
            this.usersListResolver.validateReference(resolver, workflowParameter.getValue(), false, true);
        } else if (workflowParameter.getType() == WorkflowParameterType.USERORGROUP) {
            this.usersListResolver.validateReference(resolver, workflowParameter.getValue(), true, true);
        } else if (workflowParameter.getType() == WorkflowParameterType.DURATION) {
            try {
                TimerUtils.parsePeriod(workflowParameter.getValue());
            }
            catch (Exception e) {
                throw new WorkflowUserException("comalatech.awp.container.workflowparameters.error.invalidperiod", workflowParameter.getValue());
            }
        }
    }

    private WorkflowParameterType getType(String spaceKey, com.comalatech.workflow.model.WorkflowParameter workflowParameter) {
        String typeName = this.getValue(spaceKey, PARAMETER_TYPE_PREFIX, workflowParameter.getName());
        if (!StringUtils.isNotBlank((CharSequence)typeName)) {
            return null;
        }
        return WorkflowParameterType.parse(typeName);
    }

    @Override
    public List<com.comalatech.workflow.model.WorkflowParameter> getSpaceWorkflowsParameters(String spaceKey) {
        return this.getSpaceWorkflowsParameters(spaceKey, false);
    }

    @Override
    public List<com.comalatech.workflow.model.WorkflowParameter> getSpaceWorkflowsParameters(String spaceKey, boolean showParamsWithEmptyValues) {
        ArrayList<com.comalatech.workflow.model.WorkflowParameter> parameters = new ArrayList<com.comalatech.workflow.model.WorkflowParameter>();
        for (String key : this.bandanaKeysDao.getKeys(spaceKey, PARAMETER_VALUE_PREFIX)) {
            String name = key.substring(PARAMETER_VALUE_PREFIX.length());
            String value = this.getValue(spaceKey, PARAMETER_VALUE_PREFIX, name);
            if (!StringUtils.isNotBlank((CharSequence)value) && !showParamsWithEmptyValues) continue;
            String typeName = this.getValue(spaceKey, PARAMETER_TYPE_PREFIX, name);
            String description = this.getValue(spaceKey, PARAMETER_DESCRIPTION_PREFIX, name);
            String optionsList = this.getValue(spaceKey, PARAMETER_OPTIONS_PREFIX, name);
            parameters.add(new WorkflowParameter(name, description, WorkflowParameterType.parse(typeName), value, optionsList, false));
        }
        return parameters;
    }

    @Override
    public com.comalatech.workflow.model.WorkflowParameter getSpaceWorkflowParameter(String spaceKey, String parameterName) {
        return this.getParameter(spaceKey, parameterName);
    }

    @Override
    public void setSpaceWorkflowParameter(String spaceKey, com.comalatech.workflow.model.WorkflowParameter workflowParameter) throws com.comalatech.workflow.WorkflowException {
        WorkflowParameter oldParameter = this.getParameter(spaceKey, workflowParameter.getName());
        this.validateValue(workflowParameter);
        this.setValue(spaceKey, PARAMETER_VALUE_PREFIX, workflowParameter.getName(), workflowParameter.getValue());
        Space space = this.spaceManager.getSpace(spaceKey);
        SpaceWorkflowParameterUpdatedEventImpl event = new SpaceWorkflowParameterUpdatedEventImpl(space, oldParameter, workflowParameter);
        this.eventPublisher.publish((Object)event);
    }

    private PageWorkflowParameter getPageWorkflowParameterInternal(AbstractPage page, com.comalatech.workflow.model.WorkflowParameter workflowParam) {
        boolean isDefault;
        WorkflowParameter workflowParameter = (WorkflowParameter)workflowParam;
        String value = this.getParameterValue(page, workflowParameter.getName(), false);
        if (!StringUtils.isNotBlank((CharSequence)value)) {
            isDefault = true;
            value = this.getParameterValue(page, workflowParameter.getName(), true);
            if (!StringUtils.isNotBlank((CharSequence)value)) {
                value = workflowParameter.getValue();
            }
        } else {
            isDefault = false;
        }
        if (workflowParameter.getOptionsListReference() != null) {
            return new PageWorkflowParameter(workflowParameter, value, this.getSpaceOrGlobalValue(page.getSpaceKey(), workflowParameter.getOptionsListReference()), isDefault);
        }
        return new PageWorkflowParameter(workflowParameter, value, isDefault);
    }

    @Override
    public com.comalatech.workflow.model.PageWorkflowParameter getPageWorkflowParameter(AbstractPage page, String workflowParameterName) {
        WorkflowParameter returnWorkflowParameter;
        boolean isDefault;
        String value = this.getParameterValue(page, workflowParameterName, false);
        if (!StringUtils.isNotBlank((CharSequence)value)) {
            isDefault = true;
            value = this.getParameterValue(page, workflowParameterName, true);
            if (!StringUtils.isNotBlank((CharSequence)value)) {
                return null;
            }
        } else {
            isDefault = false;
        }
        if ((returnWorkflowParameter = (WorkflowParameter)this.getSpaceWorkflowParameter(page.getSpaceKey(), workflowParameterName)) != null) {
            return new PageWorkflowParameter(returnWorkflowParameter, value, returnWorkflowParameter.getOptionsListReference() != null ? this.getSpaceOrGlobalValue(page.getSpaceKey(), returnWorkflowParameter.getOptionsListReference()) : null, isDefault);
        }
        return null;
    }

    @Override
    public void setPageWorkflowParameterValue(AbstractPage page, com.comalatech.workflow.model.WorkflowParameter workflowParameter) throws WorkflowException {
        if (!workflowParameter.isPageEditable()) {
            return;
        }
        this.validateValue(workflowParameter);
        this.workflowValueAccessor.setValue(page, workflowParameter.getName(), workflowParameter.getValue());
        PageState state = this.workflowAccessor.getPageWorkflows(page).getValueStore().getPageState();
        WorkflowPageParameterUpdatedEventImpl updateEvent = new WorkflowPageParameterUpdatedEventImpl(page, page, state, workflowParameter);
        if (log.isDebugEnabled()) {
            log.debug("publishing page parameter updated event: " + updateEvent);
        }
        this.eventPublisher.publish((Object)updateEvent);
    }

    @Override
    public void cleanPageWorkflowParameterValue(AbstractPage page, com.comalatech.workflow.model.WorkflowParameter workflowParameter) {
        this.workflowValueAccessor.removeValue(page, workflowParameter.getName());
        if (log.isDebugEnabled()) {
            log.debug("Page Workflow Parameter (param name: " + workflowParameter.getName() + ") value cleared from page " + page.getId());
        }
    }

    @Override
    public String getParameterValue(AbstractPage page, String name) {
        return this.getParameterValue(page, name, true);
    }

    private String getParameterValue(AbstractPage page, String name, boolean lookup) {
        return this.getParameterValue(0, page, name, lookup);
    }

    private String getParameterValue(int loopIterations, AbstractPage page, String name, boolean lookup) {
        if (page == null) {
            return this.getSpaceOrGlobalValue(null, name);
        }
        String value = this.getMetadataValue(page, name, loopIterations);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return value;
        }
        value = this.getCommunardoMetaReference(page, name);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return value;
        }
        if (lookup) {
            value = this.getSpaceOrGlobalValue(page.getSpaceKey(), name);
        }
        if (value != null && value.startsWith("@")) {
            Object supplierValue;
            String pageRefValue = this.getPageRefNameValue(value = value.replaceAll("@", ""), page);
            value = pageRefValue == null ? ((supplierValue = this.getSupplierValue(page, value)) == null ? null : supplierValue.toString()) : pageRefValue;
        } else if (value == null && (value = this.getPageRefNameValue(name, page)) == null) {
            ArrayList<String> supplierValue = this.getSupplierValue(page, name);
            if (supplierValue != null && supplierValue.getClass().equals(ArrayList.class)) {
                List values = supplierValue;
                ArrayList<String> outcome = new ArrayList<String>();
                for (Object o : values) {
                    if (o.getClass() == ConfluenceUserImpl.class) {
                        outcome.add(((ConfluenceUserImpl)o).getName());
                        continue;
                    }
                    outcome.add((String)o);
                }
                supplierValue = outcome;
            }
            String string = value = supplierValue == null ? null : ((Object)supplierValue).toString();
        }
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return value;
        }
        return "";
    }

    private String getPageRefNameValue(String name, AbstractPage page) {
        if (CREATOR.equals(name) || POSTER.equals(name) || AUTHOR.equals(name)) {
            return page.getCreator() != null ? page.getCreator().getName() : null;
        }
        if ("modifier".equals(name)) {
            return page.getLastModifier() != null ? page.getLastModifier().getName() : null;
        }
        if (USER.equals(name)) {
            return AuthenticatedUserThreadLocal.getUsername();
        }
        if (LAST_MODIFICATION.equals(name)) {
            return TimerUtils.parseDateWithConfluenceDateFormat(page.getLastModificationDate());
        }
        if (PAGE.equals(name)) {
            ValueStore resolver = this.valueStoreManager.createValueStore(page);
            return resolver.getPropertiesMap().getOrDefault(PAGE, page.getLinkWikiMarkup());
        }
        if (PARENT.equals(name)) {
            if (page instanceof Page) {
                Page parentPage = ((Page)page).getParent();
                return parentPage != null ? parentPage.getLinkWikiMarkup() : null;
            }
            return null;
        }
        if (CREATED.equals(name) || POSTED.equals(name)) {
            return TimerUtils.parseDateWithConfluenceDateFormat(page.getCreationDate());
        }
        if (SPACE.equals(name)) {
            return page.getSpace().getName();
        }
        if (TITLE.equals(name)) {
            return page.getTitle();
        }
        if (VERSION.equals(name)) {
            return Integer.toString(page.getVersion());
        }
        if (LABELS.equals(name)) {
            return page.getLabelsForDisplay((User)AuthenticatedUserThreadLocal.get()).stream().filter(label -> !Namespace.isPersonal((Label)label)).map(Label::toString).collect(Collectors.joining(","));
        }
        if (ID.equals(name)) {
            return Long.toString(page.getId());
        }
        return null;
    }

    public String getCommunardoMetaReference(AbstractPage page, String reference) {
        try {
            if (this.isCommunardoMetadataAvailable()) {
                MetadataManager metadataManager;
                if (log.isDebugEnabled()) {
                    log.debug("communardo metada search for reference: " + reference + "  on page: " + page);
                }
                if ((metadataManager = (MetadataManager)this.getMetadataManagerHolder().getMetadataManager()) != null) {
                    List metaSets = metadataManager.loadContentMetadataSets((ContentEntityObject)page);
                    for (MetadataSet metadataSet : metaSets) {
                        List metaFields = metadataSet.getMetadataFields();
                        for (MetadataField metadataField : metaFields) {
                            if (log.isTraceEnabled()) {
                                log.trace("found metaField key: " + metadataField.getKey() + "  fieldType: " + metadataField.getType().getName());
                            }
                            if (!reference.equals(metadataField.getKey())) continue;
                            String metaValue = null;
                            String typeName = metadataField.getType().getName();
                            if (COMMUNARDO_USERFIELD_NAME.equals(typeName) || COMMUNARDO_LINKFIELD_NAME.equals(typeName)) {
                                Collection userNames = metadataField.getType().getSearchIndexValue((ContentEntityObject)page);
                                metaValue = StringUtils.join((Iterable)userNames, (char)',');
                            } else {
                                DataObject dataObject = metadataManager.loadContentMetadataValue((ContentEntityObject)page, metadataField);
                                if (dataObject != null) {
                                    metaValue = metadataField.getType().renderData(dataObject, (ContentEntityObject)page);
                                }
                            }
                            if (log.isDebugEnabled()) {
                                log.debug("matched key, metadata value: " + metaValue);
                            }
                            return metaValue;
                        }
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("did not find metadata match for reference: " + reference + " on page: " + page);
                    }
                }
                return null;
            }
        }
        catch (Exception e) {
            log.error("Error getting Communardo Metadata value: " + reference + " for workflow on page: " + page, (Throwable)e);
        }
        return null;
    }

    protected MetadataManagerHolder getMetadataManagerHolder() {
        return this.metadataManagerAccessor.getMetadataManager();
    }

    protected boolean isCommunardoMetadataAvailable() {
        return this.getMetadataManagerHolder() != null;
    }

    @Override
    public String getRenderedParameter(AbstractPage page, String name, RenderContext renderContext) {
        return this.getRenderedParameter(page, name, renderContext, 0);
    }

    @Override
    public String getRenderedParameter(AbstractPage page, String name, RenderContext renderContext, int loopIterations) {
        if (name.indexOf(">") > 0 || name.indexOf(":") > 0) {
            return this.getRenderedSupplierValue(page, name);
        }
        return this.getRenderedParameterValue(page, name, renderContext, loopIterations);
    }

    private String getRenderedParameterValue(AbstractPage page, String name, RenderContext renderContext, int loopIterations) {
        WorkflowParameter parameter = this.getParameter(page.getSpaceKey(), name);
        if (parameter == null) {
            parameter = new WorkflowParameter(name, null, WorkflowParameterType.DEFAULT, null, null, false);
        }
        String value = this.getParameterValue(loopIterations, page, name, true);
        return this.getRenderedValue(parameter, value, renderContext);
    }

    private String getRenderedSupplierValue(AbstractPage page, String name) {
        Object value = this.getSupplierValue(page, name, true);
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    private String getRenderedValue(WorkflowParameter parameter, String value, RenderContext renderContext) {
        String wiki = WorkflowParameterType.USER.equals((Object)parameter.getType()) ? "[~" + value + "]" : value;
        renderContext.pushRenderMode(renderContext.getRenderMode().and(RenderMode.suppress((long)256L)));
        String rendered = this.wikiStyleRenderer.convertWikiToXHtml(renderContext, wiki);
        renderContext.popRenderMode();
        return rendered;
    }

    public WorkflowParameter getParameter(String spaceKey, String name) {
        String typeName = this.getValue(spaceKey, PARAMETER_TYPE_PREFIX, name);
        if (typeName == null) {
            return null;
        }
        return new WorkflowParameter(name, this.getValue(spaceKey, PARAMETER_DESCRIPTION_PREFIX, name), WorkflowParameterType.parse(typeName), this.getValue(spaceKey, PARAMETER_VALUE_PREFIX, name), this.getValue(spaceKey, PARAMETER_OPTIONS_PREFIX, name), false);
    }

    @Override
    public List<ConfluenceUser> getValueAsUsers(AbstractPage page, String value) {
        String resolvedValue;
        if (page == null || value == null) {
            return Collections.emptyList();
        }
        if (value.startsWith("@")) {
            if ((value = value.substring(1)).endsWith("@")) {
                value = value.substring(0, value.lastIndexOf("@"));
            }
            resolvedValue = this.getParameterValue(page, value);
        } else {
            resolvedValue = value;
        }
        if (!StringUtils.isNotBlank((CharSequence)resolvedValue)) {
            return Collections.emptyList();
        }
        try {
            return Arrays.asList(this.usersListResolver.getValueAsUsers(null, page, resolvedValue));
        }
        catch (WorkflowException e) {
            log.error("Error getting value as users: " + value + " on page: " + page, (Throwable)e);
            return Collections.emptyList();
        }
    }

    @Override
    public boolean hasParametersForTransition(AbstractPage page) {
        PageWorkflows pageWorkflows = this.workflowAccessor.getPageWorkflows(page);
        if (pageWorkflows == null || pageWorkflows.getStatesContainer() == null) {
            return false;
        }
        for (State state : pageWorkflows.getStatesContainer().getStates()) {
            if (!StringUtils.isNotEmpty((CharSequence)state.getRequiredParams())) continue;
            return true;
        }
        return false;
    }

    private com.comalatech.workflow.model.PageWorkflowParameter getWorkflowParameter(AbstractPage page, String paramName) {
        PageWorkflows pageWorkflows = this.workflowAccessor.getPageWorkflows(page);
        PageWorkflowParameters pageWorkflowParameters = this.getPageWorkflowParameters(pageWorkflows);
        return pageWorkflowParameters.stream().filter(param -> param.getName().equals(paramName)).findFirst().orElse(null);
    }

    @Override
    public PageWorkflowParameters getPageWorkflowParameters(PageWorkflows pageWorkflows) {
        if (pageWorkflows.getPageWorkflowParameters() != null) {
            return pageWorkflows.getPageWorkflowParameters();
        }
        PageWorkflowParameters parameters = new PageWorkflowParameters();
        for (Workflow workflow : pageWorkflows.getWorkflows()) {
            for (com.comalatech.workflow.model.WorkflowParameter workflowParameter : workflow.getWorkflowParameters()) {
                if (!workflowParameter.isPageEditable()) continue;
                parameters.add(this.getPageWorkflowParameterInternal(pageWorkflows.getPage(), workflowParameter));
            }
        }
        pageWorkflows.setPageWorkflowParameters(parameters);
        return parameters;
    }

    @Override
    public List<com.comalatech.workflow.model.WorkflowParameter> getWorkflowParameters(PageWorkflows pageWorkflows) {
        if (pageWorkflows == null) {
            return Collections.emptyList();
        }
        ArrayList<com.comalatech.workflow.model.WorkflowParameter> parameters = new ArrayList<com.comalatech.workflow.model.WorkflowParameter>(Collections.emptyList());
        AbstractPage page = pageWorkflows.getPage();
        for (Workflow workflow : pageWorkflows.getWorkflows()) {
            for (com.comalatech.workflow.model.WorkflowParameter workflowParameter : workflow.getWorkflowParameters()) {
                String currentValue = this.getParameterValue(page, workflowParameter.getName());
                workflowParameter.setValue(currentValue);
                parameters.add(workflowParameter);
            }
        }
        return parameters;
    }

    @Override
    public List<com.comalatech.workflow.model.PageWorkflowParameter> getParametersForTransition(AbstractPage page, Workflow.State apiTargetState) {
        State targetState = null;
        if (apiTargetState instanceof State) {
            targetState = (State)apiTargetState;
        }
        if (targetState == null) {
            return null;
        }
        String requiredParams = Objects.toString(targetState.getRequiredParams(), "");
        return Arrays.stream(requiredParams.split(",")).map(param -> this.getWorkflowParameter(page, (String)param)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public boolean isTransitionAllowed(AbstractPage page, Workflow.State targetState) {
        List<com.comalatech.workflow.model.PageWorkflowParameter> pageWorkflowParameters = this.getParametersForTransition(page, targetState);
        boolean isAnyParameterEmpty = pageWorkflowParameters.stream().anyMatch(parameter -> StringUtils.isEmpty((CharSequence)parameter.getValue()));
        if (log.isDebugEnabled()) {
            String message = isAnyParameterEmpty ? "For transition -> %s, one of more parameters (%s) is empty => transition is NOT allowed" : "For transition -> %s, all parameters (%s) are not empty => transition IS allowed";
            log.debug(String.format(message, targetState.getName(), StringUtils.join(pageWorkflowParameters, (String)", ")));
        }
        return !isAnyParameterEmpty;
    }

    @Override
    public Map<String, List<com.comalatech.workflow.model.PageWorkflowParameter>> getParametersForAnyTransition(AbstractPage page, Workflow.State apiState, boolean isAdmin) {
        StateSelection selection;
        HashMap<String, List<com.comalatech.workflow.model.PageWorkflowParameter>> parameters = new HashMap<String, List<com.comalatech.workflow.model.PageWorkflowParameter>>();
        State state = null;
        if (apiState instanceof State) {
            state = (State)apiState;
        }
        if (state == null) {
            return parameters;
        }
        PageWorkflows pageWorkflows = this.workflowAccessor.getPageWorkflows(page);
        HashSet<String> transitionableStates = new HashSet<String>(Arrays.asList(state.getApprovedStateName(), state.getRejectedStateName()));
        if (state.getSubmitState() != null) {
            transitionableStates.add(state.getSubmitState().getName());
        }
        if (state.getStateSelections() != null) {
            for (StateSelection stateSelection : state.getStateSelections()) {
                for (State option : stateSelection.getAllowedStates()) {
                    if (option.getName() == null) continue;
                    transitionableStates.add(option.getName());
                }
            }
        }
        transitionableStates.add(state.getUpdatedStateName());
        transitionableStates.add(state.getExpiredStateName());
        if (isAdmin && pageWorkflows.getValueStore().canAdminWorkflow(AuthenticatedUserThreadLocal.get()) && (selection = this.stateSelectionManager.getStatesSelection(pageWorkflows, true)) != null) {
            for (State allowedState : selection.getAllowedStates()) {
                transitionableStates.add(allowedState.getName());
            }
        }
        for (String string : transitionableStates) {
            List<com.comalatech.workflow.model.PageWorkflowParameter> parametersForTargetState;
            State targetState;
            if (string == null || (targetState = pageWorkflows.getState(string)) == null || (parametersForTargetState = this.getParametersForTransition(page, targetState)) == null || parametersForTargetState.isEmpty()) continue;
            parameters.put(targetState.getName(), parametersForTargetState);
        }
        return parameters;
    }

    private String getMetadataValue(AbstractPage latestVersion, String valueName, int loopIterations) {
        return this.workflowValueAccessor.getValue(latestVersion, valueName, loopIterations);
    }
}

