/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.comalatech.confluence.documentActivity.upgrade.service.DocumentActivityUpgradeService;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.util.PluginContainerManager;
import com.comalatech.confluence.util.ReadWriteTransactionService;
import com.comalatech.confluence.workflow.ApprovalAccessor;
import com.comalatech.confluence.workflow.compatibility.AttachmentIdHelper;
import com.comalatech.confluence.workflow.dao.ApprovalCheckDao;
import com.comalatech.confluence.workflow.model.ApprovalCheck;
import com.comalatech.workflow.StateService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultApprovalAccessor
implements ApprovalAccessor {
    private static final Logger log = LoggerFactory.getLogger(DefaultApprovalAccessor.class);
    private final ApprovalCheckDao approvalCheckDao;
    private final AttachmentIdHelper attachmentIdHelper;
    private final DocumentActivityUpgradeService documentActivityUpgradeService;
    private final ReadWriteTransactionService transactionService;

    public DefaultApprovalAccessor(ApprovalCheckDao approvalCheckDao, AttachmentIdHelper attachmentIdHelper, DocumentActivityUpgradeService documentActivityUpgradeService, ReadWriteTransactionService transactionService) {
        this.approvalCheckDao = approvalCheckDao;
        this.attachmentIdHelper = attachmentIdHelper;
        this.documentActivityUpgradeService = documentActivityUpgradeService;
        this.transactionService = transactionService;
    }

    @Override
    public ApprovalCheck[] getApprovalChecks(AbstractPage page) {
        ApprovalCheck[] approvalChecks = this.approvalCheckDao.getApprovalChecks(page);
        return this.confluence57AttachmentIDFix(page, approvalChecks);
    }

    @Override
    public void saveApprovalChecks(AbstractPage page, ApprovalCheck[] approvalChecks) {
        this.approvalCheckDao.saveApprovalChecks(page, approvalChecks);
    }

    @Override
    public void saveApprovalChecksBeforeLastFinalState(AbstractPage page) {
        this.approvalCheckDao.saveApprovalChecksBeforeLastFinalState(page, this.approvalCheckDao.getLatestApprovalChecks(page));
    }

    @Override
    public void saveApprovalChecksBeforeLastFinalState(AbstractPage page, ApprovalCheck[] approvalChecks) {
        this.approvalCheckDao.saveApprovalChecksBeforeLastFinalState(page, approvalChecks);
    }

    private ApprovalCheck[] confluence57AttachmentIDFix(AbstractPage page, ApprovalCheck[] approvalChecks) {
        if (approvalChecks != null && approvalChecks.length > 0 && !this.approvalCheckDao.isAttachmentIDsMigrated(page)) {
            log.info("Checking for changed Attachment Ids for page: " + page);
            Map<Long, Long> oldNewIdMap = this.attachmentIdHelper.getOldNewAttachmentIds(page.getId());
            if (!oldNewIdMap.isEmpty()) {
                log.info("Found changed Attachment Ids, fixing workflow history. " + oldNewIdMap);
                for (ApprovalCheck approvalCheck : approvalChecks) {
                    List<ApprovalCheck.CheckedAttachment> checkedAttachments = Arrays.asList(approvalCheck.getAttachments());
                    for (ApprovalCheck.CheckedAttachment checkedAttachment : checkedAttachments) {
                        if (!oldNewIdMap.containsKey(checkedAttachment.id)) continue;
                        checkedAttachment.id = oldNewIdMap.get(checkedAttachment.id);
                    }
                    approvalCheck.setCheckedAttachments(checkedAttachments);
                }
                this.saveApprovalChecks(page, approvalChecks);
            }
            this.transactionService.executeInReadWriteTransaction(() -> {
                this.approvalCheckDao.setAttachmentIDsMigrated(page);
                return null;
            });
        }
        return approvalChecks;
    }

    @Override
    public Integer getFinalApprovalCheckId(AbstractPage page) {
        return this.approvalCheckDao.getFinalApprovalCheckId(page);
    }

    @Override
    public void setFinalApprovalCheckId(AbstractPage page, int approvalCheckId) {
        this.approvalCheckDao.setFinalApprovalCheckId(page, approvalCheckId);
    }

    @Override
    public void clearFinalApprovalId(AbstractPage page) {
        this.approvalCheckDao.clearFinalApprovalId(page);
    }

    @Override
    public List<ApprovalCheck> getApprovalChecksBeforeLastFinalState(AbstractPage page, PageState stateBeforeLastFinalState) {
        ApprovalCheck[] approvalChecks;
        Integer finalApprovalId;
        if (!this.documentActivityUpgradeService.hasAlreadyBeenUpgraded(page)) {
            if (stateBeforeLastFinalState != null) {
                return this.getLatestApprovalChecks(page, stateBeforeLastFinalState);
            }
            return new ArrayList<ApprovalCheck>();
        }
        List<ApprovalCheck> finalApprovalChecks = Arrays.asList(this.approvalCheckDao.getApprovalChecksBeforeLastFinalState(page));
        if (finalApprovalChecks.isEmpty() && stateBeforeLastFinalState != null && (finalApprovalId = this.approvalCheckDao.getFinalApprovalCheckId(page)) != null && (approvalChecks = this.getApprovalChecks(page)) != null) {
            List<ApprovalCheck> finalApprovalCheck = this.filterApprovalChecksForState(Arrays.asList(approvalChecks), stateBeforeLastFinalState.getId(), true);
            log.warn("Saving approval checks for the state prior to the last final state for the page {}", (Object)page);
            this.approvalCheckDao.saveApprovalChecksBeforeLastFinalState(page, finalApprovalCheck.toArray(ApprovalCheck.EMPTY_ARRAY));
            return Arrays.asList(this.approvalCheckDao.getApprovalChecksBeforeLastFinalState(page));
        }
        return finalApprovalChecks;
    }

    @Override
    public ApprovalCheck getFinalApprovalCheck(AbstractPage page) {
        if (!this.documentActivityUpgradeService.hasAlreadyBeenUpgraded(page)) {
            try {
                Integer id = this.getFinalApprovalCheckId(page);
                if (id != null) {
                    return this.getFinalApprovalCheck(page, null, id);
                }
            }
            catch (NumberFormatException e) {
                log.error("Invalid approval id on " + page, (Throwable)e);
            }
            return null;
        }
        List<ApprovalCheck> approvalChecks = this.getApprovalChecksBeforeLastFinalState(page, null);
        if (approvalChecks != null && !approvalChecks.isEmpty()) {
            return approvalChecks.get(0);
        }
        return null;
    }

    @Override
    public ApprovalCheck getFinalApprovalCheck(AbstractPage page, String approvalName, int approvalId) {
        AbstractPage latestVersion = page.getLatestVersion();
        if (approvalId > 0) {
            return this.getApprovalCheck(latestVersion, approvalId);
        }
        if (approvalName != null) {
            ApprovalCheck check = this.getLatestApprovalCheck(latestVersion, null, approvalName, 0);
            if (check == null || !check.isApproved()) {
                return null;
            }
            return check;
        }
        return null;
    }

    @Override
    public ApprovalCheck getApprovalCheck(AbstractPage page, int approvalId) {
        ApprovalCheck[] checks = this.getApprovalChecks(page);
        if (approvalId > checks.length || approvalId <= 0) {
            Integer id = this.getFinalApprovalCheckId(page);
            if (id != null && id == approvalId) {
                log.error("Invalid approval id " + approvalId + ": there are only " + checks.length + " checks in " + page + ". Removing finalApprovalId");
                this.clearFinalApprovalId(page);
            } else {
                log.error("Invalid approval id " + approvalId + ": there are only " + checks.length + " checks in " + page);
            }
            return null;
        }
        return checks[approvalId - 1];
    }

    @Override
    public ApprovalCheck getLatestApprovalCheck(AbstractPage page, PageState pageState, String approvalName, int version) {
        List<ApprovalCheck> checks = this.getApprovalChecks(page.getLatestVersion(), pageState);
        return this.getLastApprovalCheckWithPredicate(checks, check -> check.getName().equals(approvalName) && (version == 0 || version >= check.getVersion()));
    }

    @Override
    public ApprovalCheck getLatestApprovalCheckInCurrentState(AbstractPage page, String approvalName) {
        return this.getLatestApprovalCheckInCurrentState(page, approvalName, 0);
    }

    @Override
    public ApprovalCheck getLatestApprovalCheckInCurrentState(AbstractPage page, String approvalName, int version) {
        PageState currentPageState = (PageState)DefaultApprovalAccessor.getStateService().getCurrentState((ContentEntityObject)page);
        List<ApprovalCheck> checks = this.getLatestApprovalChecksStrict(page, currentPageState);
        return this.getLastApprovalCheckWithPredicate(checks, check -> check.getName().equals(approvalName) && (version == 0 || version >= check.getVersion()));
    }

    @Override
    public List<ApprovalCheck> getLatestApprovalChecks(AbstractPage page) {
        return this.getLatestChecksWithVersion(Arrays.asList(this.approvalCheckDao.getLatestApprovalChecks(page)), null);
    }

    @Override
    public ApprovalCheck getLatestApprovalCheck(AbstractPage page) {
        ApprovalCheck[] approvalChecks = this.approvalCheckDao.getLatestApprovalChecks(page = page.getLatestVersion());
        if (approvalChecks.length == 0) {
            approvalChecks = this.getApprovalChecks(page);
        }
        if (approvalChecks == null || approvalChecks.length == 0) {
            return null;
        }
        return approvalChecks[approvalChecks.length - 1];
    }

    @Override
    public List<ApprovalCheck> getLatestApprovalChecks(AbstractPage page, PageState pageState) {
        return this.getLatestChecks(this.getApprovalChecks(page, pageState));
    }

    @Override
    public List<ApprovalCheck> getLatestApprovalChecksForAnyState(AbstractPage page) {
        return this.getLatestChecks(Arrays.asList(this.getApprovalChecks(page)));
    }

    @Override
    public List<ApprovalCheck> getOldApprovalChecks(AbstractPage oldPage, PageState pageState) {
        return this.getLatestChecksWithVersion(this.getApprovalChecks(oldPage.getLatestVersion(), pageState), oldPage.getVersion());
    }

    @Override
    public List<ApprovalCheck> getApprovalChecks(AbstractPage page, PageState pageState) {
        List<ApprovalCheck> checks = this.getLatestApprovalChecksStrict(page, pageState);
        if (!checks.isEmpty()) {
            return checks;
        }
        checks = Arrays.asList(this.getApprovalChecks(page));
        if (pageState == null) {
            return checks;
        }
        return this.filterApprovalChecksForState(checks, pageState.getId(), false);
    }

    @Override
    public List<ApprovalCheck> getLatestApprovalChecksStrict(AbstractPage page, PageState pageState) {
        ApprovalCheck[] checks = this.approvalCheckDao.getLatestApprovalChecks(page);
        if (checks != null && checks.length > 0 && pageState != null && checks[0].getStateId() == pageState.getId()) {
            return Arrays.asList(checks);
        }
        return new ArrayList<ApprovalCheck>();
    }

    @Override
    public List<ApprovalCheck> getApprovalsPriorToLatestPublishedState(AbstractPage page, PageState pageState) {
        ApprovalCheck[] checks = this.approvalCheckDao.getApprovalChecks(page);
        if (checks != null) {
            return this.filterApprovalChecksForState(Arrays.asList(checks), pageState.getId(), true);
        }
        return new ArrayList<ApprovalCheck>();
    }

    @Override
    public List<ApprovalCheck> getAllApprovalChecksForState(ApprovalCheck[] checks, PageState pageState) {
        return this.filterApprovalChecksForState(Arrays.asList(checks), pageState.getId(), true);
    }

    @Override
    public void removeApprovalChecks(AbstractPage page) {
        this.approvalCheckDao.removeApprovalChecks(page);
        this.approvalCheckDao.removeLatestApprovalChecks(page);
        this.approvalCheckDao.removeApprovalChecksBeforeLastFinalState(page);
    }

    private List<ApprovalCheck> filterApprovalChecksForState(List<ApprovalCheck> checks, int stateId, boolean all) {
        ArrayList<ApprovalCheck> filteredChecks = new ArrayList<ApprovalCheck>();
        HashSet<String> checkNames = new HashSet<String>();
        Collections.reverse(checks);
        for (ApprovalCheck check : checks) {
            if (check.getStateId() == stateId) {
                if (!all && checkNames.contains(check.getName())) continue;
                filteredChecks.add(0, check);
                checkNames.add(check.getName());
                continue;
            }
            if (checkNames.isEmpty()) continue;
            break;
        }
        return filteredChecks;
    }

    private List<ApprovalCheck> getLatestChecks(List<ApprovalCheck> checks) {
        return this.getLatestChecksWithVersion(checks, null);
    }

    private List<ApprovalCheck> getLatestChecksWithVersion(List<ApprovalCheck> checks, Integer version) {
        HashSet approvalNames = new HashSet();
        Comparator<ApprovalCheck> sorter = Comparator.comparingInt(ApprovalCheck::getId);
        return checks.stream().sorted(sorter.reversed()).filter(check -> {
            if (!(approvalNames.contains(check.getName()) || version != null && check.getVersion() != version.intValue())) {
                approvalNames.add(check.getName());
                return true;
            }
            return false;
        }).collect(Collectors.toList());
    }

    private ApprovalCheck getLastApprovalCheckWithPredicate(List<ApprovalCheck> checks, Predicate<ApprovalCheck> predicate) {
        Comparator<ApprovalCheck> sorter = Comparator.comparingInt(ApprovalCheck::getId);
        return checks.stream().sorted(sorter.reversed()).filter(predicate).findFirst().orElse(null);
    }

    private static StateService getStateService() {
        return PluginContainerManager.getComponent("stateService", StateService.class);
    }
}

