/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.util;

import org.apache.commons.text.StringEscapeUtils;

public class CSVBuilder {
    protected static final String LINE_SEPARATOR = System.getProperty("line.separator");
    protected static final String COMMA = ",";
    private final StringBuilder builder = new StringBuilder();
    private boolean start = true;

    public void addCell(String cell) {
        if (this.start) {
            this.start = false;
        } else {
            this.builder.append(COMMA);
        }
        this.builder.append(this.cleanCSVValue(cell));
    }

    public void addLine(String line) {
        this.builder.append(this.cleanCSVValue(line));
        this.builder.append(LINE_SEPARATOR);
    }

    public void newLine() {
        this.builder.append(LINE_SEPARATOR);
        this.start = true;
    }

    public String get() {
        return this.builder.toString();
    }

    private String cleanCSVValue(String value) {
        if (value == null) {
            return null;
        }
        if (value.trim().length() == 0) {
            return "";
        }
        return StringEscapeUtils.escapeCsv((String)this.removeCSVInjectionCharacters(value));
    }

    private String removeCSVInjectionCharacters(String content) {
        if (content != null) {
            content = content.replaceFirst("^[\\+\\-\\@\\=]", "");
            content = content.replaceAll("\\s", " ");
            content.replaceAll("\"", "\"\"");
            content = "'" + content;
        }
        return content;
    }
}

