/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.tasks.extractor;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.user.UserAccessor;
import com.comalatech.confluence.dataextractor.model.UserKeyListContentProperty;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.tasks.extractor.model.PageTasksContentPropertyModel;
import com.comalatech.confluence.tasks.extractor.model.PendingTasksContentProperty;
import com.comalatech.confluence.tasks.extractor.model.TaskContentPropertyModelVersion;
import com.comalatech.confluence.tasks.model.PageTask;
import com.comalatech.workflow.StateService;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskPropertyExtractor {
    private static final Logger log = LoggerFactory.getLogger(TaskPropertyExtractor.class);
    private final StateService stateService;
    private final UserAccessor userAccessor;
    private final ObjectMapper mapper;

    public TaskPropertyExtractor(StateService stateService, UserAccessor userAccessor) {
        this.stateService = stateService;
        this.userAccessor = userAccessor;
        this.mapper = new ObjectMapper();
        this.mapper.setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
    }

    public String getJsonOf(AbstractPage page) {
        PageTasksContentPropertyModel data = this.extractFrom(page);
        return this.serialize(data);
    }

    private PageTasksContentPropertyModel extractFrom(AbstractPage page) {
        PageState currentState = (PageState)this.stateService.getCurrentState((ContentEntityObject)page);
        List<PendingTasksContentProperty> pendingTasksContentProperties = this.extractPendingTasks(currentState);
        Set<String> userId = this.extractPendingTaskUsers(pendingTasksContentProperties);
        PageTasksContentPropertyModel pageTasks = new PageTasksContentPropertyModel();
        pageTasks.pendingTasksContentProperties = pendingTasksContentProperties;
        pageTasks.userKeyListContentProperty = UserKeyListContentProperty.fromKeys(userId);
        return pageTasks;
    }

    public <T> String serialize(T data) {
        try {
            return this.mapper.writeValueAsString(data);
        }
        catch (Exception e) {
            String className = data == null ? "" : data.getClass().getSimpleName();
            log.error(className + " could not be serialized", (Throwable)e);
            return "";
        }
    }

    public String getCurrentTaskModelVersionJson() {
        return this.serialize(TaskContentPropertyModelVersion.getCurrentVersion());
    }

    public PageTasksContentPropertyModel deserialize(String jsonContentProperty) {
        try {
            return (PageTasksContentPropertyModel)this.mapper.readValue(jsonContentProperty, PageTasksContentPropertyModel.class);
        }
        catch (IOException | NullPointerException e) {
            log.error("Error deserializing task content property {} ", (Object)jsonContentProperty, (Object)e);
            return null;
        }
    }

    private List<PendingTasksContentProperty> extractPendingTasks(PageState pState) {
        List<PageTask> tasks;
        if (pState != null && (tasks = pState.getTasks()) != null) {
            return tasks.stream().map(PendingTasksContentProperty::fromTask).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private Set<String> extractPendingTaskUsers(List<PendingTasksContentProperty> pendingTasks) {
        if (pendingTasks != null) {
            return pendingTasks.stream().map(currentPendingTask -> this.userAccessor.getUserByName(currentPendingTask.assignedTo)).filter(Objects::nonNull).map(pendingTaskUser -> pendingTaskUser.getKey().toString()).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }
}

