/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.ipc.api;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.persistence.AnyTypeDao;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.user.User;
import com.comalatech.confluence.adhoc.AdhocWorkflowManager;
import com.comalatech.confluence.adhoctasks.TaskPermissionException;
import com.comalatech.confluence.assignment.AssignmentManager;
import com.comalatech.confluence.ipc.api.AbstractAdhocService;
import com.comalatech.confluence.states.StateAccessor;
import com.comalatech.confluence.states.StateManager;
import com.comalatech.confluence.states.model.Assignment;
import com.comalatech.confluence.states.model.DueDateRecord;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.states.model.TaskCompletion;
import com.comalatech.confluence.tasks.PageTaskManager;
import com.comalatech.confluence.tasks.model.PageContentTask;
import com.comalatech.confluence.tasks.model.PageTask;
import com.comalatech.confluence.tasks.model.Task;
import com.comalatech.confluence.tasks.model.TaskType;
import com.comalatech.confluence.workflow.PageWorkflows;
import com.comalatech.confluence.workflow.Workflow;
import com.comalatech.confluence.workflow.WorkflowAccessor;
import com.comalatech.confluence.workflow.WorkflowConfigurationManager;
import com.comalatech.confluence.workflow.WorkflowUserException;
import com.comalatech.confluence.workflow.permissions.WorkflowPermissionManager;
import com.comalatech.confluence.workflow.user.WorkflowAuthenticatedUserThreadLocal;
import com.comalatech.workflow.StateService;
import com.comalatech.workflow.TaskService;
import com.comalatech.workflow.WorkflowException;
import com.comalatech.workflow.model.ContentTask;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTaskService
extends AbstractAdhocService
implements TaskService {
    private static final Logger log = LoggerFactory.getLogger(DefaultTaskService.class);
    protected final PageTaskManager pageTaskManager;
    protected final AssignmentManager assignmentManager;
    protected final StateAccessor stateAccessor;
    protected final AnyTypeDao anyTypeDao;
    protected final AdhocWorkflowManager adhocWorkflowManager;
    protected final StateService stateService;
    protected final WorkflowConfigurationManager workflowConfigurationManager;
    protected final WorkflowPermissionManager workflowPermissionManager;
    protected final PermissionManager permissionManager;

    public DefaultTaskService(UserAccessor userAccessor, WorkflowAccessor workflowAccessor, StateManager stateManager, PageTaskManager pageTaskManager, AssignmentManager assignmentManager, StateAccessor stateAccessor, AnyTypeDao anyTypeDao, AdhocWorkflowManager adhocWorkflowManager, StateService stateService, WorkflowConfigurationManager workflowConfigurationManager, WorkflowPermissionManager workflowPermissionManager, PermissionManager permissionManager) {
        super(userAccessor, workflowAccessor, stateManager);
        this.pageTaskManager = pageTaskManager;
        this.assignmentManager = assignmentManager;
        this.stateAccessor = stateAccessor;
        this.anyTypeDao = anyTypeDao;
        this.adhocWorkflowManager = adhocWorkflowManager;
        this.stateService = stateService;
        this.workflowConfigurationManager = workflowConfigurationManager;
        this.workflowPermissionManager = workflowPermissionManager;
        this.permissionManager = permissionManager;
    }

    @Override
    public com.comalatech.workflow.model.Task createTask(ContentEntityObject content, String taskName, String assignee, String comment) throws WorkflowException {
        return this.createTask(content, taskName, assignee, comment, null);
    }

    @Override
    public com.comalatech.workflow.model.Task createTask(ContentEntityObject content, final String taskName, final String assignee, final String comment, final Date dueDate) throws WorkflowException {
        AbstractPage page = (AbstractPage)content;
        Workflow workflow = this.adhocWorkflowManager.getPageWorkflow(page = page.getLatestVersion());
        if (workflow == null && !this.workflowAccessor.hasWorkflowsOrApprovals((ContentEntityObject)page)) {
            if (!this.workflowConfigurationManager.getConfiguration().isPageApprovalsAllowed(page)) {
                return null;
            }
            workflow = this.adhocWorkflowManager.createDefaultTaskAdhocWorkflow(page);
            workflow.setHideStates(true);
            this.adhocWorkflowManager.savePageWorkflow(page, workflow, true);
        }
        if (!this.stateService.getCurrentState((ContentEntityObject)page).isTaskable()) {
            return null;
        }
        return (com.comalatech.workflow.model.Task)new AbstractAdhocService.WorkflowCommand((ContentEntityObject)page){

            @Override
            public Object doCommand(AbstractPage page, ConfluenceUser user, PageWorkflows pageWorkflows, PageState state) throws WorkflowException {
                if (!Task.isValidTaskName(taskName)) {
                    throw new WorkflowUserException("comalatech.awp.designer.error.task.name.invalid", taskName);
                }
                Date creationDate = new Date();
                PageTask task = new PageTask(user.getName(), taskName, TaskType.DEFAULT, creationDate);
                if (StringUtils.isNotBlank((CharSequence)assignee)) {
                    try {
                        Assignment assignment = DefaultTaskService.this.assignmentManager.createAssignment(assignee, null, null, comment);
                        assignment.setDate(new Date(creationDate.getTime() + 1L));
                        task.assign(assignment);
                    }
                    catch (WorkflowUserException workflowUserException) {
                        // empty catch block
                    }
                }
                task.setComment(comment);
                if (dueDate != null) {
                    task.setCurrentDueDate(new DueDateRecord(dueDate, AuthenticatedUserThreadLocal.getUsername(), new Date(creationDate.getTime() + 2L)));
                }
                DefaultTaskService.this.pageTaskManager.addPageTask(page, state, task);
                DefaultTaskService.this.setCanComplete(page, task);
                if (pageWorkflows.isAdhoc()) {
                    DefaultTaskService.this.adhocWorkflowManager.addTask(page, state.getName(), task);
                }
                return task;
            }
        }.execute();
    }

    @Override
    public com.comalatech.workflow.model.Task editTask(ContentEntityObject content, final String taskId, final String newTaskName, final String newComment, final Date dueDate) throws WorkflowException {
        return (com.comalatech.workflow.model.Task)new AbstractAdhocService.WorkflowCommand(content){

            @Override
            public Object doCommand(AbstractPage page, ConfluenceUser user, PageWorkflows pageWorkflows, PageState state) throws WorkflowException {
                PageTask task = DefaultTaskService.this.getTask(state, taskId);
                if (!DefaultTaskService.this.canPerformAction(user, page, task)) {
                    throw new TaskPermissionException("User has not permission to edit the task");
                }
                PageTask oldTask = DefaultTaskService.this.copyTask(task);
                task.setName(newTaskName);
                task.setComment(newComment);
                DefaultTaskService.this.setTaskDueDate(task, dueDate);
                DefaultTaskService.this.pageTaskManager.updateTask(page, state, task, oldTask, user.getName());
                DefaultTaskService.this.setCanComplete(page, task);
                return task;
            }
        }.execute();
    }

    @Override
    public void removeTask(ContentEntityObject content, final String taskId, final String comment) throws WorkflowException {
        new AbstractAdhocService.WorkflowCommand(content){

            @Override
            public Object doCommand(AbstractPage page, ConfluenceUser user, PageWorkflows pageWorkflows, PageState state) throws WorkflowException {
                PageTask task = DefaultTaskService.this.getTask(state, taskId);
                if (!DefaultTaskService.this.canPerformAction(user, page, task)) {
                    throw new TaskPermissionException("User has not permission to remove the task");
                }
                DefaultTaskService.this.pageTaskManager.removeTask(page, task, comment);
                return task;
            }
        }.execute();
    }

    @Override
    public void removeTask(ContentEntityObject content, String taskId) throws WorkflowException {
        this.removeTask(content, taskId, null);
    }

    @Override
    @Deprecated
    public com.comalatech.workflow.model.Task completeTask(ContentEntityObject content, final String taskId, final String outcome, final String comment) throws WorkflowException {
        return (com.comalatech.workflow.model.Task)new AbstractAdhocService.WorkflowCommand(content){

            @Override
            public Object doCommand(AbstractPage page, ConfluenceUser user, PageWorkflows pageWorkflows, PageState state) throws WorkflowException {
                PageTask task = DefaultTaskService.this.getTask(state, taskId);
                if (user == null) {
                    user = WorkflowAuthenticatedUserThreadLocal.get();
                } else if (!DefaultTaskService.this.canCompleteTask(page, taskId)) {
                    throw new TaskPermissionException("User has not permission to complete the task");
                }
                DefaultTaskService.this.pageTaskManager.completeTask(page, user, state, task, new TaskCompletion(user != null ? user.getName() : null, new Date(), outcome, comment));
                return task;
            }
        }.execute();
    }

    @Override
    public com.comalatech.workflow.model.Task completeTask(ContentEntityObject content, String taskId, String comment) throws WorkflowException {
        return this.completeTask(content, taskId, "completed", comment);
    }

    @Override
    public com.comalatech.workflow.model.Task assignTask(ContentEntityObject content, String taskId, String assignee, String comment) throws WorkflowException {
        return this.assignTask(content, taskId, assignee, comment, null);
    }

    @Override
    public com.comalatech.workflow.model.Task assignTask(ContentEntityObject content, final String taskId, final String assignee, final String comment, final Date dueDate) throws WorkflowException {
        return (com.comalatech.workflow.model.Task)new AbstractAdhocService.WorkflowCommand(content){

            @Override
            public Object doCommand(AbstractPage page, ConfluenceUser user, PageWorkflows pageWorkflows, PageState state) throws WorkflowException {
                PageTask task = DefaultTaskService.this.getTask(state, taskId);
                Assignment assignment = DefaultTaskService.this.assignmentManager.createAssignment(assignee, null, null, comment);
                if (dueDate != null) {
                    DefaultTaskService.this.setTaskDueDate(task, dueDate);
                }
                task.assign(assignment);
                DefaultTaskService.this.pageTaskManager.assignTask(page, state, task, assignment);
                DefaultTaskService.this.setCanComplete(page, task);
                return task;
            }
        }.execute();
    }

    @Override
    public List<ContentTask> getTasks(ContentEntityObject ceo) {
        return this.getStateTasks(ceo, true, true);
    }

    @Override
    public List<ContentTask> getActiveTasks(ContentEntityObject ceo) {
        return this.getStateTasks(ceo, true, false);
    }

    @Override
    public List<ContentTask> getCompletedTasks(ContentEntityObject ceo) {
        return this.getStateTasks(ceo, false, true);
    }

    private PageTask getTask(PageState state, String taskId) throws WorkflowException {
        try {
            int id = Integer.parseInt(taskId);
            PageTask task = state.getPageTasks().getById(id);
            if (task != null) {
                return task;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new WorkflowException("Invalid task Id " + taskId);
    }

    private List<ContentTask> getStateTasks(ContentEntityObject ceo, boolean includeActive, boolean includeCompleted) {
        PageState pageState;
        ArrayList<ContentTask> tasks = new ArrayList<ContentTask>();
        if (ceo instanceof AbstractPage && (pageState = this.stateAccessor.getLatestState((AbstractPage)ceo)) != null) {
            for (PageTask task : pageState.getPageTasks().get()) {
                if ((!includeCompleted || !task.isCompleted()) && (!includeActive || task.isCompleted())) continue;
                this.setCanComplete((AbstractPage)ceo, task);
                tasks.add(new PageContentTask(ceo, task));
            }
        }
        return tasks;
    }

    private void setCanComplete(AbstractPage page, PageTask task) {
        task.setCanComplete(this.pageTaskManager.canComplete(task, AuthenticatedUserThreadLocal.get(), this.workflowPermissionManager.canViewDrafts(page, AuthenticatedUserThreadLocal.get()), this.isWorkflowStrictTasks((ContentEntityObject)page)));
    }

    private boolean isWorkflowStrictTasks(ContentEntityObject ceo) {
        PageWorkflows workflows;
        if (ceo instanceof AbstractPage && (workflows = this.workflowAccessor.getPageWorkflows((AbstractPage)ceo)) != null) {
            return workflows.isStrictTasks();
        }
        return false;
    }

    private boolean canPerformAction(ConfluenceUser user, AbstractPage content, PageTask task) {
        return this.canAdminWorkflow(content, (User)user) || user.getName().equals(task.getPerformer()) || user.getName().equals(task.getAssignee());
    }

    private boolean canAdminWorkflow(AbstractPage page, User user) {
        return this.permissionManager.hasPermission(user, Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION) || page.getSpace() != null && this.permissionManager.hasPermission(user, Permission.ADMINISTER, (Object)page.getSpace());
    }

    private boolean canCompleteTask(AbstractPage page, String taskId) {
        List<ContentTask> contentTasks = this.getTasks((ContentEntityObject)page);
        com.comalatech.workflow.model.Task taskToComplete = null;
        for (ContentTask contentTask : contentTasks) {
            if (!contentTask.getTask().getActivityId().equals(taskId)) continue;
            taskToComplete = contentTask.getTask();
        }
        if (taskToComplete != null) {
            return taskToComplete.canComplete();
        }
        return true;
    }

    private void setTaskDueDate(PageTask task, Date newDueDate) {
        if (newDueDate != null) {
            if (task.getCurrentDueDate() == null || task.getCurrentDueDate().getDueDate() == null) {
                task.setCurrentDueDate(new DueDateRecord(newDueDate, AuthenticatedUserThreadLocal.getUsername(), new Date()));
            } else if (task.getCurrentDueDate().getDueDate().getTime() != newDueDate.getTime()) {
                DueDateRecord currentDueDate = task.getCurrentDueDate();
                task.addDueDateHistory(currentDueDate);
                task.setCurrentDueDate(new DueDateRecord(newDueDate, AuthenticatedUserThreadLocal.getUsername(), new Date()));
            }
        } else if (task.getCurrentDueDate() != null) {
            task.addDueDateHistory(task.getCurrentDueDate());
            task.setCurrentDueDate(new DueDateRecord(null, AuthenticatedUserThreadLocal.getUsername(), new Date()));
        }
    }

    private PageTask copyTask(PageTask task) {
        PageTask oldTask = new PageTask(task.getPerformer(), task.getName(), task.getType(), task.getDate(), task.getComment());
        oldTask.setDueDateHistory(task.getDueDateHistory());
        oldTask.setAssignments(task.getAssignments());
        oldTask.setCurrentDueDate(task.getCurrentDueDate());
        return oldTask;
    }
}

