/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.upgrade.resources.model;

import com.comalatech.confluence.documentActivity.upgrade.entity.domain.SpaceUpgrade;
import com.comalatech.confluence.documentActivity.upgrade.resources.model.RestSpaceUpgradeTask;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.codehaus.jackson.annotate.JsonAutoDetect;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@ApiModel(description="This is the specification of the space with the data about the workflows and the pages.")
public class RestSpaceUpgrade {
    @ApiModelProperty(value="space name", example="demo space name", dataType="String")
    private String name;
    @ApiModelProperty(value="space key", example="DEMO", dataType="String")
    private String key;
    @ApiModelProperty(value="space home url", example="/display/DEMO/demo", dataType="String")
    private String home;
    @ApiModelProperty(value="number of pages with a workflow history in the space", example="4", dataType="Long")
    private Long numPagesWithHistory;
    @ApiModelProperty(value="the total number of pages in the space", example="5", dataType="Long")
    private Long totalPages;
    @ApiModelProperty(value="flag if the space needs to be upgraded or not", dataType="Boolean")
    private boolean needsUpgrade;
    @ApiModelProperty(value="the space upgrade task status")
    private RestSpaceUpgradeTask preCheck;

    public RestSpaceUpgrade() {
    }

    public RestSpaceUpgrade(SpaceUpgrade spaceUpgrade) {
        this.setName(spaceUpgrade.getSpace().getName());
        this.setKey(spaceUpgrade.getSpace().getKey());
        this.setHome(spaceUpgrade.getSpace().getHomePage() != null ? spaceUpgrade.getSpace().getHomePage().getUrlPath() : spaceUpgrade.getSpace().getBrowseUrlPath());
        this.setNumPagesWithHistory(spaceUpgrade.getTotalPagesWithActivity());
        this.setTotalPages(spaceUpgrade.getTotalPages());
        this.setNeedsUpgrade(spaceUpgrade.isNeedsUpgrade());
        this.setPreCheck(new RestSpaceUpgradeTask(spaceUpgrade.getUpgradeTask()));
    }

    public String getName() {
        return this.name;
    }

    public String getKey() {
        return this.key;
    }

    public String getHome() {
        return this.home;
    }

    public Long getNumPagesWithHistory() {
        return this.numPagesWithHistory;
    }

    public Long getTotalPages() {
        return this.totalPages;
    }

    public boolean isNeedsUpgrade() {
        return this.needsUpgrade;
    }

    public RestSpaceUpgradeTask getPreCheck() {
        return this.preCheck;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setHome(String home) {
        this.home = home;
    }

    public void setNumPagesWithHistory(Long numPagesWithHistory) {
        this.numPagesWithHistory = numPagesWithHistory;
    }

    public void setTotalPages(Long totalPages) {
        this.totalPages = totalPages;
    }

    public void setNeedsUpgrade(boolean needsUpgrade) {
        this.needsUpgrade = needsUpgrade;
    }

    public void setPreCheck(RestSpaceUpgradeTask preCheck) {
        this.preCheck = preCheck;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RestSpaceUpgrade)) {
            return false;
        }
        RestSpaceUpgrade other = (RestSpaceUpgrade)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$home = this.getHome();
        String other$home = other.getHome();
        if (this$home == null ? other$home != null : !this$home.equals(other$home)) {
            return false;
        }
        Long this$numPagesWithHistory = this.getNumPagesWithHistory();
        Long other$numPagesWithHistory = other.getNumPagesWithHistory();
        if (this$numPagesWithHistory == null ? other$numPagesWithHistory != null : !((Object)this$numPagesWithHistory).equals(other$numPagesWithHistory)) {
            return false;
        }
        Long this$totalPages = this.getTotalPages();
        Long other$totalPages = other.getTotalPages();
        if (this$totalPages == null ? other$totalPages != null : !((Object)this$totalPages).equals(other$totalPages)) {
            return false;
        }
        if (this.isNeedsUpgrade() != other.isNeedsUpgrade()) {
            return false;
        }
        RestSpaceUpgradeTask this$preCheck = this.getPreCheck();
        RestSpaceUpgradeTask other$preCheck = other.getPreCheck();
        return !(this$preCheck == null ? other$preCheck != null : !((Object)this$preCheck).equals(other$preCheck));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RestSpaceUpgrade;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $home = this.getHome();
        result = result * 59 + ($home == null ? 43 : $home.hashCode());
        Long $numPagesWithHistory = this.getNumPagesWithHistory();
        result = result * 59 + ($numPagesWithHistory == null ? 43 : ((Object)$numPagesWithHistory).hashCode());
        Long $totalPages = this.getTotalPages();
        result = result * 59 + ($totalPages == null ? 43 : ((Object)$totalPages).hashCode());
        result = result * 59 + (this.isNeedsUpgrade() ? 79 : 97);
        RestSpaceUpgradeTask $preCheck = this.getPreCheck();
        result = result * 59 + ($preCheck == null ? 43 : ((Object)$preCheck).hashCode());
        return result;
    }

    public String toString() {
        return "RestSpaceUpgrade(name=" + this.getName() + ", key=" + this.getKey() + ", home=" + this.getHome() + ", numPagesWithHistory=" + this.getNumPagesWithHistory() + ", totalPages=" + this.getTotalPages() + ", needsUpgrade=" + this.isNeedsUpgrade() + ", preCheck=" + this.getPreCheck() + ")";
    }
}

