/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.statistics.resources;

import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.comalatech.confluence.adhocworkflows.rest.permissions.WorkflowVisibilityPermissionsRequired;
import com.comalatech.confluence.documentActivity.statistics.resources.AbstractUsageStatsResource;
import com.comalatech.confluence.documentActivity.statistics.resources.model.ApprovalUsageStatsRequest;
import com.comalatech.confluence.documentActivity.statistics.resources.model.AssigneeUsageStatsRequest;
import com.comalatech.confluence.documentActivity.statistics.resources.model.StateUsageStatsRequest;
import com.comalatech.confluence.documentActivity.statistics.resources.model.UsageStatsTimeEstimation;
import com.comalatech.confluence.documentActivity.statistics.validator.UsageStatsValidator;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.util.RestWorkflowCommand;
import com.comalatech.confluence.workflow.permissions.WorkflowPermissionManager;
import com.comalatech.workflow.WorkflowException;
import com.comalatech.workflow.model.statistics.ApprovalStatsFilter;
import com.comalatech.workflow.model.statistics.StateStatsFilter;
import com.comalatech.workflow.model.statistics.StatsFilter;
import com.comalatech.workflow.statistics.ApprovalStatsService;
import com.comalatech.workflow.statistics.StateStatsService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(value="/documentactivity", produces="application/json")
@Path(value="/documentactivity/usage")
public class UsageStatsResource
extends AbstractUsageStatsResource {
    private static final Logger log = LoggerFactory.getLogger(UsageStatsResource.class);
    private List<Space> spaces;
    private final ApprovalStatsService approvalStatsService;
    private final StateStatsService stateStatsService;
    private final UsageStatsValidator statsValidator;
    private final WorkflowPermissionManager workflowPermissionManager;

    public UsageStatsResource(PermissionManager permissionManager, SpaceManager spaceManager, PageManager pageManager, WorkflowsFeatureManager workflowsFeatureManager, ApprovalStatsService approvalStatsService, StateStatsService stateStatsService, UsageStatsValidator statsValidator, WorkflowPermissionManager workflowPermissionManager) {
        super(permissionManager, spaceManager, pageManager, workflowsFeatureManager);
        this.approvalStatsService = approvalStatsService;
        this.stateStatsService = stateStatsService;
        this.statsValidator = statsValidator;
        this.workflowPermissionManager = workflowPermissionManager;
    }

    @POST
    @Path(value="/approval")
    @WorkflowVisibilityPermissionsRequired
    @ReadOnlyAccessAllowed
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Retrieves the time elapsed for a specific approval related to the specified operation: maximum (max), minimum (min) and average (avg).", responseReference="Double value of the time in millis")
    @ApiResponses(value={@ApiResponse(code=200, message="The time estimation was retrieved successfully."), @ApiResponse(code=400, message="Validation error of the input body"), @ApiResponse(code=401, message="Client is not authenticated"), @ApiResponse(code=403, message="The given user does not have access."), @ApiResponse(code=500, message="Exception when trying to retrieve usage estimation.")})
    public Response getTimeForSpecificApproval(final @ApiParam(value="Request for the time spent for specific approval", required=true) ApprovalUsageStatsRequest request) {
        return new RestWorkflowCommand(this.workflowsFeatureManager, this.permissionManager, this.workflowPermissionManager, this.spaceManager){

            @Override
            public Response doExecute() {
                try {
                    UsageStatsResource.this.validateSpecificApprovalRequest(request);
                    return Response.ok().entity((Object)UsageStatsResource.this.getTimeForApproval(request)).type("application/json").build();
                }
                catch (IllegalArgumentException e) {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
                }
                catch (WorkflowException e) {
                    return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)e.getMessage()).build();
                }
                catch (Exception e) {
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
                }
            }
        }.execute(request != null ? request.getSpaceKeys() : null);
    }

    private void validateSpecificApprovalRequest(ApprovalUsageStatsRequest request) throws WorkflowException {
        if (!StringUtils.isNotBlank((CharSequence)request.getApprovalName())) {
            throw new IllegalArgumentException("Approval name field is a required field for this usage report");
        }
        if (Objects.isNull((Object)UsageStatsTimeEstimation.parse(request.getUsageTimeEstimation()))) {
            throw new IllegalArgumentException("Time estimation mode is a required field for this usage report");
        }
    }

    private Double getTimeForApproval(ApprovalUsageStatsRequest request) throws WorkflowException {
        StatsFilter filter = ((ApprovalStatsFilter.ApprovalStatsFilterBuilder)((ApprovalStatsFilter.ApprovalStatsFilterBuilder)((ApprovalStatsFilter.ApprovalStatsFilterBuilder)((ApprovalStatsFilter.ApprovalStatsFilterBuilder)((StatsFilter.StatsFilterBuilder)ApprovalStatsFilter.builder().approvalName(request.getApprovalName())).stateName(request.getStateName())).spaceKeys(request.getSpaceKeys())).fromDate(request.getFromDate())).toDate(request.getToDate())).build();
        switch (Objects.requireNonNull(UsageStatsTimeEstimation.parse(request.getUsageTimeEstimation()))) {
            case MAX: {
                return (double)this.approvalStatsService.getMaximumTimeElapsedForApproval((ApprovalStatsFilter)filter);
            }
            case MIN: {
                return (double)this.approvalStatsService.getMinimumTimeElapsedForApproval((ApprovalStatsFilter)filter);
            }
            case AVG: {
                return this.approvalStatsService.getAverageTimeElapsedForApproval((ApprovalStatsFilter)filter);
            }
        }
        return 0.0;
    }

    @POST
    @Path(value="/state")
    @WorkflowVisibilityPermissionsRequired
    @ReadOnlyAccessAllowed
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Retrieves the maximum/minimum/average time spent in a certain state.", response=Double.class)
    @ApiResponses(value={@ApiResponse(code=200, message="A time estimation was retrieved successfully"), @ApiResponse(code=400, message="Validation error of the input body"), @ApiResponse(code=401, message="Client is not authenticated"), @ApiResponse(code=403, message="User has not workflow visibility permissions"), @ApiResponse(code=500, message="Exception when trying to retrieve usage estimation")})
    public Response getUsageTimeInState(final @ApiParam(name="Document activity time spent in a certain state request") StateUsageStatsRequest request) {
        return new RestWorkflowCommand(this.workflowsFeatureManager, this.permissionManager, this.workflowPermissionManager, this.spaceManager){

            @Override
            public Response doExecute() {
                try {
                    UsageStatsResource.this.validateRequest(request);
                    return Response.ok().entity((Object)UsageStatsResource.this.getTimeInState(request)).build();
                }
                catch (IllegalArgumentException e) {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
                }
                catch (WorkflowException e) {
                    return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)e.getMessage()).build();
                }
                catch (Exception e) {
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
                }
            }
        }.execute(request != null ? request.getSpaceKeys() : null);
    }

    private void validateRequest(StateUsageStatsRequest request) throws WorkflowException {
        if (request == null) {
            throw new IllegalArgumentException("Invalid request");
        }
        this.statsValidator.validateState(request.getStateName());
        if (request.getUsageTimeEstimation() == null || !Arrays.stream(UsageStatsTimeEstimation.values()).map(UsageStatsTimeEstimation::getValue).collect(Collectors.toList()).contains(request.getUsageTimeEstimation())) {
            throw new IllegalArgumentException("Time estimation mode is a required field for this usage report");
        }
        this.spaces = this.statsValidator.validateSpaces(request.getSpaceKeys());
        if (request.getToDate() != null || request.getFromDate() != null) {
            this.statsValidator.validateDates(request.getFromDate(), request.getToDate());
        }
    }

    private Double getTimeInState(StateUsageStatsRequest request) throws WorkflowException {
        StatsFilter filter = ((StateStatsFilter.StateStatsFilterBuilder)((StateStatsFilter.StateStatsFilterBuilder)((StateStatsFilter.StateStatsFilterBuilder)((StateStatsFilter.StateStatsFilterBuilder)new StateStatsFilter().toBuilder().stateName(request.getStateName())).spaceKeys(this.spaces != null ? this.spaces.stream().map(Space::getKey).collect(Collectors.toList()) : null)).fromDate(request.getFromDate())).toDate(request.getToDate())).build();
        switch (Objects.requireNonNull(UsageStatsTimeEstimation.parse(request.getUsageTimeEstimation()))) {
            case MIN: {
                return (double)this.stateStatsService.getMinimumTimeElapsedInState((StateStatsFilter)filter);
            }
            case MAX: {
                return (double)this.stateStatsService.getMaximumTimeElapsedInState((StateStatsFilter)filter);
            }
            case AVG: {
                return this.stateStatsService.getAverageTimeElapsedInState((StateStatsFilter)filter);
            }
        }
        throw new WorkflowException("Invalid usage estimation");
    }

    @POST
    @Path(value="/assignee")
    @WorkflowVisibilityPermissionsRequired
    @ReadOnlyAccessAllowed
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Retrieves the maximum/minimum/average time spent by an assignee to approve a workflow.", response=Double.class)
    @ApiResponses(value={@ApiResponse(code=200, message="A time estimation was retrieved successfully"), @ApiResponse(code=400, message="Validation error of the input body"), @ApiResponse(code=401, message="Client is not authenticated"), @ApiResponse(code=403, message="User has not workflow visibility permissions"), @ApiResponse(code=500, message="Exception when trying to retrieve usage estimation")})
    public Response getUsageTimeByAssignee(final @ApiParam(name="Time spent by an assignee to approve a workflow request") AssigneeUsageStatsRequest request) {
        return new RestWorkflowCommand(this.workflowsFeatureManager, this.permissionManager, this.workflowPermissionManager, this.spaceManager){

            @Override
            public Response doExecute() {
                try {
                    UsageStatsResource.this.validateRequest(request);
                    return Response.ok().entity((Object)UsageStatsResource.this.getTimeByAssignee(request)).build();
                }
                catch (IllegalArgumentException e) {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
                }
                catch (WorkflowException e) {
                    return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)e.getMessage()).build();
                }
                catch (Exception e) {
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
                }
            }
        }.execute(request != null ? request.getSpaceKeys() : null);
    }

    private void validateRequest(AssigneeUsageStatsRequest request) throws WorkflowException {
        if (request == null) {
            throw new IllegalArgumentException("Invalid request");
        }
        this.statsValidator.validateAssignee(request.getAssignee());
        if (request.getUsageTimeEstimation() == null || !Arrays.stream(UsageStatsTimeEstimation.values()).map(UsageStatsTimeEstimation::getValue).collect(Collectors.toList()).contains(request.getUsageTimeEstimation())) {
            throw new IllegalArgumentException("Time estimation mode is a required field for this usage report");
        }
        if (request.getStateName() != null) {
            this.statsValidator.validateState(request.getStateName());
        }
        if (request.getApprovalName() != null) {
            this.statsValidator.validateApprovalName(request.getApprovalName());
        }
        this.spaces = this.statsValidator.validateSpaces(request.getSpaceKeys());
        if (request.getToDate() != null || request.getFromDate() != null) {
            this.statsValidator.validateDates(request.getFromDate(), request.getToDate());
        }
    }

    private Double getTimeByAssignee(AssigneeUsageStatsRequest request) throws WorkflowException {
        StatsFilter filter = ((ApprovalStatsFilter.ApprovalStatsFilterBuilder)((ApprovalStatsFilter.ApprovalStatsFilterBuilder)((ApprovalStatsFilter.ApprovalStatsFilterBuilder)((ApprovalStatsFilter.ApprovalStatsFilterBuilder)((StatsFilter.StatsFilterBuilder)((ApprovalStatsFilter.ApprovalStatsFilterBuilder)((ApprovalStatsFilter.ApprovalStatsFilterBuilder)new ApprovalStatsFilter().toBuilder()).assignee(request.getAssignee())).approvalName(request.getApprovalName())).stateName(request.getStateName())).spaceKeys(this.spaces != null ? this.spaces.stream().map(Space::getKey).collect(Collectors.toList()) : null)).fromDate(request.getFromDate())).toDate(request.getToDate())).build();
        switch (Objects.requireNonNull(UsageStatsTimeEstimation.parse(request.getUsageTimeEstimation()))) {
            case MIN: {
                return (double)this.approvalStatsService.getMinimumTimeAssigneeTookToApprove((ApprovalStatsFilter)filter);
            }
            case MAX: {
                return (double)this.approvalStatsService.getMaximumTimeAssigneeTookToApprove((ApprovalStatsFilter)filter);
            }
            case AVG: {
                return this.approvalStatsService.getAverageTimeAssigneeTookToApprove((ApprovalStatsFilter)filter);
            }
        }
        throw new WorkflowException("Invalid usage estimation");
    }
}

