/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.dataextractor;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.api.service.content.ContentService;
import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.rest.api.model.ExpansionsParser;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.longrunning.LongRunningTaskId;
import com.atlassian.confluence.util.longrunning.LongRunningTaskManager;
import com.atlassian.core.bean.EntityObject;
import com.atlassian.core.task.longrunning.LongRunningTask;
import com.atlassian.querylang.exceptions.InvalidDynamicFieldQueryException;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.user.User;
import com.comalatech.confluence.adhoc.AdhocWorkflowManager;
import com.comalatech.confluence.dataextractor.DataExtractorManager;
import com.comalatech.confluence.dataextractor.JsonContentPropertiesKeys;
import com.comalatech.confluence.dataextractor.JsonContentPropertyService;
import com.comalatech.confluence.dataextractor.extractor.WorkflowsPropertyExtractor;
import com.comalatech.confluence.dataextractor.model.FullWorklfowsContentPropertyModel;
import com.comalatech.confluence.dataextractor.task.DataExtractorPopulationTask;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import com.comalatech.confluence.readack.dataextractor.ReadAckPropertyExtractor;
import com.comalatech.confluence.tasks.extractor.TaskPropertyExtractor;
import com.comalatech.confluence.util.OverridePermissionsUtil;
import com.comalatech.confluence.workflow.WorkflowAdvancedConfigurationManager;
import com.comalatech.confluence.workflow.parameter.extractor.WorkflowParameterPropertyExtractor;
import com.comalatech.confluence.workflowcontainer.WorkflowContainerManager;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class DefaultDataExtractorManager
implements DataExtractorManager,
ApplicationContextAware,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(DefaultDataExtractorManager.class);
    private static final int CQL_PENDING_PAGES_BATCH = 200;
    private static final String CQL_PENDING_PAGES_QUERY = "awphasworkflow=true AND content.property[comalaworkflowsglobalmodelversion].version!=4";
    private static final String CQL_PENDING_PAGES_EXPAND = "metadata.properties.comalaworkflows";
    private static final int CQL_PENDING_PAGES_POPULATOR_RETRIES = 5;
    private static final int CQL_PENDING_PAGES_POPULATOR_LAPSE = 10000;
    private ApplicationContext applicationContext;
    protected final AdhocWorkflowManager adhocWorkflowManager;
    protected final WorkflowContainerManager workflowContainerManager;
    protected final ContentService contentService;
    protected final WorkflowsPropertyExtractor workflowsPropertyExtractor;
    protected final LongRunningTaskManager longRunningTaskManager;
    protected final CQLSearchService cqlSearchService;
    protected final PageManager pageManager;
    protected final TransactionTemplate transactionTemplate;
    protected final AccessModeService accessModeService;
    protected final WorkflowAdvancedConfigurationManager workflowAdvancedConfigurationManager;
    protected ReadAckPropertyExtractor readAckPropertyExtractor;
    protected TaskPropertyExtractor taskPropertyExtractor;
    protected final WorkflowParameterPropertyExtractor workflowParameterPropertyExtractor;
    protected final JsonContentPropertyService jsonContentPropertyService;
    protected final OverridePermissionsUtil overridePermissionsUtil;
    protected final ComalaI18nBean comalaI18nBean;

    public DefaultDataExtractorManager(AdhocWorkflowManager adhocWorkflowManager, WorkflowContainerManager workflowContainerManager, ContentService contentService, WorkflowsPropertyExtractor workflowsPropertyExtractor, LongRunningTaskManager longRunningTaskManager, CQLSearchService cqlSearchService, PageManager pageManager, TransactionTemplate transactionTemplate, AccessModeService accessModeService, WorkflowAdvancedConfigurationManager workflowAdvancedConfigurationManager, JsonContentPropertyService jsonContentPropertyService, WorkflowParameterPropertyExtractor workflowParameterPropertyExtractor, OverridePermissionsUtil overridePermissionsUtil, ComalaI18nBean comalaI18nBean) {
        this.adhocWorkflowManager = adhocWorkflowManager;
        this.workflowContainerManager = workflowContainerManager;
        this.contentService = contentService;
        this.workflowsPropertyExtractor = workflowsPropertyExtractor;
        this.longRunningTaskManager = longRunningTaskManager;
        this.cqlSearchService = cqlSearchService;
        this.pageManager = pageManager;
        this.transactionTemplate = transactionTemplate;
        this.accessModeService = accessModeService;
        this.workflowAdvancedConfigurationManager = workflowAdvancedConfigurationManager;
        this.jsonContentPropertyService = jsonContentPropertyService;
        this.workflowParameterPropertyExtractor = workflowParameterPropertyExtractor;
        this.overridePermissionsUtil = overridePermissionsUtil;
        this.comalaI18nBean = comalaI18nBean;
    }

    public void afterPropertiesSet() {
        this.readAckPropertyExtractor = (ReadAckPropertyExtractor)this.applicationContext.getBean("readAckPropertyExtractor", ReadAckPropertyExtractor.class);
        this.taskPropertyExtractor = (TaskPropertyExtractor)this.applicationContext.getBean("taskPropertyExtractor", TaskPropertyExtractor.class);
    }

    public void setApplicationContext(@NotNull ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public boolean updateAllContentProperties(EntityObject entityObject) {
        return this.updateContentProperties(entityObject, JsonContentPropertiesKeys.getGroupsOfJsonCPs());
    }

    @Override
    public boolean updateWorkflowsContentProperties(EntityObject entityObject) {
        return this.updateContentProperties(entityObject, Collections.singletonList("workflows"));
    }

    @Override
    public boolean updateWorkflowParametersContentProperties(EntityObject entityObject) {
        return this.updateContentProperties(entityObject, Collections.singletonList("parameters"));
    }

    @Override
    public boolean updateReadAckContentProperties(EntityObject entityObject) {
        return this.updateContentProperties(entityObject, Collections.singletonList("readacks"));
    }

    @Override
    public boolean updateTasksContentProperties(EntityObject entityObject) {
        return this.updateContentProperties(entityObject, Collections.singletonList("tasks"));
    }

    @Override
    public boolean clearAllContentProperties(EntityObject entityObject) {
        if (!this.isPage(entityObject)) {
            return false;
        }
        AbstractPage abstractPage = (AbstractPage)entityObject;
        Content content = (Content)this.contentService.find(new Expansion[0]).withId(abstractPage.getContentId()).fetchOrNull();
        if (content == null) {
            log.warn("There is no content belonging to " + abstractPage + ". Is not possible to attach any workflows content property data.");
            return false;
        }
        return this.overridePermissionsUtil.executeWithExemption(() -> this.clearAllContentPropertiesInternal(content));
    }

    protected boolean updateContentProperties(EntityObject entityObject, List<String> keys) {
        if (!this.isPage(entityObject)) {
            return false;
        }
        AbstractPage abstractPage = (AbstractPage)entityObject;
        if (!this.hasWorkflows(abstractPage)) {
            return this.clearAllContentProperties((EntityObject)abstractPage);
        }
        return this.overridePermissionsUtil.executeWithExemption(() -> this.createOrUpdateContentProperties(entityObject, keys));
    }

    private boolean clearAllContentPropertiesInternal(Content content) {
        boolean success = true;
        for (String cp : JsonContentPropertiesKeys.getAllJsonCPs()) {
            success = this.jsonContentPropertyService.delete(content, cp) && success;
        }
        return success;
    }

    private boolean isPage(EntityObject entityObject) {
        return entityObject instanceof AbstractPage;
    }

    private boolean hasWorkflows(AbstractPage page) {
        return this.workflowContainerManager.hasProductionWorkflows(page) || this.adhocWorkflowManager.hasWorkflow(page);
    }

    protected boolean createOrUpdateContentProperties(EntityObject entityObject, List<String> keys) {
        AbstractPage page = (AbstractPage)entityObject;
        int index = 0;
        boolean success = true;
        String key = "";
        try {
            Content content = (Content)this.contentService.find(new Expansion[0]).withId(page.getContentId()).fetchOrNull();
            if (content == null) {
                log.warn("There is no content belonging to " + page + ". Is not possible to attach any workflows content property data.");
                return false;
            }
            while (success && index < keys.size()) {
                key = keys.get(index++);
                success = this.doUpdateMethodForKey(page, content, key);
            }
            if (success) {
                success = this.updateGlobalModelVersion(content);
            }
            if (!success) {
                log.warn("properties creating / update failed when processing the key:" + key + ", of page:" + page);
            }
            return success;
        }
        catch (Exception e) {
            log.error("Problems saving " + key + " associated to " + page, (Throwable)e);
            return false;
        }
    }

    private boolean doUpdateMethodForKey(AbstractPage page, Content content, String key) {
        switch (key) {
            case "workflows": {
                return this.updateWorkflowsContentProperties(page, content);
            }
            case "readacks": {
                return this.updateReadAckContentProperties(page, content);
            }
            case "tasks": {
                return this.updateTasksContentProperties(page, content);
            }
            case "parameters": {
                return this.updateWorkflowParametersContentProperties(page, content);
            }
        }
        return false;
    }

    private boolean updateGlobalModelVersion(Content content) {
        String globalModelVersionJson = this.workflowsPropertyExtractor.getCurrentGlobalModelVersionJson();
        return this.jsonContentPropertyService.updateOrCreate(content, "comalaworkflowsglobalmodelversion", globalModelVersionJson);
    }

    private boolean updateReadAckContentProperties(AbstractPage page, Content content) {
        String jsonString = this.readAckPropertyExtractor.getJsonOf(page);
        return this.jsonContentPropertyService.updateOrCreate(content, "readack", jsonString);
    }

    private boolean updateTasksContentProperties(AbstractPage page, Content content) {
        String taskContentPropertyAsJson = this.taskPropertyExtractor.getJsonOf(page);
        boolean successfulPropertyUpdate = this.jsonContentPropertyService.updateOrCreate(content, "comalaworkflowstasks", taskContentPropertyAsJson);
        boolean successfulModelUpdate = this.jsonContentPropertyService.updateOrCreate(content, "comalaworkflowstaskscurrentmodelversion", this.taskPropertyExtractor.getCurrentTaskModelVersionJson());
        return successfulModelUpdate && successfulPropertyUpdate;
    }

    private boolean updateWorkflowParametersContentProperties(AbstractPage page, Content content) {
        String wpContentPropertyAsJson = this.workflowParameterPropertyExtractor.getJsonOf(page);
        boolean successfulPropertyUpdate = this.jsonContentPropertyService.updateOrCreate(content, "comalaworkflowparameters", wpContentPropertyAsJson);
        boolean successfulModelUpdate = this.jsonContentPropertyService.updateOrCreate(content, "comalaworkflowsworkflowparameterscurrentmodelversion", this.workflowParameterPropertyExtractor.getCurrentWorkflowParameterModelVersionJson());
        return successfulModelUpdate && successfulPropertyUpdate;
    }

    private boolean updateWorkflowsContentProperties(AbstractPage page, Content content) {
        FullWorklfowsContentPropertyModel fwcpModel = this.workflowsPropertyExtractor.getFullWorkflowsContentPropertyModel(page);
        if (fwcpModel == null) {
            log.warn("Could not update workflows content properties because page " + page.getIdAsString() + " doesn't contain workflow with states");
            return false;
        }
        boolean successfulUpdate = this.jsonContentPropertyService.updateOrCreate(content, "comalaworkflows", this.workflowsPropertyExtractor.serialize(fwcpModel.workflowsContentPropertyModel));
        successfulUpdate = this.jsonContentPropertyService.updateOrCreate(content, "comalaworkflowsapprovals", this.workflowsPropertyExtractor.serialize(fwcpModel.approvals)) && successfulUpdate;
        successfulUpdate = this.jsonContentPropertyService.updateOrCreate(content, "comalaworkflowsapprovedapprovals", this.workflowsPropertyExtractor.serialize(fwcpModel.approvedApprovals)) && successfulUpdate;
        successfulUpdate = this.jsonContentPropertyService.updateOrCreate(content, "comalaworkflowspendingapprovals", this.workflowsPropertyExtractor.serialize(fwcpModel.pendingApprovals)) && successfulUpdate;
        successfulUpdate = this.jsonContentPropertyService.updateOrCreate(content, "comalaworkflowsrejectedapprovals", this.workflowsPropertyExtractor.serialize(fwcpModel.rejectedApprovals)) && successfulUpdate;
        successfulUpdate = this.jsonContentPropertyService.updateOrCreate(content, "comalaworkflowspendingapprovers", this.workflowsPropertyExtractor.serialize(fwcpModel.pendingApprovers)) && successfulUpdate;
        successfulUpdate = this.jsonContentPropertyService.updateOrCreate(content, "comalaworkflowsfinishedapprovers", this.workflowsPropertyExtractor.serialize(fwcpModel.finishedApprovers)) && successfulUpdate;
        successfulUpdate = this.jsonContentPropertyService.updateOrCreate(content, "comalaworkflowslastfinalversionapprovers", this.workflowsPropertyExtractor.serialize(fwcpModel.lastFinalVersionApprovers)) && successfulUpdate;
        successfulUpdate = this.jsonContentPropertyService.updateOrCreate(content, "comalaworflowscurrentmodelversion", this.workflowsPropertyExtractor.getCurrentWorkflowsModelVersionJson()) && successfulUpdate;
        return successfulUpdate;
    }

    @Override
    public LongRunningTaskId launchPopulatorTaskForSpace(Space space) {
        if (log.isDebugEnabled()) {
            log.debug("Pages and blog posts retrieval start");
        }
        HashSet<Long> pagesAndBlogsIds = new HashSet<Long>();
        if (space != null) {
            this.pageManager.getPages(space, true).forEach(page -> pagesAndBlogsIds.add(page.getId()));
            this.pageManager.getBlogPosts(space, true).forEach(blogPost -> pagesAndBlogsIds.add(blogPost.getId()));
        }
        if (log.isDebugEnabled()) {
            log.debug("Total number of pages and blog posts found in space " + (space != null ? space.getKey() : null) + ": " + pagesAndBlogsIds.size());
        }
        DataExtractorPopulationTask task = DataExtractorPopulationTask.fromDeps(this.transactionTemplate, this, this.pageManager, this.accessModeService, this.workflowAdvancedConfigurationManager, this.comalaI18nBean).setPageIds(pagesAndBlogsIds);
        return this.longRunningTaskManager.startLongRunningTask((User)AuthenticatedUserThreadLocal.get(), (LongRunningTask)task);
    }

    private PageResponse<Content> cqlSearchContentWithRetries(int offset, int retries) {
        try {
            return this.cqlSearchService.searchContent(CQL_PENDING_PAGES_QUERY, (PageRequest)new SimplePageRequest(offset, 200), ExpansionsParser.parse((String)CQL_PENDING_PAGES_EXPAND));
        }
        catch (Exception ex) {
            if (retries > 0) {
                try {
                    Thread.sleep(10000L);
                    return this.cqlSearchContentWithRetries(offset, retries - 1);
                }
                catch (InterruptedException iex) {
                    log.error(iex.getMessage());
                }
            } else if (ex instanceof InvalidDynamicFieldQueryException || ex instanceof BadRequestException) {
                log.debug("After all retries, invalid query happened", (Throwable)ex);
            } else {
                log.error(ex.getMessage());
            }
            return null;
        }
    }

    private Set<Long> getPageIds() {
        PageResponse<Content> results;
        if (log.isDebugEnabled()) {
            log.debug("Starting getting pageIds");
        }
        int offset = 0;
        HashSet<Long> pageIds = new HashSet<Long>();
        do {
            if ((results = this.cqlSearchContentWithRetries(offset, 5)) != null) {
                for (Content content : results.getResults()) {
                    pageIds.add(content.getId().asLong());
                }
            }
            offset += 200;
        } while (results != null && results.hasMore());
        if (log.isDebugEnabled()) {
            log.debug("Finished getting pageIds, " + pageIds.size() + " ids have been gathered");
        }
        return pageIds;
    }

    @Override
    public LongRunningTaskId launchPopulatorTaskForNotPopulatedPages() {
        if (log.isDebugEnabled()) {
            log.debug("Launching population task");
        }
        DataExtractorPopulationTask task = DataExtractorPopulationTask.fromDeps(this.transactionTemplate, this, this.pageManager, this.accessModeService, this.workflowAdvancedConfigurationManager, this.comalaI18nBean).setPageIdSupplier(this::getPageIds);
        return this.longRunningTaskManager.startLongRunningTask((User)AuthenticatedUserThreadLocal.get(), (LongRunningTask)task);
    }
}

