/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.cloud.migration.actions;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.user.User;
import com.atlassian.xwork.ParameterSafe;
import com.comalatech.confluence.cloud.migration.entity.domain.activity.ActionDetail;
import com.comalatech.confluence.cloud.migration.entity.domain.activity.ActionType;
import com.comalatech.confluence.cloud.migration.entity.domain.migration.Migration;
import com.comalatech.confluence.cloud.migration.usecases.contracts.GenerateCloudMappings;
import com.comalatech.confluence.cloud.migration.usecases.contracts.GeneratePageActivityMigrationData;
import com.comalatech.confluence.cloud.migration.usecases.infrastructure.jackonMixins.ActionDetailMixing;
import com.comalatech.confluence.cloud.migration.usecases.infrastructure.jackonMixins.ActionTypeMixing;
import com.comalatech.confluence.documentActivity.domain.entities.Activity;
import com.comalatech.confluence.license.AdhocWorkflowsLicenseManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationDebugAction
extends ConfluenceActionSupport {
    private static final Logger log = LoggerFactory.getLogger(MigrationDebugAction.class);
    private GenerateCloudMappings generateCloudMappings;
    private GeneratePageActivityMigrationData pageActivityGeneratorUseCase;
    private AdhocWorkflowsLicenseManager licenseManager;
    private String migrationStr;
    private String spaceKey;

    public String execute() {
        if (!this.licenseManager.isLicensed()) {
            this.migrationStr = "Invalid license";
            return "success";
        }
        List<String> spaceList = Collections.singletonList(this.spaceKey);
        try {
            String result;
            HashMap<AbstractPage, List<Activity>> pageActivitiesMap = new HashMap<AbstractPage, List<Activity>>(this.pageActivityGeneratorUseCase.generatePageCurrentActivityForSpace(spaceList));
            Migration migration = this.generateCloudMappings.generateMigrationDebugData(pageActivitiesMap);
            ObjectMapper mapper = new ObjectMapper();
            try {
                mapper.getSerializationConfig().addMixInAnnotations(ActionDetail.Type.class, ActionDetailMixing.class);
                mapper.getSerializationConfig().addMixInAnnotations(ActionType.Type.class, ActionTypeMixing.class);
                mapper.setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
                result = mapper.writeValueAsString((Object)migration);
                if (result.equalsIgnoreCase("null")) {
                    result = "{}";
                }
            }
            catch (Exception e) {
                log.error("Error serializing data {}", (Object)migration, (Object)e);
                result = "{}";
            }
            this.migrationStr = result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return "success";
    }

    public boolean isPermitted() {
        return this.permissionManager.hasPermission((User)this.getAuthenticatedUser(), Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION);
    }

    public String getMigrationStr() {
        return this.migrationStr;
    }

    @ParameterSafe
    public void setMigrationStr(String migrationStr) {
        this.migrationStr = migrationStr;
    }

    public void setGenerateCloudMappings(GenerateCloudMappings generateCloudMappings) {
        this.generateCloudMappings = generateCloudMappings;
    }

    public void setPageActivityGeneratorUseCase(GeneratePageActivityMigrationData pageActivityGeneratorUseCase) {
        this.pageActivityGeneratorUseCase = pageActivityGeneratorUseCase;
    }

    public void setLicenseManager(AdhocWorkflowsLicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    @ParameterSafe
    public void setSpaceKey(String spaceKey) {
        this.spaceKey = spaceKey;
    }

    public String getSpaceKey() {
        return this.spaceKey;
    }
}

